/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import org.compiere.model.MCommission;
import org.compiere.model.MCommissionAmt;
import org.compiere.model.MCommissionDetail;
import org.compiere.model.MCommissionLine;
import org.compiere.model.MCommissionRun;
import org.compiere.model.MCurrency;
import org.compiere.model.MUser;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.CompiereSystemException;
import org.compiere.util.CompiereUserException;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Language;

public class CommissionCalc
extends SvrProcess {
    private Timestamp p_StartDate;
    private Timestamp m_EndDate;
    private MCommission m_com;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("StartDate")) {
                this.p_StartDate = (Timestamp)para[i].getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    protected String doIt() throws Exception {
        this.log.info("C_Commission_ID=" + this.getRecord_ID() + ", StartDate=" + this.p_StartDate);
        if (this.p_StartDate == null) {
            this.p_StartDate = new Timestamp(System.currentTimeMillis());
        }
        this.m_com = new MCommission(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        if (this.m_com.get_ID() == 0) {
            throw new CompiereUserException("No Commission");
        }
        MCommissionRun comRun = new MCommissionRun(this.m_com);
        this.setStartEndDate();
        comRun.setStartDate(this.p_StartDate);
        SimpleDateFormat format = DisplayType.getDateFormat((int)15);
        String description = format.format(this.p_StartDate) + " - " + format.format(this.m_EndDate) + " - " + MCurrency.getISO_Code((Ctx)this.getCtx(), (int)this.m_com.getC_Currency_ID());
        comRun.setDescription(description);
        if (!comRun.save()) {
            throw new CompiereSystemException("Could not save Commission Run");
        }
        MCommissionLine[] lines = this.m_com.getLines();
        for (int i = 0; i < lines.length; ++i) {
            MCommissionAmt comAmt = new MCommissionAmt(comRun, lines[i].getC_CommissionLine_ID());
            if (!comAmt.save()) {
                throw new CompiereSystemException("Could not save Commission Amt");
            }
            StringBuffer sql = new StringBuffer();
            if ("R".equals(this.m_com.getDocBasisType())) {
                if (this.m_com.isListDetails()) {
                    sql.append("SELECT h.C_Currency_ID, (l.LineNetAmt*al.Amount/h.GrandTotal) AS Amt, (l.QtyInvoiced*al.Amount/h.GrandTotal) AS Qty, NULL, l.C_InvoiceLine_ID, p.DocumentNo||'_'||h.DocumentNo, COALESCE(prd.Value,l.Description), h.DateInvoiced FROM C_Payment p INNER JOIN C_AllocationLine al ON (p.C_Payment_ID=al.C_Payment_ID) INNER JOIN C_Invoice h ON (al.C_Invoice_ID = h.C_Invoice_ID) INNER JOIN C_InvoiceLine l ON (h.C_Invoice_ID = l.C_Invoice_ID)  LEFT OUTER JOIN M_Product prd ON (l.M_Product_ID = prd.M_Product_ID) WHERE p.DocStatus IN ('CL','CO','RE') AND h.IsSOTrx='Y' AND p.AD_Client_ID = ? AND p.DateTrx BETWEEN ? AND ?");
                } else {
                    sql.append("SELECT h.C_Currency_ID, SUM(l.LineNetAmt*al.Amount/h.GrandTotal) AS Amt, SUM(l.QtyInvoiced*al.Amount/h.GrandTotal) AS Qty, NULL, NULL, NULL, NULL, MAX(h.DateInvoiced) FROM C_Payment p INNER JOIN C_AllocationLine al ON (p.C_Payment_ID=al.C_Payment_ID) INNER JOIN C_Invoice h ON (al.C_Invoice_ID = h.C_Invoice_ID) INNER JOIN C_InvoiceLine l ON (h.C_Invoice_ID = l.C_Invoice_ID) WHERE p.DocStatus IN ('CL','CO','RE') AND h.IsSOTrx='Y' AND p.AD_Client_ID = ? AND p.DateTrx BETWEEN ? AND ?");
                }
            } else if ("O".equals(this.m_com.getDocBasisType())) {
                if (this.m_com.isListDetails()) {
                    sql.append("SELECT h.C_Currency_ID, l.LineNetAmt, l.QtyOrdered, l.C_OrderLine_ID, NULL, h.DocumentNo, COALESCE(prd.Value,l.Description),h.DateOrdered FROM C_Order h INNER JOIN C_OrderLine l ON (h.C_Order_ID = l.C_Order_ID) LEFT OUTER JOIN M_Product prd ON (l.M_Product_ID = prd.M_Product_ID) WHERE h.DocStatus IN ('CL','CO') AND h.IsSOTrx='Y' AND h.AD_Client_ID = ? AND h.DateOrdered BETWEEN ? AND ?");
                } else {
                    sql.append("SELECT h.C_Currency_ID, SUM(l.LineNetAmt) AS Amt, SUM(l.QtyOrdered) AS Qty, NULL, NULL, NULL, NULL, MAX(h.DateOrdered) FROM C_Order h INNER JOIN C_OrderLine l ON (h.C_Order_ID = l.C_Order_ID) WHERE h.DocStatus IN ('CL','CO') AND h.IsSOTrx='Y' AND h.AD_Client_ID = ? AND h.DateOrdered BETWEEN ? AND ?");
                }
            } else if (this.m_com.isListDetails()) {
                sql.append("SELECT h.C_Currency_ID, l.LineNetAmt, l.QtyInvoiced, NULL, l.C_InvoiceLine_ID, h.DocumentNo, COALESCE(prd.Value,l.Description),h.DateInvoiced FROM C_Invoice h INNER JOIN C_InvoiceLine l ON (h.C_Invoice_ID = l.C_Invoice_ID) LEFT OUTER JOIN M_Product prd ON (l.M_Product_ID = prd.M_Product_ID) WHERE h.DocStatus IN ('CL','CO','RE') AND h.IsSOTrx='Y' AND h.AD_Client_ID = ? AND h.DateInvoiced BETWEEN ? AND ?");
            } else {
                sql.append("SELECT h.C_Currency_ID, SUM(l.LineNetAmt) AS Amt, SUM(l.QtyInvoiced) AS Qty, NULL, NULL, NULL, NULL, MAX(h.DateInvoiced) FROM C_Invoice h INNER JOIN C_InvoiceLine l ON (h.C_Invoice_ID = l.C_Invoice_ID) WHERE h.DocStatus IN ('CL','CO','RE') AND h.IsSOTrx='Y' AND h.AD_Client_ID = ? AND h.DateInvoiced BETWEEN ? AND ?");
            }
            if (lines[i].isCommissionOrders()) {
                MUser[] users = MUser.getOfBPartner((Ctx)this.getCtx(), (int)this.m_com.getC_BPartner_ID());
                if (users == null || users.length == 0) {
                    throw new CompiereUserException("Commission Business Partner has no Users/Contact");
                }
                if (users.length == 1) {
                    int SalesRep_ID = users[0].getAD_User_ID();
                    sql.append(" AND h.SalesRep_ID=").append(SalesRep_ID);
                } else {
                    this.log.warning("Not 1 User/Contact for C_BPartner_ID=" + this.m_com.getC_BPartner_ID() + " but " + users.length);
                    sql.append(" AND h.SalesRep_ID IN (SELECT AD_User_ID FROM AD_User WHERE C_BPartner_ID=").append(this.m_com.getC_BPartner_ID()).append(")");
                }
            }
            if (lines[i].getOrg_ID() != 0) {
                sql.append(" AND h.AD_Org_ID=").append(lines[i].getOrg_ID());
            }
            if (lines[i].getC_BPartner_ID() != 0) {
                sql.append(" AND h.C_BPartner_ID=").append(lines[i].getC_BPartner_ID());
            }
            if (lines[i].getC_BP_Group_ID() != 0) {
                sql.append(" AND h.C_BPartner_ID IN (SELECT C_BPartner_ID FROM C_BPartner WHERE C_BP_Group_ID=").append(lines[i].getC_BP_Group_ID()).append(")");
            }
            if (lines[i].getC_SalesRegion_ID() != 0) {
                sql.append(" AND h.C_BPartner_Location_ID IN (SELECT C_BPartner_Location_ID FROM C_BPartner_Location WHERE C_SalesRegion_ID=").append(lines[i].getC_SalesRegion_ID()).append(")");
            }
            if (lines[i].getM_Product_ID() != 0) {
                sql.append(" AND l.M_Product_ID=").append(lines[i].getM_Product_ID());
            }
            if (lines[i].getM_Product_Category_ID() != 0) {
                sql.append(" AND l.M_Product_ID IN (SELECT M_Product_ID FROM M_Product WHERE M_Product_Category_ID=").append(lines[i].getM_Product_Category_ID()).append(")");
            }
            if (!this.m_com.isListDetails()) {
                sql.append(" GROUP BY h.C_Currency_ID");
            }
            this.log.fine("Line=" + lines[i].getLine() + " - " + sql);
            this.createDetail(sql.toString(), comAmt);
            comAmt.calculateCommission();
            comAmt.save();
        }
        this.m_com.setDateLastRun(this.p_StartDate);
        this.m_com.save();
        return "@C_CommissionRun_ID@ = " + comRun.getDocumentNo() + " - " + comRun.getDescription();
    }

    private void setStartEndDate() {
        GregorianCalendar cal = new GregorianCalendar(Language.getLoginLanguage().getLocale());
        cal.setTimeInMillis(this.p_StartDate.getTime());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        if ("Y".equals(this.m_com.getFrequencyType())) {
            cal.set(6, 1);
            this.p_StartDate = new Timestamp(cal.getTimeInMillis());
            cal.add(1, 1);
            cal.add(6, -1);
            this.m_EndDate = new Timestamp(cal.getTimeInMillis());
        } else if ("Q".equals(this.m_com.getFrequencyType())) {
            cal.set(5, 1);
            int month = cal.get(2);
            if (month < 3) {
                cal.set(2, 0);
            } else if (month < 6) {
                cal.set(2, 3);
            } else if (month < 9) {
                cal.set(2, 6);
            } else {
                cal.set(2, 9);
            }
            this.p_StartDate = new Timestamp(cal.getTimeInMillis());
            cal.add(2, 3);
            cal.add(6, -1);
            this.m_EndDate = new Timestamp(cal.getTimeInMillis());
        } else if ("W".equals(this.m_com.getFrequencyType())) {
            cal.set(7, 1);
            this.p_StartDate = new Timestamp(cal.getTimeInMillis());
            cal.add(6, 7);
            this.m_EndDate = new Timestamp(cal.getTimeInMillis());
        } else {
            cal.set(5, 1);
            this.p_StartDate = new Timestamp(cal.getTimeInMillis());
            cal.add(2, 1);
            cal.add(6, -1);
            this.m_EndDate = new Timestamp(cal.getTimeInMillis());
        }
        this.log.fine("setStartEndDate = " + this.p_StartDate + " - " + this.m_EndDate);
    }

    private void createDetail(String sql, MCommissionAmt comAmt) {
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.m_com.getAD_Client_ID());
            pstmt.setTimestamp(2, this.p_StartDate);
            pstmt.setTimestamp(3, this.m_EndDate);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MCommissionDetail cd = new MCommissionDetail(comAmt, rs.getInt(1), rs.getBigDecimal(2), rs.getBigDecimal(3));
                cd.setLineIDs(rs.getInt(4), rs.getInt(5));
                String s = rs.getString(6);
                if (s != null) {
                    cd.setReference(s);
                }
                if ((s = rs.getString(7)) != null) {
                    cd.setInfo(s);
                }
                Timestamp date = rs.getTimestamp(8);
                cd.setConvertedAmt(date);
                if (cd.save()) continue;
                throw new IllegalArgumentException("CommissionCalc - Detail Not saved");
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "createDetail", (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
    }
}

