/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.compiere.model.MEntityType;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CompiereSystemException;
import org.compiere.util.CompiereUserException;
import org.compiere.util.Ctx;
import org.compiere.util.Env;

public class EntityTypeComponent
extends SvrProcess {
    protected int p_AD_EntityType_ID = 0;
    protected String p_directory = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("JarDirectory")) {
                this.p_directory = (String)para[i].getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.p_AD_EntityType_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        this.log.info("AD_EntityType_ID=" + this.p_AD_EntityType_ID + ", JarDirectory=" + this.p_directory);
        MEntityType et = MEntityType.getEntityType((Ctx)this.getCtx(), (int)this.p_AD_EntityType_ID);
        String EntityType = et.getEntityType();
        if (EntityType.equals("D")) {
            throw new CompiereUserException("You cannot create a Dictionary Component");
        }
        if (this.p_directory == null || this.p_directory.length() == 0) {
            this.p_directory = "";
        } else if (!this.p_directory.endsWith("/") && !this.p_directory.endsWith("\\")) {
            this.p_directory = this.p_directory + File.separator;
        }
        boolean forWindows = Env.isWindows();
        String classPath = et.getClasspath(forWindows);
        StringTokenizer st = new StringTokenizer(classPath, ",;: ", false);
        ArrayList<String> jars = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String jarName = st.nextToken();
            if (jarName.length() == 0) continue;
            String fileName = this.p_directory + jarName;
            File file = new File(fileName);
            if (!file.exists() || !file.isFile()) {
                throw new CompiereUserException("Cannot find: " + fileName);
            }
            jars.add(fileName);
        }
        Class[] parameterTypes = new Class[]{String.class, List.class};
        Object[] args = new Object[]{EntityType, jars};
        Object info = null;
        try {
            Class<?> clazz = Class.forName("com.compiere.client.StartComponent");
            Object instance = clazz.newInstance();
            Method method = clazz.getMethod("createComponent", parameterTypes);
            info = method.invoke(instance, args);
        }
        catch (Exception e) {
            throw new CompiereSystemException(e.toString());
        }
        if (info != null) {
            return info.toString();
        }
        throw new CompiereSystemException("Please check Log");
    }
}

