/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MProduct;
import org.compiere.model.X_I_Inventory;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.TimeUtil;

public class ImportInventory
extends SvrProcess {
    private int p_AD_Client_ID = 0;
    private int p_AD_Org_ID = 0;
    private int p_M_Locator_ID = 0;
    private Timestamp p_MovementDate = null;
    private boolean p_DeleteOldImported = false;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("AD_Client_ID")) {
                this.p_AD_Client_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("AD_Org_ID")) {
                this.p_AD_Org_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("M_Locator_ID")) {
                this.p_M_Locator_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("MovementDate")) {
                this.p_MovementDate = (Timestamp)para[i].getParameter();
                continue;
            }
            if (name.equals("DeleteOldImported")) {
                this.p_DeleteOldImported = "Y".equals(para[i].getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    protected String doIt() throws Exception {
        this.log.info("M_Locator_ID=" + this.p_M_Locator_ID + ",MovementDate=" + this.p_MovementDate);
        StringBuffer sql = null;
        int no = 0;
        String clientCheck = " AND AD_Client_ID=" + this.p_AD_Client_ID;
        if (this.p_DeleteOldImported) {
            sql = new StringBuffer("DELETE FROM I_Inventory WHERE I_IsImported='Y'").append(clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            this.log.fine("Delete Old Impored =" + no);
        }
        sql = new StringBuffer("UPDATE I_Inventory SET AD_Client_ID = COALESCE (AD_Client_ID,").append(this.p_AD_Client_ID).append("), AD_Org_ID = COALESCE (AD_Org_ID,").append(this.p_AD_Org_ID).append("),");
        if (this.p_MovementDate != null) {
            sql.append(" MovementDate = COALESCE (MovementDate,").append(DB.TO_DATE((Timestamp)this.p_MovementDate)).append("),");
        }
        sql.append(" IsActive = COALESCE (IsActive, 'Y'), Created = COALESCE (Created, SysDate), CreatedBy = COALESCE (CreatedBy, 0), Updated = COALESCE (Updated, SysDate), UpdatedBy = COALESCE (UpdatedBy, 0), I_ErrorMsg = NULL, M_Warehouse_ID = NULL, I_IsImported = 'N' WHERE I_IsImported<>'Y' OR I_IsImported IS NULL");
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.info("Reset=" + no);
        String ts = DB.isPostgreSQL() ? "COALESCE(I_ErrorMsg,'')" : "I_ErrorMsg";
        sql = new StringBuffer("UPDATE I_Inventory o SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=Invalid Org, '" + "WHERE (AD_Org_ID IS NULL OR AD_Org_ID=0" + " OR EXISTS (SELECT * FROM AD_Org oo WHERE o.AD_Org_ID=oo.AD_Org_ID AND (oo.IsSummary='Y' OR oo.IsActive='N')))" + " AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid Org=" + no);
        }
        sql = new StringBuffer("UPDATE I_Inventory i SET M_Warehouse_ID=(SELECT MAX(M_Warehouse_ID) FROM M_Warehouse w WHERE i.WarehouseValue=w.Value AND i.AD_Client_ID=w.AD_Client_ID) WHERE M_Warehouse_ID IS NULL AND WarehouseValue IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Warehouse from Value =" + no);
        sql = new StringBuffer("UPDATE I_Inventory i SET M_Locator_ID=(SELECT MAX(M_Locator_ID) FROM M_Locator l WHERE i.LocatorValue=l.Value AND COALESCE (i.M_Warehouse_ID, l.M_Warehouse_ID)=l.M_Warehouse_ID AND i.AD_Client_ID=l.AD_Client_ID) WHERE M_Locator_ID IS NULL AND LocatorValue IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Locator from Value =" + no);
        sql = new StringBuffer("UPDATE I_Inventory i SET M_Locator_ID=(SELECT MAX(M_Locator_ID) FROM M_Locator l WHERE i.X=l.X AND i.Y=l.Y AND i.Z=l.Z AND COALESCE (i.M_Warehouse_ID, l.M_Warehouse_ID)=l.M_Warehouse_ID AND i.AD_Client_ID=l.AD_Client_ID) WHERE M_Locator_ID IS NULL AND X IS NOT NULL AND Y IS NOT NULL AND Z IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Locator from X,Y,Z =" + no);
        if (this.p_M_Locator_ID != 0) {
            sql = new StringBuffer("UPDATE I_Inventory SET M_Locator_ID = ").append(this.p_M_Locator_ID).append(" WHERE M_Locator_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            this.log.fine("Set Locator from Parameter=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuffer("UPDATE I_Inventory SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=No Location, ' " + "WHERE M_Locator_ID IS NULL" + " AND I_IsImported<>'Y'").append(clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
            this.log.warning("No Location=" + no);
        }
        sql = new StringBuffer("UPDATE I_Inventory i SET M_Warehouse_ID=(SELECT M_Warehouse_ID FROM M_Locator l WHERE i.M_Locator_ID=l.M_Locator_ID) WHERE M_Locator_ID IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Warehouse from Locator =" + no);
        sql = new StringBuffer("UPDATE I_Inventory SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=No Warehouse, ' " + "WHERE M_Warehouse_ID IS NULL" + " AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("No Warehouse=" + no);
        }
        sql = new StringBuffer("UPDATE I_Inventory i SET M_Product_ID=(SELECT MAX(M_Product_ID) FROM M_Product p WHERE i.Value=p.Value AND i.AD_Client_ID=p.AD_Client_ID) WHERE M_Product_ID IS NULL AND Value IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Product from Value=" + no);
        sql = new StringBuffer("UPDATE I_Inventory i SET M_Product_ID=(SELECT MAX(M_Product_ID) FROM M_Product p WHERE i.UPC=p.UPC AND i.AD_Client_ID=p.AD_Client_ID) WHERE M_Product_ID IS NULL AND UPC IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Product from UPC=" + no);
        sql = new StringBuffer("UPDATE I_Inventory SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=No Product, ' " + "WHERE M_Product_ID IS NULL" + " AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("No Product=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuffer("UPDATE I_Inventory SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=No Qty Count, ' " + "WHERE QtyCount IS NULL" + " AND I_IsImported<>'Y'").append(clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
            this.log.warning("No QtyCount=" + no);
        }
        this.commit();
        MInventory inventory = null;
        int noInsert = 0;
        int noInsertLine = 0;
        sql = new StringBuffer("SELECT * FROM I_Inventory WHERE I_IsImported='N'").append(clientCheck).append(" ORDER BY M_Warehouse_ID, TRUNC(MovementDate,'DD'), I_Inventory_ID");
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            int x_M_Warehouse_ID = -1;
            Timestamp x_MovementDate = null;
            while (rs.next()) {
                MInventoryLine line;
                MProduct product;
                X_I_Inventory imp = new X_I_Inventory(this.getCtx(), rs, this.get_TrxName());
                Timestamp MovementDate = TimeUtil.getDay((Timestamp)imp.getMovementDate());
                if (inventory == null || imp.getM_Warehouse_ID() != x_M_Warehouse_ID || !MovementDate.equals(x_MovementDate)) {
                    inventory = new MInventory(this.getCtx(), 0, this.get_TrxName());
                    inventory.setClientOrg(imp.getAD_Client_ID(), imp.getAD_Org_ID());
                    inventory.setDescription("I " + imp.getM_Warehouse_ID() + " " + MovementDate);
                    inventory.setM_Warehouse_ID(imp.getM_Warehouse_ID());
                    inventory.setMovementDate(MovementDate);
                    if (!inventory.save()) {
                        this.log.log(Level.SEVERE, "Inventory not saved");
                        break;
                    }
                    x_M_Warehouse_ID = imp.getM_Warehouse_ID();
                    x_MovementDate = MovementDate;
                    ++noInsert;
                }
                int M_AttributeSetInstance_ID = 0;
                if ((imp.getLot() != null || imp.getSerNo() != null) && (product = MProduct.get(this.getCtx(), imp.getM_Product_ID())).isInstanceAttribute()) {
                    MAttributeSet mas = product.getAttributeSet();
                    MAttributeSetInstance masi = new MAttributeSetInstance(this.getCtx(), 0, mas.getM_AttributeSet_ID(), this.get_TrxName());
                    if (mas.isLot() && imp.getLot() != null) {
                        masi.setLot(imp.getLot(), imp.getM_Product_ID());
                    }
                    if (mas.isSerNo() && imp.getSerNo() != null) {
                        masi.setSerNo(imp.getSerNo());
                    }
                    masi.setDescription();
                    masi.save();
                    M_AttributeSetInstance_ID = masi.getM_AttributeSetInstance_ID();
                }
                if (!(line = new MInventoryLine(inventory, imp.getM_Locator_ID(), imp.getM_Product_ID(), M_AttributeSetInstance_ID, imp.getQtyBook(), imp.getQtyCount())).save()) continue;
                imp.setI_IsImported("Y");
                imp.setM_Inventory_ID(line.getM_Inventory_ID());
                imp.setM_InventoryLine_ID(line.getM_InventoryLine_ID());
                imp.setProcessed(true);
                if (!imp.save()) continue;
                ++noInsertLine;
            }
            rs.close();
            pstmt.close();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
        }
        sql = new StringBuffer("UPDATE I_Inventory SET I_IsImported='N', Updated=SysDate WHERE I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), "@Errors@");
        this.addLog(0, null, new BigDecimal(noInsert), "@M_Inventory_ID@: @Inserted@");
        this.addLog(0, null, new BigDecimal(noInsertLine), "@M_InventoryLine_ID@: @Inserted@");
        return "";
    }
}

