/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.logging.Level;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentValidate;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Ctx;
import org.compiere.util.Msg;

public class PaymentOnline
extends SvrProcess {
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
        }
    }

    protected String doIt() throws Exception {
        this.log.info("Record_ID=" + this.getRecord_ID());
        MPayment pp = new MPayment(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        String msg = MPaymentValidate.validateCreditCardNumber(pp.getCreditCardNumber(), pp.getCreditCardType());
        if (msg != null && msg.length() > 0) {
            throw new IllegalArgumentException(Msg.getMsg((Ctx)this.getCtx(), (String)msg));
        }
        msg = MPaymentValidate.validateCreditCardExp(pp.getCreditCardExpMM(), pp.getCreditCardExpYY());
        if (msg != null && msg.length() > 0) {
            throw new IllegalArgumentException(Msg.getMsg((Ctx)this.getCtx(), (String)msg));
        }
        if (pp.getCreditCardVV().length() > 0 && (msg = MPaymentValidate.validateCreditCardVV(pp.getCreditCardVV(), pp.getCreditCardType())) != null && msg.length() > 0) {
            throw new IllegalArgumentException(Msg.getMsg((Ctx)this.getCtx(), (String)msg));
        }
        boolean ok = pp.processOnline();
        pp.save();
        if (!ok) {
            throw new Exception(pp.getErrorMessage());
        }
        return "OK";
    }
}

