/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.logging.Level;
import org.compiere.model.MRfQ;
import org.compiere.model.MRfQLine;
import org.compiere.model.MRfQLineQty;
import org.compiere.model.MRfQResponse;
import org.compiere.model.MRfQResponseLine;
import org.compiere.model.MRfQResponseLineQty;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;

public class RfQResponseRank
extends SvrProcess {
    private int p_C_RfQ_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.p_C_RfQ_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        MRfQ rfq = new MRfQ(this.getCtx(), this.p_C_RfQ_ID, this.get_TrxName());
        if (rfq.get_ID() == 0) {
            throw new IllegalArgumentException("No RfQ found");
        }
        this.log.info(rfq.toString());
        String error = rfq.checkQuoteTotalAmtOnly();
        if (error != null && error.length() > 0) {
            throw new Exception(error);
        }
        MRfQResponse[] responses = rfq.getResponses(true, true);
        this.log.fine("doIt - #Responses=" + responses.length);
        if (responses.length == 0) {
            throw new IllegalArgumentException("No completed RfQ Responses found");
        }
        if (responses.length == 1) {
            responses[0].setIsSelectedWinner(true);
            responses[0].save();
            throw new IllegalArgumentException("Only one completed RfQ Response found");
        }
        if (rfq.isQuoteTotalAmtOnly()) {
            this.rankResponses(rfq, responses);
        } else {
            this.rankLines(rfq, responses);
        }
        return "# " + responses.length;
    }

    private void rankLines(MRfQ rfq, MRfQResponse[] responses) {
        MRfQLine[] rfqLines = rfq.getLines();
        if (rfqLines.length == 0) {
            throw new IllegalArgumentException("No RfQ Lines found");
        }
        for (int i = 0; i < rfqLines.length; ++i) {
            MRfQLine rfqLine = rfqLines[i];
            if (!rfqLine.isActive()) continue;
            this.log.fine("rankLines - " + (Object)((Object)rfqLine));
            MRfQLineQty[] rfqQtys = rfqLine.getQtys();
            for (int j = 0; j < rfqQtys.length; ++j) {
                MRfQLineQty rfqQty = rfqQtys[j];
                if (!rfqQty.isActive() || !rfqQty.isRfQQty()) continue;
                this.log.fine("rankLines Qty - " + (Object)((Object)rfqQty));
                MRfQResponseLineQty[] respQtys = rfqQty.getResponseQtys(false);
                for (int kk = 0; kk < respQtys.length; ++kk) {
                    MRfQResponseLineQty respQty = respQtys[kk];
                    if (respQty.isActive() && respQty.isValidAmt()) continue;
                    respQty.setRanking(999);
                    respQty.save();
                    this.log.fine("  - ignored: " + respQty);
                }
                respQtys = rfqQty.getResponseQtys(false);
                if (respQtys.length == 0) {
                    this.log.fine("  - No Qtys with valid Amounts");
                    continue;
                }
                Arrays.sort(respQtys, respQtys[0]);
                int lastRank = 1;
                BigDecimal lastAmt = Env.ZERO;
                for (int rank = 0; rank < respQtys.length; ++rank) {
                    MRfQResponseLineQty qty = respQtys[rank];
                    if (!qty.isActive() || qty.getRanking() == 999) continue;
                    BigDecimal netAmt = qty.getNetAmt();
                    if (netAmt == null) {
                        qty.setRanking(999);
                        this.log.fine("  - Rank 999: " + qty);
                    } else {
                        if (lastAmt.compareTo(netAmt) != 0) {
                            lastRank = rank + 1;
                            lastAmt = qty.getNetAmt();
                        }
                        qty.setRanking(lastRank);
                        this.log.fine("  - Rank " + lastRank + ": " + qty);
                    }
                    qty.save();
                    if (rank != 0) continue;
                    rfqQty.setBestResponseAmt(qty.getNetAmt());
                    rfqQty.save();
                }
            }
        }
        MRfQResponse winner = null;
        for (int ii = 0; ii < responses.length; ++ii) {
            MRfQResponse response = responses[ii];
            if (response.isSelectedWinner()) {
                response.setIsSelectedWinner(false);
            }
            int ranking = 0;
            MRfQResponseLine[] respLines = response.getLines(false);
            block5: for (int jj = 0; jj < respLines.length; ++jj) {
                MRfQResponseLine respLine = respLines[jj];
                if (!respLine.isActive()) continue;
                if (respLine.isSelectedWinner()) {
                    respLine.setIsSelectedWinner(false);
                }
                MRfQResponseLineQty[] respQtys = respLine.getQtys(false);
                for (int kk = 0; kk < respQtys.length; ++kk) {
                    MRfQResponseLineQty respQty = respQtys[kk];
                    if (!respQty.isActive()) continue;
                    ranking += respQty.getRanking();
                    if (respQty.getRanking() != 1 || !respQty.getRfQLineQty().isPurchaseQty()) continue;
                    respLine.setIsSelectedWinner(true);
                    respLine.save();
                    continue block5;
                }
            }
            response.setRanking(ranking);
            response.save();
            this.log.fine("- Response Ranking " + ranking + ": " + (Object)((Object)response));
            if (rfq.isQuoteSelectedLines()) continue;
            if (winner == null && ranking > 0) {
                winner = response;
            }
            if (winner == null || response.getRanking() <= 0 || response.getRanking() >= winner.getRanking()) continue;
            winner = response;
        }
        if (winner != null) {
            winner.setIsSelectedWinner(true);
            winner.save();
            this.log.fine("- Response Winner: " + winner);
        }
    }

    private void rankResponses(MRfQ rfq, MRfQResponse[] responses) {
        int ranking = 1;
        for (int ii = 0; ii < responses.length; ++ii) {
            MRfQResponse response = responses[ii];
            if (response.getPrice() != null && response.getPrice().compareTo(Env.ZERO) > 0) {
                if (response.isSelectedWinner() != (ranking == 1)) {
                    response.setIsSelectedWinner(ranking == 1);
                }
                response.setRanking(ranking);
                ++ranking;
            } else {
                response.setRanking(999);
                if (response.isSelectedWinner()) {
                    response.setIsSelectedWinner(false);
                }
            }
            response.save();
            this.log.fine("rankResponse - " + (Object)((Object)response));
        }
    }
}

