/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.report;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.framework.PO;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.model.X_PA_ReportLine;
import org.compiere.report.MReportSource;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class MReportLine
extends X_PA_ReportLine {
    private MReportSource[] m_sources = null;
    private String m_whereClause = null;
    static final String AmountType_Balance = "B";
    static final String AmountType_CR = "C";
    static final String AmountType_DR = "D";
    static final String AmountType_Qty = "Q";
    static final String AmountType_Period = "P";
    static final String AmountType_Year = "Y";
    static final String AmountType_Total = "T";

    public MReportLine(Ctx ctx, int PA_ReportLine_ID, String trxName) {
        super(ctx, PA_ReportLine_ID, trxName);
        if (PA_ReportLine_ID == 0) {
            this.setSeqNo(0);
            this.setIsPrinted(false);
        } else {
            this.loadSources();
        }
    }

    public MReportLine(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
        this.loadSources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSources() {
        ArrayList<MReportSource> list = new ArrayList<MReportSource>();
        String sql = "SELECT * FROM PA_ReportSource WHERE PA_ReportLine_ID=? AND IsActive='Y'";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getPA_ReportLine_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MReportSource(this.getCtx(), rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, null, (Throwable)e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            pstmt = null;
        }
        this.m_sources = new MReportSource[list.size()];
        list.toArray(this.m_sources);
        this.log.finest("ID=" + this.getPA_ReportLine_ID() + " - Size=" + list.size());
    }

    public MReportSource[] getSources() {
        if ("S".equals(this.getLineType())) {
            return this.m_sources;
        }
        return new MReportSource[0];
    }

    public void list() {
        System.out.println("- " + this.toString());
        if (this.m_sources == null) {
            return;
        }
        for (int i = 0; i < this.m_sources.length; ++i) {
            System.out.println("  - " + this.m_sources[i].toString());
        }
    }

    public String getSourceColumnName() {
        String ColumnName = null;
        for (int i = 0; i < this.m_sources.length; ++i) {
            String col = MAcctSchemaElement.getColumnName((String)this.m_sources[i].getElementType());
            if (ColumnName == null || ColumnName.length() == 0) {
                ColumnName = col;
                continue;
            }
            if (ColumnName.equals(col)) continue;
            this.log.config("More than one: " + ColumnName + " - " + col);
            return null;
        }
        return ColumnName;
    }

    public String getSourceValueQuery() {
        if (this.m_sources != null && this.m_sources.length > 0) {
            return MAcctSchemaElement.getValueQuery((String)this.m_sources[0].getElementType());
        }
        return null;
    }

    public String getSelectClause(boolean withSum) {
        String at = this.getAmountType().substring(0, 1);
        StringBuffer sb = new StringBuffer();
        if (withSum) {
            sb.append("SUM(");
        }
        if (AmountType_Balance.equals(at)) {
            sb.append("acctBalance(Account_ID,AmtAcctDr,AmtAcctCr)");
        } else if (AmountType_CR.equals(at)) {
            sb.append("AmtAcctCr");
        } else if (AmountType_DR.equals(at)) {
            sb.append("AmtAcctDr");
        } else if (AmountType_Qty.equals(at)) {
            sb.append("Qty");
        } else {
            this.log.log(Level.SEVERE, "AmountType=" + this.getAmountType() + ", at=" + at);
            return "NULL";
        }
        if (withSum) {
            sb.append(")");
        }
        return sb.toString();
    }

    public boolean isPeriod() {
        String at = this.getAmountType();
        if (at == null) {
            return false;
        }
        return "BP".equals(at) || "CP".equals(at) || "DP".equals(at) || "QP".equals(at);
    }

    public boolean isYear() {
        String at = this.getAmountType();
        if (at == null) {
            return false;
        }
        return "BY".equals(at) || "CY".equals(at) || "DY".equals(at) || "QY".equals(at);
    }

    public boolean isTotal() {
        String at = this.getAmountType();
        if (at == null) {
            return false;
        }
        return "BT".equals(at) || "CT".equals(at) || "DT".equals(at) || "QT".equals(at);
    }

    public String getWhereClause(int PA_Hierarchy_ID) {
        if (this.m_sources == null) {
            return "";
        }
        if (this.m_whereClause == null) {
            if (this.m_sources.length == 0) {
                this.m_whereClause = "";
            } else if (this.m_sources.length == 1) {
                this.m_whereClause = this.m_sources[0].getWhereClause(PA_Hierarchy_ID);
            } else {
                StringBuffer sb = new StringBuffer("(");
                for (int i = 0; i < this.m_sources.length; ++i) {
                    if (i > 0) {
                        sb.append(" OR ");
                    }
                    sb.append(this.m_sources[i].getWhereClause(PA_Hierarchy_ID));
                }
                sb.append(")");
                this.m_whereClause = sb.toString();
            }
            String PostingType = this.getPostingType();
            if (PostingType != null && PostingType.length() > 0) {
                if (this.m_whereClause.length() > 0) {
                    this.m_whereClause = this.m_whereClause + " AND ";
                }
                this.m_whereClause = this.m_whereClause + "PostingType='" + PostingType + "'";
            }
            this.log.fine(this.m_whereClause);
        }
        return this.m_whereClause;
    }

    public boolean isPostingType() {
        String PostingType = this.getPostingType();
        return PostingType != null && PostingType.length() > 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MReportLine[").append(this.get_ID()).append(" - ").append(this.getName()).append(" - ").append(this.getDescription()).append(", SeqNo=").append(this.getSeqNo()).append(", AmountType=").append(this.getAmountType()).append(" - LineType=").append(this.getLineType());
        if (this.isLineTypeCalculation()) {
            sb.append(" - Calculation=").append(this.getCalculationType()).append(" - ").append(this.getOper_1_ID()).append(" - ").append(this.getOper_2_ID());
        } else {
            sb.append(" - SegmentValue - PostingType=").append(this.getPostingType()).append(", AmountType=").append(this.getAmountType());
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean isLineTypeCalculation() {
        return AmountType_CR.equals(this.getLineType());
    }

    public boolean isLineTypeSegmentValue() {
        return "S".equals(this.getLineType());
    }

    public boolean isCalculationTypeRange() {
        return "R".equals(this.getCalculationType());
    }

    public boolean isCalculationTypeAdd() {
        return "A".equals(this.getCalculationType());
    }

    public boolean isCalculationTypeSubtract() {
        return "S".equals(this.getCalculationType());
    }

    public boolean isCalculationTypePercent() {
        return AmountType_Period.equals(this.getCalculationType());
    }

    protected boolean beforeSave(boolean newRecord) {
        if ("S".equals(this.getLineType())) {
            if (this.getCalculationType() != null) {
                this.setCalculationType(null);
            }
            if (this.getOper_1_ID() != 0) {
                this.setOper_1_ID(0);
            }
            if (this.getOper_2_ID() != 0) {
                this.setOper_2_ID(0);
            }
        }
        return true;
    }

    public static MReportLine copy(Ctx ctx, int AD_Client_ID, int AD_Org_ID, int PA_ReportLineSet_ID, MReportLine source, String trxName) {
        MReportLine retValue = new MReportLine(ctx, 0, trxName);
        MReportLine.copyValues((PO)source, (PO)retValue, (int)AD_Client_ID, (int)AD_Org_ID);
        retValue.setPA_ReportLineSet_ID(PA_ReportLineSet_ID);
        retValue.setOper_1_ID(0);
        retValue.setOper_2_ID(0);
        return retValue;
    }
}

