/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import org.compiere.util.CLogger;

public class Task
extends Thread {
    private String m_cmd;
    private Process m_child = null;
    StringBuffer m_out = new StringBuffer();
    StringBuffer m_err = new StringBuffer();
    InputStream m_outStream;
    InputStream m_errStream;
    OutputStream m_inStream;
    static CLogger log = CLogger.getCLogger(Task.class);
    private Thread m_outReader = new Thread(){

        public void run() {
            log.fine("outReader");
            try {
                int c;
                while ((c = Task.this.m_outStream.read()) != -1 && !this.isInterrupted()) {
                    Task.this.m_out.append((char)c);
                }
                Task.this.m_outStream.close();
            }
            catch (IOException ioe) {
                log.log(Level.SEVERE, "outReader", (Throwable)ioe);
            }
            log.fine("outReader - done");
        }
    };
    private Thread m_errReader = new Thread(){

        public void run() {
            log.fine("errReader");
            try {
                int c;
                while ((c = Task.this.m_errStream.read()) != -1 && !this.isInterrupted()) {
                    Task.this.m_err.append((char)c);
                }
                Task.this.m_errStream.close();
            }
            catch (IOException ioe) {
                log.log(Level.SEVERE, "errReader", (Throwable)ioe);
            }
            log.fine("errReader - done");
        }
    };

    public Task(String cmd) {
        this.m_cmd = cmd;
    }

    public void run() {
        log.info(this.m_cmd);
        try {
            this.m_child = Runtime.getRuntime().exec(this.m_cmd);
            this.m_outStream = this.m_child.getInputStream();
            this.m_errStream = this.m_child.getErrorStream();
            this.m_inStream = this.m_child.getOutputStream();
            if (this.checkInterrupted()) {
                return;
            }
            this.m_outReader.start();
            this.m_errReader.start();
            try {
                if (this.checkInterrupted()) {
                    return;
                }
                this.m_errReader.join();
                if (this.checkInterrupted()) {
                    return;
                }
                this.m_outReader.join();
                if (this.checkInterrupted()) {
                    return;
                }
                this.m_child.waitFor();
            }
            catch (InterruptedException ie) {
                log.log(Level.INFO, "(ie) - " + ie);
            }
            try {
                if (this.m_child != null) {
                    log.fine("run - ExitValue=" + this.m_child.exitValue());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            log.config("done");
        }
        catch (IOException ioe) {
            log.log(Level.SEVERE, "(ioe)", (Throwable)ioe);
        }
    }

    private boolean checkInterrupted() {
        if (this.isInterrupted()) {
            log.config("interrupted");
            if (this.m_child != null) {
                this.m_child.destroy();
            }
            this.m_child = null;
            if (this.m_outReader != null && this.m_outReader.isAlive()) {
                this.m_outReader.interrupt();
            }
            this.m_outReader = null;
            if (this.m_errReader != null && this.m_errReader.isAlive()) {
                this.m_errReader.interrupt();
            }
            this.m_errReader = null;
            if (this.m_inStream != null) {
                try {
                    this.m_inStream.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.m_inStream = null;
            if (this.m_outStream != null) {
                try {
                    this.m_outStream.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.m_outStream = null;
            if (this.m_errStream != null) {
                try {
                    this.m_errStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.m_errStream = null;
            return true;
        }
        return false;
    }

    public StringBuffer getOut() {
        return this.m_out;
    }

    public StringBuffer getErr() {
        return this.m_err;
    }

    public OutputStream getInStream() {
        return this.m_inStream;
    }
}

