/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wf;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.framework.PO;
import org.compiere.model.X_AD_WF_NodeNext;
import org.compiere.process.DocAction;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.wf.MWFActivity;
import org.compiere.wf.MWFNextCondition;
import org.compiere.wf.MWFNode;

public class MWFNodeNext
extends X_AD_WF_NodeNext {
    private MWFNextCondition[] m_conditions = null;
    public Boolean m_fromSplitAnd = null;
    public Boolean m_toJoinAnd = null;

    public MWFNodeNext(Ctx ctx, int AD_WF_NodeNext_ID, String trxName) {
        super(ctx, AD_WF_NodeNext_ID, trxName);
        if (AD_WF_NodeNext_ID == 0) {
            this.setEntityType("U");
            this.setIsStdUserWorkflow(false);
            this.setSeqNo(10);
        }
    }

    public MWFNodeNext(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MWFNodeNext(MWFNode parent, int AD_WF_Next_ID) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg((PO)parent);
        this.setAD_WF_Node_ID(parent.getAD_WF_Node_ID());
        this.setAD_WF_Next_ID(AD_WF_Next_ID);
    }

    public void setClientOrg(int AD_Client_ID, int AD_Org_ID) {
        super.setClientOrg(AD_Client_ID, AD_Org_ID);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MWFNodeNext[");
        sb.append(this.getSeqNo()).append(":Node=").append(this.getAD_WF_Node_ID()).append("->Next=").append(this.getAD_WF_Next_ID());
        if (this.m_conditions != null) {
            sb.append(",#").append(this.m_conditions.length);
        }
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(",").append(this.getDescription());
        }
        sb.append("]");
        return sb.toString();
    }

    public MWFNextCondition[] getConditions(boolean requery) {
        if (!requery && this.m_conditions != null) {
            return this.m_conditions;
        }
        ArrayList<MWFNextCondition> list = new ArrayList<MWFNextCondition>();
        String sql = "SELECT * FROM AD_WF_NextCondition WHERE AD_WF_NodeNext_ID=? AND IsActive='Y' ORDER BY SeqNo";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getAD_WF_NodeNext_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MWFNextCondition(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_conditions = new MWFNextCondition[list.size()];
        list.toArray(this.m_conditions);
        return this.m_conditions;
    }

    public boolean isUnconditional() {
        return !this.isStdUserWorkflow() && this.getConditions(false).length == 0;
    }

    public boolean isValidFor(MWFActivity activity) {
        PO po;
        if (this.isStdUserWorkflow() && (po = activity.getPO()) instanceof DocAction) {
            DocAction da = (DocAction)po;
            String docStatus = da.getDocStatus();
            String docAction = da.getDocAction();
            if (!"CO".equals(docAction) || "CO".equals(docStatus) || "WC".equals(docStatus) || "WP".equals(docStatus) || "VO".equals(docStatus) || "CL".equals(docStatus) || "RE".equals(docStatus)) {
                this.log.fine("isValidFor =NO= StdUserWF - Status=" + docStatus + " - Action=" + docAction);
                return false;
            }
        }
        if (this.getConditions(false).length == 0) {
            this.log.fine("#0 " + this.toString());
            return true;
        }
        boolean ok = this.m_conditions[0].evaluate(activity);
        for (int i = 1; i < this.m_conditions.length; ++i) {
            ok = this.m_conditions[i].isOr() ? ok || this.m_conditions[i].evaluate(activity) : ok && this.m_conditions[i].evaluate(activity);
        }
        this.log.fine("isValidFor (" + ok + ") " + this.toString());
        return ok;
    }

    public boolean isFromSplitAnd() {
        if (this.m_fromSplitAnd != null) {
            return this.m_fromSplitAnd;
        }
        return false;
    }

    public void setFromSplitAnd(boolean fromSplitAnd) {
        this.m_fromSplitAnd = new Boolean(fromSplitAnd);
    }

    public boolean isToJoinAnd() {
        if (this.m_toJoinAnd == null && this.getAD_WF_Next_ID() != 0) {
            MWFNode next = MWFNode.get(this.getCtx(), this.getAD_WF_Next_ID());
            this.setToJoinAnd("A".equals(next.getJoinElement()));
        }
        if (this.m_toJoinAnd != null) {
            return this.m_toJoinAnd;
        }
        return false;
    }

    private void setToJoinAnd(boolean toJoinAnd) {
        this.m_toJoinAnd = new Boolean(toJoinAnd);
    }
}

