/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.varia.deployment;

import bsh.EvalError;
import bsh.Interpreter;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.system.ServiceDynamicMBeanSupport;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.varia.deployment.ScriptService;

public class BeanShellScript
extends ServiceDynamicMBeanSupport {
    protected DeploymentInfo deploymentInfo = null;
    protected String name = null;
    protected Interpreter interpreter = null;
    protected ScriptService scriptService = null;
    protected ObjectName preferedObjectName = null;
    protected ObjectName[] dependsServices = null;
    protected HashMap supportedInterfaces = new HashMap();
    protected MBeanInfo mbeanInfo = null;
    protected static HashMap basicTypes = new HashMap();
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$org$jboss$varia$deployment$ScriptService;

    public BeanShellScript(DeploymentInfo di) throws DeploymentException {
        try {
            this.deploymentInfo = di;
            String name = this.deploymentInfo.url.toString();
            if (name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
            this.name = name;
            this.loadScript(di.url);
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    protected Object getInternalAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        try {
            String action = "get" + attribute.substring(0, 1).toUpperCase() + attribute.substring(1);
            InvocationCouple invoc = this.retrieveCompatibleInvocation(action, new Class[0]);
            if (invoc == null) {
                throw new AttributeNotFoundException(attribute + " getter not implemented on target script");
            }
            return invoc.method.invoke(invoc.proxy, null);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ReflectionException(cnfe, "A signature class couldn't be loaded");
        }
        catch (IllegalAccessException iae) {
            throw new ReflectionException(iae, "Problem while invoking gettter for field " + attribute);
        }
        catch (InvocationTargetException ite) {
            throw new MBeanException(ite, "Problem while invoking gettter for field " + attribute);
        }
    }

    protected void setInternalAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        String field = attribute.getName();
        try {
            InvocationCouple invoc;
            String action = "set" + field.substring(0, 1).toUpperCase() + field.substring(1);
            Object value = attribute.getValue();
            Class clazz = value.getClass();
            Class tmp = (Class)basicTypes.get(clazz);
            if (tmp != null) {
                clazz = tmp;
            }
            if ((invoc = this.retrieveCompatibleInvocation(action, new Class[]{clazz})) == null) {
                throw new AttributeNotFoundException(field + " setter not implemented on target script");
            }
            invoc.method.invoke(invoc.proxy, value);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ReflectionException(cnfe, "A signature class couldn't be loaded");
        }
        catch (IllegalAccessException iae) {
            throw new ReflectionException(iae, "Problem while invoking setter for field " + field);
        }
        catch (InvocationTargetException ite) {
            throw new MBeanException(ite, "Problem while invoking setter for field " + field);
        }
    }

    protected Object internalInvoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        try {
            InvocationCouple invoc = this.retrieveCompatibleInvocation(actionName, signature);
            if (invoc == null) {
                throw new ReflectionException(new Exception(), actionName + " not implemented on target script");
            }
            Object value = invoc.method.invoke(invoc.proxy, params);
            return value;
        }
        catch (ClassNotFoundException cnfe) {
            throw new ReflectionException(cnfe, "A signature class couldn't be loaded");
        }
        catch (IllegalAccessException iae) {
            throw new ReflectionException(iae, "Problem while invoking " + actionName);
        }
        catch (InvocationTargetException ite) {
            throw new MBeanException(ite, "Problem while invoking " + actionName);
        }
    }

    public MBeanInfo getMBeanInfo() {
        return this.mbeanInfo;
    }

    protected void createService() throws Exception {
        try {
            this.scriptService.setCtx((ServiceMBeanSupport)this);
        }
        catch (UndeclaredThrowableException e) {
            this.log.trace((Object)"UndeclaredThrowableException during setCtx", (Throwable)e);
        }
        catch (Throwable t) {
            this.log.warn((Object)"Error during setCtx", t);
        }
        try {
            this.scriptService.create();
        }
        catch (UndeclaredThrowableException e) {
            this.log.trace((Object)"UndeclaredThrowableException during create", (Throwable)e);
        }
        catch (EvalError e) {
            this.log.debug((Object)"EvalError during create", (Throwable)e);
        }
        catch (Exception e) {
            this.log.error((Object)"Error during create", (Throwable)e);
            throw e;
        }
    }

    protected void startService() throws Exception {
        try {
            this.scriptService.start();
        }
        catch (UndeclaredThrowableException e) {
            this.log.trace((Object)"UndeclaredThrowableException during start", (Throwable)e);
        }
        catch (EvalError e) {
            this.log.debug((Object)"EvalError during start", (Throwable)e);
        }
        catch (Exception e) {
            this.log.error((Object)"Error during start", (Throwable)e);
            throw e;
        }
    }

    protected void stopService() throws Exception {
        try {
            this.scriptService.stop();
        }
        catch (UndeclaredThrowableException e) {
            this.log.trace((Object)"UndeclaredThrowableException during stop", (Throwable)e);
        }
        catch (Exception e) {
            this.log.debug((Object)"Error during stop", (Throwable)e);
            throw e;
        }
    }

    protected void destroyService() throws Exception {
        try {
            this.scriptService.destroy();
        }
        catch (UndeclaredThrowableException e) {
            this.log.trace((Object)"UndeclaredThrowableException during destroy", (Throwable)e);
        }
        catch (Exception e) {
            this.log.debug((Object)"Error during destroy", (Throwable)e);
            throw e;
        }
    }

    protected InvocationCouple retrieveCompatibleInvocation(String name, String[] signature) throws ClassNotFoundException {
        ClassLoader ucl = Thread.currentThread().getContextClassLoader();
        Class[] realSignature = null;
        if (signature != null) {
            realSignature = new Class[signature.length];
            for (int i = 0; i < signature.length; ++i) {
                realSignature[i] = ucl.loadClass(signature[i]);
            }
        }
        return this.retrieveCompatibleInvocation(name, realSignature);
    }

    protected InvocationCouple retrieveCompatibleInvocation(String name, Class[] signature) throws ClassNotFoundException {
        Iterator keys = this.supportedInterfaces.keySet().iterator();
        while (keys.hasNext()) {
            Class key = (Class)keys.next();
            try {
                Method method = key.getMethod(name, signature);
                Object targetProxy = this.supportedInterfaces.get(key);
                return new InvocationCouple(targetProxy, method);
            }
            catch (NoSuchMethodException ok) {
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void loadScript(URL url) throws Exception {
        stream = null;
        try {
            this.interpreter = new Interpreter();
            this.interpreter.setClassLoader(Thread.currentThread().getContextClassLoader());
            stream = url.openStream();
            this.interpreter.eval((Reader)new InputStreamReader(stream));
            var4_3 = null;
            ** if (stream == null) goto lbl-1000
        }
        catch (Throwable var3_9) {
            var4_4 = null;
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception strange) {
                    this.log.info((Object)strange);
                }
            }
            throw var3_9;
        }
lbl-1000:
        // 1 sources

        {
            try {
                stream.close();
            }
            catch (Exception strange) {
                this.log.info((Object)strange);
            }
        }
lbl-1000:
        // 2 sources

        {
        }
        this.scriptService = (ScriptService)this.interpreter.getInterface(BeanShellScript.class$org$jboss$varia$deployment$ScriptService == null ? (BeanShellScript.class$org$jboss$varia$deployment$ScriptService = BeanShellScript.class$("org.jboss.varia.deployment.ScriptService")) : BeanShellScript.class$org$jboss$varia$deployment$ScriptService);
        try {
            depends = this.scriptService.dependsOn();
            if (depends != null && depends.length > 0) {
                this.dependsServices = new ObjectName[depends.length];
                for (i = 0; i < depends.length; ++i) {
                    this.dependsServices[i] = new ObjectName(depends[i]);
                }
            }
        }
        catch (UndeclaredThrowableException ignored) {
            // empty catch block
        }
        try {
            myName = this.scriptService.objectName();
            if (myName != null) {
                this.preferedObjectName = new ObjectName(myName);
            }
        }
        catch (UndeclaredThrowableException ignored) {
            // empty catch block
        }
        try {
            intfs = this.scriptService.getInterfaces();
            if (intfs != null && intfs.length > 0) {
                for (i = 0; i < intfs.length; ++i) {
                    iface = this.interpreter.getInterface(intfs[i]);
                    this.supportedInterfaces.put(intfs[i], iface);
                }
            }
            this.mbeanInfo = this.generateMBeanInfo(intfs);
        }
        catch (UndeclaredThrowableException ignored) {
            this.log.debug((Object)"Failed to obtain interfaces", (Throwable)ignored);
            this.mbeanInfo = this.generateMBeanInfo(null);
        }
    }

    protected MBeanInfo generateMBeanInfo(Class[] intfs) throws IntrospectionException {
        MBeanInfo result = super.getMBeanInfo();
        if (intfs != null && intfs.length > 0) {
            ArrayList<MBeanAttributeInfo> attrs = new ArrayList<MBeanAttributeInfo>(Arrays.asList(result.getAttributes()));
            ArrayList<MBeanOperationInfo> ops = new ArrayList<MBeanOperationInfo>(Arrays.asList(result.getOperations()));
            HashMap<String, Method> readAttr = new HashMap<String, Method>();
            HashMap<String, Method> writeAttr = new HashMap<String, Method>();
            for (int i = 0; i < intfs.length; ++i) {
                Class clazz = intfs[i];
                Method[] methods = clazz.getMethods();
                for (int m = 0; m < methods.length; ++m) {
                    Method meth = methods[m];
                    String name = meth.getName();
                    Class<?>[] params = meth.getParameterTypes();
                    if (name.startsWith("get") && params.length == 0) {
                        readAttr.put(name, meth);
                        continue;
                    }
                    if (name.startsWith("set") && params.length == 1) {
                        writeAttr.put(name, meth);
                        continue;
                    }
                    ops.add(new MBeanOperationInfo("Method " + name + " from class/interface " + clazz.getName(), meth));
                }
            }
            Iterator readKeys = readAttr.keySet().iterator();
            while (readKeys.hasNext()) {
                String getter = (String)readKeys.next();
                Method getterMethod = (Method)readAttr.get(getter);
                String attribute = getter.substring(3);
                String setter = "set" + attribute;
                Method setterMethod = (Method)writeAttr.remove(setter);
                attrs.add(new MBeanAttributeInfo(attribute, "", getterMethod, setterMethod));
            }
            Iterator writeKeys = writeAttr.keySet().iterator();
            while (writeKeys.hasNext()) {
                String setter = (String)writeKeys.next();
                Method setterMethod = (Method)writeAttr.get(setter);
                String attribute = setter.substring(3);
                attrs.add(new MBeanAttributeInfo(attribute, "", null, setterMethod));
            }
            result = new MBeanInfo(this.name, "Dynamic MBean Service around BSH script " + this.name, attrs.toArray(new MBeanAttributeInfo[attrs.size()]), result.getConstructors(), ops.toArray(new MBeanOperationInfo[ops.size()]), result.getNotifications());
        }
        return result;
    }

    public ObjectName getPreferedObjectName() {
        return this.preferedObjectName;
    }

    public ObjectName[] getDependsServices() {
        return this.dependsServices;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        basicTypes.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = BeanShellScript.class$("java.lang.Boolean")) : class$java$lang$Boolean, Boolean.TYPE);
        basicTypes.put(class$java$lang$Byte == null ? (class$java$lang$Byte = BeanShellScript.class$("java.lang.Byte")) : class$java$lang$Byte, Byte.TYPE);
        basicTypes.put(class$java$lang$Character == null ? (class$java$lang$Character = BeanShellScript.class$("java.lang.Character")) : class$java$lang$Character, Character.TYPE);
        basicTypes.put(class$java$lang$Integer == null ? (class$java$lang$Integer = BeanShellScript.class$("java.lang.Integer")) : class$java$lang$Integer, Integer.TYPE);
        basicTypes.put(class$java$lang$Short == null ? (class$java$lang$Short = BeanShellScript.class$("java.lang.Short")) : class$java$lang$Short, Short.TYPE);
        basicTypes.put(class$java$lang$Float == null ? (class$java$lang$Float = BeanShellScript.class$("java.lang.Float")) : class$java$lang$Float, Float.TYPE);
        basicTypes.put(class$java$lang$Double == null ? (class$java$lang$Double = BeanShellScript.class$("java.lang.Double")) : class$java$lang$Double, Double.TYPE);
        basicTypes.put(class$java$lang$Long == null ? (class$java$lang$Long = BeanShellScript.class$("java.lang.Long")) : class$java$lang$Long, Long.TYPE);
    }

    public class InvocationCouple {
        public Object proxy = null;
        public Method method = null;

        public InvocationCouple(Object proxy, Method m) {
            this.proxy = proxy;
            this.method = m;
        }
    }
}

