/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.filesystem;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.poi.poifs.dev.POIFSViewable;
import org.apache.poi.poifs.filesystem.BATManaged;
import org.apache.poi.poifs.filesystem.DocumentOutputStream;
import org.apache.poi.poifs.filesystem.POIFSDocumentPath;
import org.apache.poi.poifs.filesystem.POIFSWriterEvent;
import org.apache.poi.poifs.filesystem.POIFSWriterListener;
import org.apache.poi.poifs.property.DocumentProperty;
import org.apache.poi.poifs.property.Property;
import org.apache.poi.poifs.storage.BlockWritable;
import org.apache.poi.poifs.storage.DocumentBlock;
import org.apache.poi.poifs.storage.ListManagedBlock;
import org.apache.poi.poifs.storage.RawDataBlock;
import org.apache.poi.poifs.storage.SmallDocumentBlock;
import org.apache.poi.util.HexDump;

public class POIFSDocument
implements BATManaged,
BlockWritable,
POIFSViewable {
    private DocumentProperty _property;
    private int _size;
    private SmallBlockStore _small_store;
    private BigBlockStore _big_store;

    public POIFSDocument(String name, RawDataBlock[] blocks, int length) throws IOException {
        this._size = length;
        this._big_store = new BigBlockStore(blocks);
        this._property = new DocumentProperty(name, this._size);
        this._small_store = new SmallBlockStore(new BlockWritable[0]);
        this._property.setDocument(this);
    }

    public POIFSDocument(String name, SmallDocumentBlock[] blocks, int length) {
        this._size = length;
        try {
            this._big_store = new BigBlockStore(new RawDataBlock[0]);
        }
        catch (IOException ignored) {
            // empty catch block
        }
        this._property = new DocumentProperty(name, this._size);
        this._small_store = new SmallBlockStore(blocks);
        this._property.setDocument(this);
    }

    public POIFSDocument(String name, ListManagedBlock[] blocks, int length) throws IOException {
        this._size = length;
        this._property = new DocumentProperty(name, this._size);
        this._property.setDocument(this);
        if (Property.isSmall(this._size)) {
            this._big_store = new BigBlockStore(new RawDataBlock[0]);
            this._small_store = new SmallBlockStore(blocks);
        } else {
            this._big_store = new BigBlockStore(blocks);
            this._small_store = new SmallBlockStore(new BlockWritable[0]);
        }
    }

    public POIFSDocument(String name, InputStream stream) throws IOException {
        DocumentBlock block;
        ArrayList<DocumentBlock> blocks = new ArrayList<DocumentBlock>();
        this._size = 0;
        do {
            int blockSize;
            if ((blockSize = (block = new DocumentBlock(stream)).size()) <= 0) continue;
            blocks.add(block);
            this._size += blockSize;
        } while (!block.partiallyRead());
        Object[] bigBlocks = blocks.toArray(new DocumentBlock[0]);
        this._big_store = new BigBlockStore(bigBlocks);
        this._property = new DocumentProperty(name, this._size);
        this._property.setDocument(this);
        if (this._property.shouldUseSmallBlocks()) {
            this._small_store = new SmallBlockStore(SmallDocumentBlock.convert((BlockWritable[])bigBlocks, this._size));
            this._big_store = new BigBlockStore(new DocumentBlock[0]);
        } else {
            this._small_store = new SmallBlockStore(new BlockWritable[0]);
        }
    }

    public POIFSDocument(String name, int size, POIFSDocumentPath path, POIFSWriterListener writer) throws IOException {
        this._size = size;
        this._property = new DocumentProperty(name, this._size);
        this._property.setDocument(this);
        if (this._property.shouldUseSmallBlocks()) {
            this._small_store = new SmallBlockStore(path, name, size, writer);
            this._big_store = new BigBlockStore(new Object[0]);
        } else {
            this._small_store = new SmallBlockStore(new BlockWritable[0]);
            this._big_store = new BigBlockStore(path, name, size, writer);
        }
    }

    public BlockWritable[] getSmallBlocks() {
        return this._small_store.getBlocks();
    }

    public int getSize() {
        return this._size;
    }

    void read(byte[] buffer, int offset) {
        if (this._property.shouldUseSmallBlocks()) {
            SmallDocumentBlock.read(this._small_store.getBlocks(), buffer, offset);
        } else {
            DocumentBlock.read(this._big_store.getBlocks(), buffer, offset);
        }
    }

    DocumentProperty getDocumentProperty() {
        return this._property;
    }

    public void writeBlocks(OutputStream stream) throws IOException {
        this._big_store.writeBlocks(stream);
    }

    public int countBlocks() {
        return this._big_store.countBlocks();
    }

    public void setStartBlock(int index) {
        this._property.setStartBlock(index);
    }

    public Object[] getViewableArray() {
        String result;
        Object[] results = new Object[1];
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            BlockWritable[] blocks = null;
            if (this._big_store.isValid()) {
                blocks = this._big_store.getBlocks();
            } else if (this._small_store.isValid()) {
                blocks = this._small_store.getBlocks();
            }
            if (blocks != null) {
                for (int k = 0; k < blocks.length; ++k) {
                    blocks[k].writeBlocks(output);
                }
                byte[] data = output.toByteArray();
                if (data.length > this._property.getSize()) {
                    byte[] tmp = new byte[this._property.getSize()];
                    System.arraycopy(data, 0, tmp, 0, tmp.length);
                    data = tmp;
                }
                output = new ByteArrayOutputStream();
                HexDump.dump(data, 0L, output, 0);
                result = output.toString();
            } else {
                result = "<NO DATA>";
            }
        }
        catch (IOException e2) {
            result = e2.getMessage();
        }
        results[0] = result;
        return results;
    }

    public Iterator getViewableIterator() {
        return Collections.EMPTY_LIST.iterator();
    }

    public boolean preferArray() {
        return true;
    }

    public String getShortDescription() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Document: \"").append(this._property.getName()).append("\"");
        buffer.append(" size = ").append(this.getSize());
        return buffer.toString();
    }

    private class BigBlockStore {
        private DocumentBlock[] bigBlocks;
        private POIFSDocumentPath path;
        private String name;
        private int size;
        private POIFSWriterListener writer;

        BigBlockStore(Object[] blocks) throws IOException {
            this.bigBlocks = new DocumentBlock[blocks.length];
            for (int j = 0; j < blocks.length; ++j) {
                this.bigBlocks[j] = blocks[j] instanceof DocumentBlock ? (DocumentBlock)blocks[j] : new DocumentBlock((RawDataBlock)blocks[j]);
            }
            this.path = null;
            this.name = null;
            this.size = -1;
            this.writer = null;
        }

        BigBlockStore(POIFSDocumentPath path, String name, int size, POIFSWriterListener writer) {
            this.bigBlocks = new DocumentBlock[0];
            this.path = path;
            this.name = name;
            this.size = size;
            this.writer = writer;
        }

        boolean isValid() {
            return this.bigBlocks.length > 0 || this.writer != null;
        }

        DocumentBlock[] getBlocks() {
            if (this.isValid() && this.writer != null) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream(this.size);
                DocumentOutputStream dstream = new DocumentOutputStream(stream, this.size);
                this.writer.processPOIFSWriterEvent(new POIFSWriterEvent(dstream, this.path, this.name, this.size));
                this.bigBlocks = DocumentBlock.convert(stream.toByteArray(), this.size);
            }
            return this.bigBlocks;
        }

        void writeBlocks(OutputStream stream) throws IOException {
            if (this.isValid()) {
                if (this.writer != null) {
                    DocumentOutputStream dstream = new DocumentOutputStream(stream, this.size);
                    this.writer.processPOIFSWriterEvent(new POIFSWriterEvent(dstream, this.path, this.name, this.size));
                    dstream.writeFiller(this.countBlocks() * 512, DocumentBlock.getFillByte());
                } else {
                    for (int k = 0; k < this.bigBlocks.length; ++k) {
                        this.bigBlocks[k].writeBlocks(stream);
                    }
                }
            }
        }

        int countBlocks() {
            int rval = 0;
            if (this.isValid()) {
                rval = this.writer != null ? (this.size + 512 - 1) / 512 : this.bigBlocks.length;
            }
            return rval;
        }
    }

    private class SmallBlockStore {
        private SmallDocumentBlock[] smallBlocks;
        private POIFSDocumentPath path;
        private String name;
        private int size;
        private POIFSWriterListener writer;

        SmallBlockStore(Object[] blocks) {
            this.smallBlocks = new SmallDocumentBlock[blocks.length];
            for (int j = 0; j < blocks.length; ++j) {
                this.smallBlocks[j] = (SmallDocumentBlock)blocks[j];
            }
            this.path = null;
            this.name = null;
            this.size = -1;
            this.writer = null;
        }

        SmallBlockStore(POIFSDocumentPath path, String name, int size, POIFSWriterListener writer) {
            this.smallBlocks = new SmallDocumentBlock[0];
            this.path = path;
            this.name = name;
            this.size = size;
            this.writer = writer;
        }

        boolean isValid() {
            return this.smallBlocks.length > 0 || this.writer != null;
        }

        BlockWritable[] getBlocks() {
            if (this.isValid() && this.writer != null) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream(this.size);
                DocumentOutputStream dstream = new DocumentOutputStream(stream, this.size);
                this.writer.processPOIFSWriterEvent(new POIFSWriterEvent(dstream, this.path, this.name, this.size));
                this.smallBlocks = SmallDocumentBlock.convert(stream.toByteArray(), this.size);
            }
            return this.smallBlocks;
        }
    }
}

