/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ecs;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import org.apache.ecs.ECSDefaults;
import org.apache.ecs.Element;
import org.apache.ecs.Filter;
import org.apache.ecs.filter.NullFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericElement
implements Element,
Serializable {
    private static Filter _defaultFilter = new NullFilter();
    private Filter filter = _defaultFilter;
    private int position = ECSDefaults.getDefaultPosition();
    private boolean filter_state = ECSDefaults.getDefaultFilterState();
    private boolean pretty_print = ECSDefaults.getDefaultPrettyPrint();
    private static final String VERSION = "Compiere2.5.2";
    private int case_type = ECSDefaults.getDefaultCaseType();
    private Hashtable<String, Object> element = new Hashtable(4);
    private boolean end_element = ECSDefaults.getDefaultEndElement();
    private String codeset = ECSDefaults.getDefaultCodeset();
    private char begin_start_modifier = ECSDefaults.getDefaultBeginStartModifier();
    private char end_start_modifier = ECSDefaults.getDefaultEndStartModifier();
    private char begin_end_modifier = ECSDefaults.getDefaultBeginEndModifier();
    private char end_end_modifier = ECSDefaults.getDefaultEndEndModifier();
    private boolean start_modifier_defined = false;
    private boolean begin_start_modifier_defined = false;
    private boolean end_start_modifier_defined = false;
    private boolean begin_end_modifier_defined = false;
    private boolean end_end_modifier_defined = false;
    private boolean end_modifier_defined = false;
    protected int tabLevel = 0;
    private char start_tag = ECSDefaults.getDefaultStartTag();
    private char end_tag = ECSDefaults.getDefaultEndTag();
    private String __text = new String();
    private String element_type = new String();

    @Override
    public boolean getPrettyPrint() {
        return this.pretty_print;
    }

    @Override
    public Element setPrettyPrint(boolean pretty_print) {
        this.pretty_print = pretty_print;
        return this;
    }

    protected Hashtable<String, Object> getElementHashEntry() {
        return this.element;
    }

    @Override
    public Element setFilterState(boolean filter_state) {
        this.filter_state = filter_state;
        return this;
    }

    @Override
    public boolean getFilterState() {
        return this.filter_state;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public void setCase(int case_type) {
        this.case_type = case_type;
    }

    @Override
    public int getCase() {
        return this.case_type;
    }

    @Override
    public void setElementType(String element_type) {
        this.element_type = element_type;
    }

    @Override
    public String getElementType() {
        return this.element_type;
    }

    public void setCodeSet(String codeset) {
        this.codeset = codeset;
    }

    public String getCodeSet() {
        return this.codeset;
    }

    @Override
    public void setNeedClosingTag(boolean close) {
        this.end_element = close;
    }

    @Override
    public boolean getNeedClosingTag() {
        return this.end_element;
    }

    @Override
    public boolean getNeedLineBreak() {
        return true;
    }

    @Override
    public void setTagPosition(int position) {
        this.position = position;
    }

    @Override
    public int getTagPosition() {
        return this.position;
    }

    protected String alterCase(String value) {
        switch (this.getCase()) {
            case 1: {
                return value.toUpperCase();
            }
            case 2: {
                return value.toLowerCase();
            }
        }
        return value;
    }

    public Element setBeginModifier(char modifier) {
        this.setBeginStartModifier(modifier);
        this.setBeginEndModifier(modifier);
        this.setBeginStartModifierDefined(true);
        this.setBeginEndModifierDefined(true);
        return this;
    }

    @Override
    public Element setBeginStartModifier(char modifier) {
        this.begin_start_modifier = modifier;
        this.setBeginStartModifierDefined(true);
        return this;
    }

    @Override
    public Element setBeginEndModifier(char modifier) {
        this.begin_end_modifier = modifier;
        this.setBeginEndModifierDefined(true);
        return this;
    }

    public Element setBeginModifier(char start_modifier, char end_modifier) {
        this.begin_start_modifier = start_modifier;
        this.begin_end_modifier = end_modifier;
        this.setBeginStartModifierDefined(true);
        this.setBeginEndModifierDefined(true);
        return this;
    }

    @Override
    public char getBeginStartModifier() {
        return this.begin_start_modifier;
    }

    @Override
    public char getBeginEndModifier() {
        return this.begin_end_modifier;
    }

    public Element removeBeginStartModifier() {
        this.setBeginStartModifierDefined(false);
        return this;
    }

    public Element removeBeginEndModifier() {
        this.setBeginEndModifierDefined(false);
        return this;
    }

    private void setBeginStartModifierDefined(boolean val) {
        this.begin_start_modifier_defined = val;
    }

    private void setBeginEndModifierDefined(boolean val) {
        this.begin_end_modifier_defined = val;
    }

    protected boolean getEndStartModifierDefined() {
        return this.end_start_modifier_defined;
    }

    protected boolean getEndEndModifierDefined() {
        return this.end_end_modifier_defined;
    }

    public Element setEndModifier(char modifier) {
        this.setEndStartModifier(modifier);
        this.setEndEndModifier(modifier);
        this.setEndStartModifierDefined(true);
        this.setEndEndModifierDefined(true);
        return this;
    }

    @Override
    public Element setEndStartModifier(char modifier) {
        this.end_start_modifier = modifier;
        this.setEndStartModifierDefined(true);
        return this;
    }

    @Override
    public Element setEndEndModifier(char modifier) {
        this.end_end_modifier = modifier;
        this.setEndEndModifierDefined(true);
        return this;
    }

    public Element setEndModifier(char start_modifier, char end_modifier) {
        this.end_start_modifier = start_modifier;
        this.end_end_modifier = end_modifier;
        this.setEndStartModifierDefined(true);
        this.setEndEndModifierDefined(true);
        return this;
    }

    @Override
    public char getEndStartModifier() {
        return this.end_start_modifier;
    }

    @Override
    public char getEndEndModifier() {
        return this.end_end_modifier;
    }

    public Element removeEndStartModifier() {
        this.setEndStartModifierDefined(false);
        return this;
    }

    public Element removeEndEndModifier() {
        this.setEndEndModifierDefined(false);
        return this;
    }

    private void setEndStartModifierDefined(boolean val) {
        this.end_start_modifier_defined = val;
    }

    private void setEndEndModifierDefined(boolean val) {
        this.end_end_modifier_defined = val;
    }

    protected boolean getBeginStartModifierDefined() {
        return this.begin_start_modifier_defined;
    }

    protected boolean getBeginEndModifierDefined() {
        return this.begin_end_modifier_defined;
    }

    @Override
    public void setStartTagChar(char start_tag) {
        this.start_tag = start_tag;
    }

    @Override
    public char getStartTagChar() {
        return this.start_tag;
    }

    @Override
    public void setEndTagChar(char end_tag) {
        this.end_tag = end_tag;
    }

    @Override
    public char getEndTagChar() {
        return this.end_tag;
    }

    public String getTagText() {
        return this.__text;
    }

    public Element setTagText(String text) {
        this.__text = text;
        System.out.println(this.toString());
        return this;
    }

    protected String createStartTag() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getStartTagChar());
        if (this.getBeginStartModifierDefined()) {
            sb.append(this.getBeginStartModifier());
        }
        sb.append(this.getElementType());
        if (this.getBeginEndModifierDefined()) {
            sb.append(this.getBeginEndModifier());
        }
        sb.append(this.getEndTagChar());
        return sb.toString();
    }

    protected String createEndTag() {
        this.setEndStartModifier('/');
        StringBuffer sb = new StringBuffer();
        sb.append(this.getStartTagChar());
        if (this.getEndStartModifierDefined()) {
            sb.append(this.getEndStartModifier());
        }
        sb.append(this.getElementType());
        if (this.getEndEndModifierDefined()) {
            sb.append(this.getEndEndModifier());
        }
        sb.append(this.getEndTagChar());
        return sb.toString();
    }

    public final String toString() {
        String out = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedOutputStream bos = new BufferedOutputStream(baos);
            this.output(bos);
            bos.flush();
            out = this.getCodeSet() != null ? baos.toString(this.getCodeSet()) : baos.toString();
            bos.close();
            baos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out;
    }

    public final String toString(String codeset) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(baos);
        String out = null;
        try {
            this.output(bos);
            bos.flush();
            out = baos.toString(codeset);
            bos.close();
            baos.close();
        }
        catch (UnsupportedEncodingException use) {
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return out;
    }

    @Override
    public void output(OutputStream out) {
        String encoding = null;
        encoding = this.getCodeSet() != null ? this.getCodeSet() : "UTF-16BE";
        try {
            out.write(this.createStartTag().getBytes(encoding));
            if (this.getFilterState()) {
                out.write(this.getFilter().process(this.getTagText()).getBytes(encoding));
            } else {
                out.write(this.getTagText().getBytes(encoding));
            }
            if (this.getNeedClosingTag()) {
                out.write(this.createEndTag().getBytes(encoding));
            }
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace(new PrintWriter(out));
        }
        catch (IOException ioe) {
            ioe.printStackTrace(new PrintWriter(out));
        }
    }

    @Override
    public void output(PrintWriter out) {
        out.write(this.createStartTag());
        if (this.getFilterState()) {
            out.write(this.getFilter().process(this.getTagText()));
        } else {
            out.write(this.getTagText());
        }
        if (this.getNeedClosingTag()) {
            out.write(this.createEndTag());
        }
    }

    @Override
    public void setTabLevel(int tabLevel) {
        this.tabLevel = tabLevel;
    }

    @Override
    public int getTabLevel() {
        return this.tabLevel;
    }

    protected void putTabs(int tabCount, OutputStream out) throws IOException {
        for (int i2 = 0; i2 < tabCount; ++i2) {
            out.write(9);
        }
    }

    protected void putTabs(int tabCount, PrintWriter out) {
        for (int i2 = 0; i2 < tabCount; ++i2) {
            out.print('\t');
        }
    }
}

