/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.db;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import org.compiere.db.CConnection;
import org.compiere.db.Database;
import org.compiere.plaf.CompierePLAF;
import org.compiere.swing.CButton;
import org.compiere.swing.CCheckBox;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CDialog;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.Ini;
import org.compiere.util.ValueNamePair;

public class CConnectionDialog
extends CDialog
implements ActionListener {
    private static ResourceBundle res = ResourceBundle.getBundle("org.compiere.translate.DBRes");
    public static final String APPS_PORT_HTTP = "80";
    public static final String APPS_PORT_JNP = "1099";
    private CConnection m_cc = null;
    private CConnection m_ccResult = null;
    private boolean m_updating = false;
    private boolean m_saved = false;
    private static CLogger log;
    private CPanel mainPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel centerPanel = new CPanel();
    private CPanel southPanel = new CPanel();
    private CButton bOK = CompierePLAF.getOKButton();
    private CButton bCancel = CompierePLAF.getCancelButton();
    private FlowLayout southLayout = new FlowLayout();
    private GridBagLayout centerLayout = new GridBagLayout();
    private CLabel nameLabel = new CLabel();
    private CTextField nameField = new CTextField();
    private CLabel hostLabel = new CLabel();
    private CTextField hostField = new CTextField();
    private CLabel portLabel = new CLabel();
    private CTextField dbPortField = new CTextField();
    private CLabel sidLabel = new CLabel();
    private CTextField sidField = new CTextField();
    private CCheckBox cbFirewall = new CCheckBox();
    private CLabel fwHostLabel = new CLabel();
    private CTextField fwHostField = new CTextField();
    private CLabel fwPortLabel = new CLabel();
    private CTextField fwPortField = new CTextField();
    private CButton bTestDB = new CButton();
    private CLabel dbTypeLabel = new CLabel();
    private CComboBox dbTypeField = new CComboBox(Database.DB_NAMES);
    private CCheckBox cbBequeath = new CCheckBox();
    private CLabel appsHostLabel = new CLabel();
    private CTextField appsHostField = new CTextField();
    private CLabel appsPortLabel = new CLabel();
    private CTextField appsPortField = new CTextField();
    private CButton bTestApps = new CButton();
    private CCheckBox cbOverwrite = new CCheckBox();
    private CLabel dbUidLabel = new CLabel();
    private CTextField dbUidField = new CTextField();
    private JPasswordField dbPwdField = new JPasswordField();
    private CLabel connectionProfileLabel = new CLabel();
    private CComboBox connectionProfileField = new CComboBox(CConnection.CONNECTIONProfiles);
    private CLabel appsTypeLabel = new CLabel();
    private CComboBox appsTypeField = new CComboBox(CConnection.appsTypeProfiles);
    private CLabel webPortLabel = new CLabel();
    private CTextField webPortField = new CTextField();

    public CConnectionDialog() {
        this((CConnection)null);
    }

    public CConnectionDialog(CConnection cc) {
        super((Frame)null, true);
        try {
            this.jbInit();
            this.setConnection(cc);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
        CompierePLAF.showCenterScreen(this);
    }

    private void jbInit() throws Exception {
        this.setTitle(res.getString("CConnectionDialog"));
        this.mainPanel.setLayout(this.mainLayout);
        this.southPanel.setLayout(this.southLayout);
        this.southLayout.setAlignment(2);
        this.centerPanel.setLayout(this.centerLayout);
        this.nameLabel.setText(res.getString("Name"));
        this.nameField.setColumns(30);
        this.nameField.setReadWrite(false);
        this.hostLabel.setText(res.getString("DBHost"));
        this.hostField.setColumns(30);
        this.portLabel.setText(res.getString("DBPort"));
        this.dbPortField.setColumns(10);
        this.sidLabel.setText(res.getString("DBName"));
        this.cbFirewall.setToolTipText("");
        this.cbFirewall.setText(res.getString("ViaFirewall"));
        this.fwHostLabel.setText(res.getString("FWHost"));
        this.fwHostField.setColumns(30);
        this.fwPortLabel.setText(res.getString("FWPort"));
        this.bTestDB.setText(res.getString("TestConnection"));
        this.bTestDB.setHorizontalAlignment(2);
        this.dbTypeLabel.setText(res.getString("Type"));
        this.sidField.setColumns(30);
        this.fwPortField.setColumns(10);
        this.cbBequeath.setText(res.getString("BequeathConnection"));
        this.appsHostLabel.setText(res.getString("AppsHost"));
        this.appsHostField.setColumns(30);
        this.appsPortLabel.setText(res.getString("AppsPort"));
        this.appsPortField.setColumns(10);
        this.bTestApps.setText(res.getString("TestApps"));
        this.bTestApps.setHorizontalAlignment(2);
        this.cbOverwrite.setText(res.getString("Overwrite"));
        this.dbUidLabel.setText(res.getString("DBUidPwd"));
        this.dbUidField.setColumns(10);
        this.connectionProfileLabel.setText(res.getString("ConnectionProfile"));
        this.connectionProfileField.addActionListener(this);
        this.appsTypeLabel.setText(res.getString("AppsType"));
        this.appsTypeField.addActionListener(this);
        this.webPortLabel.setText(res.getString("WebPort"));
        this.webPortField.setColumns(10);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.mainPanel.add((Component)this.centerPanel, "Center");
        this.mainPanel.add((Component)this.southPanel, "South");
        this.southPanel.add((Component)this.bCancel, null);
        this.southPanel.add((Component)this.bOK, null);
        int rowNum = 0;
        this.centerPanel.add((Component)this.nameLabel, new GridBagConstraints(0, rowNum, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 12, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.nameField, new GridBagConstraints(1, rowNum, 2, 1, 0.0, 0.0, 17, 2, new Insets(12, 0, 5, 12), 0, 0));
        this.centerPanel.add((Component)this.appsTypeLabel, new GridBagConstraints(0, ++rowNum, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 12, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.appsTypeField, new GridBagConstraints(1, rowNum, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 12), 0, 0));
        this.centerPanel.add((Component)this.appsHostLabel, new GridBagConstraints(0, ++rowNum, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 12, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.appsHostField, new GridBagConstraints(1, rowNum, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 12), 0, 0));
        this.centerPanel.add((Component)this.appsPortLabel, new GridBagConstraints(0, ++rowNum, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.appsPortField, new GridBagConstraints(1, rowNum, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.centerPanel.add((Component)this.connectionProfileLabel, new GridBagConstraints(0, ++rowNum, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 12, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.connectionProfileField, new GridBagConstraints(1, rowNum, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.centerPanel.add((Component)this.webPortLabel, new GridBagConstraints(0, ++rowNum, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.webPortField, new GridBagConstraints(1, rowNum, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.centerPanel.add((Component)this.bTestApps, new GridBagConstraints(1, ++rowNum, 1, 1, 0.0, 0.0, 16, 2, new Insets(5, 0, 12, 0), 0, 0));
        this.centerPanel.add((Component)this.cbOverwrite, new GridBagConstraints(2, rowNum, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 5, 0, 12), 0, 0));
        this.centerPanel.add((Component)this.dbTypeLabel, new GridBagConstraints(0, ++rowNum, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 12, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.dbTypeField, new GridBagConstraints(1, rowNum, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.centerPanel.add((Component)this.cbBequeath, new GridBagConstraints(2, rowNum, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 12), 0, 0));
        this.centerPanel.add((Component)this.hostLabel, new GridBagConstraints(0, ++rowNum, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 12, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.hostField, new GridBagConstraints(1, rowNum, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 12), 0, 0));
        this.centerPanel.add((Component)this.portLabel, new GridBagConstraints(0, ++rowNum, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.dbPortField, new GridBagConstraints(1, rowNum, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.centerPanel.add((Component)this.sidLabel, new GridBagConstraints(0, ++rowNum, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.sidField, new GridBagConstraints(1, rowNum, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 12), 0, 0));
        this.centerPanel.add((Component)this.dbUidLabel, new GridBagConstraints(0, ++rowNum, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.dbUidField, new GridBagConstraints(1, rowNum, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.centerPanel.add((Component)this.dbPwdField, new GridBagConstraints(2, rowNum, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 12), 0, 0));
        this.centerPanel.add((Component)this.cbFirewall, new GridBagConstraints(1, ++rowNum, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 12), 0, 0));
        this.centerPanel.add((Component)this.fwHostLabel, new GridBagConstraints(0, ++rowNum, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.fwHostField, new GridBagConstraints(1, rowNum, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 12), 0, 0));
        this.centerPanel.add((Component)this.fwPortLabel, new GridBagConstraints(0, ++rowNum, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.fwPortField, new GridBagConstraints(1, rowNum, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.centerPanel.add((Component)this.bTestDB, new GridBagConstraints(1, ++rowNum, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 12, 0), 0, 0));
        this.nameField.addActionListener(this);
        this.appsHostField.addActionListener(this);
        this.appsPortField.addActionListener(this);
        this.cbOverwrite.addActionListener(this);
        this.bTestApps.addActionListener(this);
        this.appsTypeField.addActionListener(this);
        this.webPortField.addActionListener(this);
        this.dbTypeField.addActionListener(this);
        this.hostField.addActionListener(this);
        this.dbPortField.addActionListener(this);
        this.sidField.addActionListener(this);
        this.cbBequeath.addActionListener(this);
        this.cbFirewall.addActionListener(this);
        this.fwHostField.addActionListener(this);
        this.fwPortField.addActionListener(this);
        this.bTestDB.addActionListener(this);
        this.bOK.addActionListener(this);
        this.bCancel.addActionListener(this);
        if (!Ini.isClient()) {
            this.appsHostLabel.setVisible(false);
            this.appsHostField.setVisible(false);
            this.appsPortLabel.setVisible(false);
            this.appsPortField.setVisible(false);
            this.bTestApps.setVisible(false);
            this.connectionProfileLabel.setVisible(false);
            this.connectionProfileField.setVisible(false);
            this.appsTypeLabel.setVisible(false);
            this.appsTypeField.setVisible(false);
            this.webPortLabel.setVisible(false);
            this.webPortField.setVisible(false);
        } else {
            this.cbBequeath.setVisible(false);
        }
    }

    private void setBusy(boolean busy) {
        if (busy) {
            this.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.m_updating = busy;
    }

    public void setConnection(CConnection cc) {
        this.m_cc = cc;
        if (this.m_cc == null) {
            this.m_cc = CConnection.get();
            this.m_cc.setName();
        }
        this.m_ccResult = this.m_cc;
        String type = this.m_cc.getDBType();
        if (type == null || type.length() == 0) {
            this.dbTypeField.setSelectedItem(null);
        } else {
            this.m_cc.setDBType(this.m_cc.getDBType());
        }
        this.updateInfo();
    }

    public CConnection getConnection() {
        return this.m_ccResult;
    }

    public void actionPerformed(ActionEvent e) {
        ValueNamePair pp;
        if (this.m_updating) {
            return;
        }
        Object src = e.getSource();
        if (src == this.bOK) {
            this.m_cc.setName();
            this.m_ccResult = this.m_cc;
            this.dispose();
            return;
        }
        if (src == this.bCancel) {
            this.m_cc.setName();
            this.dispose();
            return;
        }
        if (src == this.appsTypeField) {
            pp = (ValueNamePair)this.appsTypeField.getSelectedItem();
            this.m_cc.setAppsType(pp.getValue());
        } else {
            if (src == this.connectionProfileField) {
                ValueNamePair pp2 = (ValueNamePair)this.connectionProfileField.getSelectedItem();
                this.m_cc.setConnectionProfile(pp2.getValue());
                if (this.m_cc.isRMIoverHTTP()) {
                    this.webPortLabel.setEnabled(true);
                    this.webPortField.setEnabled(true);
                    this.webPortField.setText(Integer.toString(this.m_cc.getWebPort()));
                } else {
                    this.webPortField.setText("");
                    this.webPortLabel.setEnabled(false);
                    this.webPortField.setEnabled(false);
                }
                return;
            }
            if (src == this.dbTypeField && this.dbTypeField.getSelectedItem() == null) {
                return;
            }
        }
        if (Ini.isClient()) {
            this.m_cc.setAppsHost(this.appsHostField.getText());
            this.m_cc.setAppsPort(this.appsPortField.getText());
            this.m_cc.setWebPort(this.webPortField.getText());
        } else {
            this.m_cc.setAppsHost("localhost");
        }
        pp = (ValueNamePair)this.appsTypeField.getSelectedItem();
        this.m_cc.setAppsType(pp.getValue());
        pp = (ValueNamePair)this.connectionProfileField.getSelectedItem();
        this.m_cc.setConnectionProfile(pp.getValue());
        this.m_cc.setDBType((String)this.dbTypeField.getSelectedItem());
        this.m_cc.setDbHost(this.hostField.getText());
        this.m_cc.setDbPort(this.dbPortField.getText());
        this.m_cc.setDbName(this.sidField.getText());
        this.m_cc.setDbUid(this.dbUidField.getText());
        this.m_cc.setDbPwd(String.valueOf(this.dbPwdField.getPassword()));
        this.m_cc.setBequeath(this.cbBequeath.isSelected());
        this.m_cc.setViaFirewall(this.cbFirewall.isSelected());
        this.m_cc.setFwHost(this.fwHostField.getText());
        this.m_cc.setFwPort(this.fwPortField.getText());
        if (src == this.bTestApps) {
            this.cmd_testApps();
        } else if (src == this.dbTypeField) {
            this.m_cc.setDBType((String)this.dbTypeField.getSelectedItem());
            this.dbPortField.setText(String.valueOf(this.m_cc.getDbPort()));
            this.cbBequeath.setSelected(this.m_cc.isBequeath());
            this.fwPortField.setText(String.valueOf(this.m_cc.getFwPort()));
        } else if (src == this.bTestDB) {
            this.cmd_testDB();
        }
        if (src == this.nameField) {
            this.m_cc.setName(this.nameField.getText());
        }
        this.updateInfo();
    }

    private void updateInfo() {
        int i;
        this.m_updating = true;
        this.nameField.setText(this.m_cc.getName());
        this.appsHostField.setText(this.m_cc.getAppsHost());
        this.appsPortField.setText(String.valueOf(this.m_cc.getAppsPort()));
        String cp = this.m_cc.getAppsType();
        ValueNamePair cpPP = null;
        for (int i2 = 0; i2 < CConnection.appsTypeProfiles.length; ++i2) {
            if (!cp.equals(CConnection.appsTypeProfiles[i2].getValue())) continue;
            cpPP = CConnection.appsTypeProfiles[i2];
            break;
        }
        if (cpPP == null) {
            cpPP = CConnection.appsTypeProfiles[0];
        }
        this.appsTypeField.setSelectedItem(cpPP);
        int count = this.connectionProfileField.getItemCount();
        for (i = 0; i < count; ++i) {
            this.connectionProfileField.removeItemAt(0);
        }
        if (cpPP.getValue().equals("ibmWAS")) {
            for (i = 0; i < CConnection.CONNECTIONProfilesWas.length; ++i) {
                this.connectionProfileField.addItem(CConnection.CONNECTIONProfilesWas[i]);
            }
        } else {
            for (i = 0; i < CConnection.CONNECTIONProfiles.length; ++i) {
                this.connectionProfileField.addItem(CConnection.CONNECTIONProfiles[i]);
            }
        }
        if ((cp = this.m_cc.getConnectionProfile()).equals("W")) {
            this.webPortLabel.setEnabled(true);
            this.webPortField.setEnabled(true);
            this.webPortField.setText(Integer.toString(this.m_cc.getWebPort()));
        } else {
            this.webPortLabel.setEnabled(false);
            this.webPortField.setEnabled(false);
        }
        cpPP = null;
        for (i = 0; i < CConnection.CONNECTIONProfiles.length; ++i) {
            if (!cp.equals(CConnection.CONNECTIONProfiles[i].getValue())) continue;
            cpPP = CConnection.CONNECTIONProfiles[i];
            break;
        }
        if (cpPP == null) {
            cpPP = CConnection.CONNECTIONProfiles[0];
        }
        this.connectionProfileField.setSelectedItem(cpPP);
        this.bTestApps.setIcon(this.getStatusIcon(this.m_cc.isAppsServerOK(false)));
        this.cbOverwrite.setVisible(this.m_cc.isAppsServerOK(false));
        boolean rw = this.cbOverwrite.isSelected() || !this.m_cc.isAppsServerOK(false);
        this.dbTypeLabel.setReadWrite(rw);
        this.dbTypeField.setReadWrite(rw);
        this.dbTypeField.setSelectedItem(this.m_cc.getDBType());
        this.hostLabel.setReadWrite(rw);
        this.hostField.setReadWrite(rw);
        this.hostField.setText(this.m_cc.getDbHost());
        this.portLabel.setReadWrite(rw);
        this.dbPortField.setReadWrite(rw);
        this.dbPortField.setText(String.valueOf(this.m_cc.getDbPort()));
        this.sidLabel.setReadWrite(rw);
        this.sidField.setReadWrite(rw);
        this.sidField.setText(this.m_cc.getDbName());
        this.dbUidLabel.setReadWrite(rw);
        this.dbUidField.setReadWrite(rw);
        this.dbUidField.setText(this.m_cc.getDbUid());
        this.dbPwdField.setEditable(rw);
        this.dbPwdField.setText(this.m_cc.getDbPwd());
        this.cbBequeath.setReadWrite(rw);
        this.cbBequeath.setEnabled(this.m_cc.isOracle());
        this.cbBequeath.setSelected(this.m_cc.isBequeath());
        boolean fwEnabled = rw && this.m_cc.isViaFirewall() && this.m_cc.isOracle();
        this.cbFirewall.setReadWrite(rw && this.m_cc.isOracle());
        this.cbFirewall.setSelected(this.m_cc.isViaFirewall());
        this.fwHostLabel.setReadWrite(fwEnabled);
        this.fwHostField.setReadWrite(fwEnabled);
        this.fwHostField.setText(this.m_cc.getFwHost());
        this.fwPortLabel.setReadWrite(fwEnabled);
        this.fwPortField.setReadWrite(fwEnabled);
        this.fwPortField.setText(String.valueOf(this.m_cc.getFwPort()));
        this.bTestDB.setToolTipText(this.m_cc.getConnectionURL());
        this.bTestDB.setIcon(this.getStatusIcon(this.m_cc.isDatabaseOK()));
        this.m_updating = false;
    }

    private Icon getStatusIcon(boolean ok) {
        if (ok) {
            return this.bOK.getIcon();
        }
        return this.bCancel.getIcon();
    }

    private void cmd_testDB() {
        this.setBusy(true);
        Exception e = this.m_cc.testDatabase(true);
        if (e != null) {
            JOptionPane.showMessageDialog(this, e, res.getString("ConnectionError") + ": " + this.m_cc.getConnectionURL(), 0);
        }
        this.setBusy(false);
    }

    private void cmd_testApps() {
        this.setBusy(true);
        Exception e = this.m_cc.testAppsServer();
        if (e != null) {
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), res.getString("ServerNotActive") + " - " + this.m_cc.getAppsHost(), 0);
        }
        this.setBusy(false);
    }

    static {
        CConnection.CONNECTIONProfiles = new ValueNamePair[]{new ValueNamePair("L", res.getString("LAN")), new ValueNamePair("T", res.getString("TerminalServer")), new ValueNamePair("V", res.getString("VPN")), new ValueNamePair("W", res.getString("WAN"))};
        log = CLogger.getCLogger(CConnectionDialog.class);
    }
}

