/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.framework;

import java.io.Serializable;
import java.sql.Timestamp;
import org.compiere.framework.Query;
import org.compiere.util.DB;
import org.compiere.util.KeyNamePair;
import org.compiere.util.ValueNamePair;

public class QueryRestriction
implements Serializable {
    protected String DirectWhereClause = null;
    protected String ColumnName;
    protected String InfoName;
    protected String Operator;
    protected Object Code;
    protected String InfoDisplay;
    protected Object Code_to;
    protected String InfoDisplay_to;
    protected boolean AndCondition = true;

    public QueryRestriction(String columnName, String operator, Object code, String infoName, String infoDisplay) {
        this.ColumnName = columnName.trim();
        this.InfoName = infoName != null ? infoName : this.ColumnName;
        this.Operator = operator;
        this.Code = code instanceof Boolean ? ((Boolean)code != false ? "Y" : "N") : (code instanceof KeyNamePair ? new Integer(((KeyNamePair)code).getKey()) : (code instanceof ValueNamePair ? ((ValueNamePair)code).getValue() : code));
        if (this.Code instanceof String) {
            if (this.Code.toString().startsWith("'")) {
                this.Code = this.Code.toString().substring(1);
            }
            if (this.Code.toString().endsWith("'")) {
                this.Code = this.Code.toString().substring(0, this.Code.toString().length() - 2);
            }
        }
        if (infoDisplay != null) {
            this.InfoDisplay = infoDisplay.trim();
        } else if (code != null) {
            this.InfoDisplay = code.toString();
        }
    }

    public QueryRestriction(String columnName, Object code, Object code_to, String infoName, String infoDisplay, String infoDisplay_to) {
        this(columnName, " BETWEEN ", code, infoName, infoDisplay);
        this.Code_to = code_to;
        if (this.Code_to instanceof String) {
            if (this.Code_to.toString().startsWith("'")) {
                this.Code_to = this.Code_to.toString().substring(1);
            }
            if (this.Code_to.toString().endsWith("'")) {
                this.Code_to = this.Code_to.toString().substring(0, this.Code_to.toString().length() - 2);
            }
        }
        if (infoDisplay_to != null) {
            this.InfoDisplay_to = infoDisplay_to.trim();
        } else if (this.Code_to != null) {
            this.InfoDisplay_to = this.Code_to.toString();
        }
    }

    public QueryRestriction(String whereClause) {
        this.DirectWhereClause = whereClause;
    }

    public QueryRestriction(String columnName, Object code, Object code_to, String infoName, String infoDisplay, String infoDisplay_to, String operator, String directWhereClause, boolean andCondition) {
        this.ColumnName = columnName;
        this.InfoName = infoName;
        this.Code = code;
        this.Code_to = code_to;
        this.InfoName = infoName;
        this.InfoDisplay = infoDisplay;
        this.InfoDisplay_to = infoDisplay_to;
        this.Operator = operator;
        this.DirectWhereClause = directWhereClause;
        this.AndCondition = andCondition;
    }

    public String getSQL(String tableName) {
        if (this.DirectWhereClause != null) {
            return this.DirectWhereClause;
        }
        StringBuffer sb = new StringBuffer();
        if (this.Code instanceof String) {
            sb.append(" UPPER( ");
        }
        if (tableName != null && tableName.length() > 0) {
            int pos = this.ColumnName.lastIndexOf(40) + 1;
            int end = this.ColumnName.indexOf(41);
            if (pos != -1 && end != -1) {
                sb.append(this.ColumnName.substring(0, pos)).append(tableName).append(".").append(this.ColumnName.substring(pos, end)).append(this.ColumnName.substring(end));
            } else {
                sb.append(tableName).append(".").append(this.ColumnName);
            }
        } else {
            sb.append(this.ColumnName);
        }
        if (this.Code instanceof String) {
            sb.append(" ) ");
        }
        if (this.Code == null || "NULL".equals(this.Code.toString().toUpperCase()) || "NULLValue".equals(this.Code.toString())) {
            if (this.Operator.equals("=")) {
                sb.append(" IS NULL ");
            } else {
                sb.append(" IS NOT NULL ");
            }
        } else {
            sb.append(this.Operator);
            if (" IN ".equals(this.Operator) || " NOT IN ".equals(this.Operator)) {
                sb.append("(");
            }
            if (this.Code instanceof String) {
                sb.append(" UPPER( ");
                sb.append(DB.TO_STRING(this.Code.toString()));
                sb.append(" ) ");
            } else if (this.Code instanceof Timestamp) {
                sb.append(DB.TO_DATE((Timestamp)this.Code, false));
            } else {
                sb.append(this.Code);
            }
            if (" BETWEEN ".equals(this.Operator)) {
                sb.append(" AND ");
                if (this.Code_to instanceof String) {
                    sb.append(DB.TO_STRING(this.Code_to.toString()));
                } else if (this.Code_to instanceof Timestamp) {
                    sb.append(DB.TO_DATE((Timestamp)this.Code_to));
                } else {
                    sb.append(this.Code_to);
                }
            } else if (" IN ".equals(this.Operator) || " NOT IN ".equals(this.Operator)) {
                sb.append(")");
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.getSQL(null);
    }

    public String getInfoName() {
        return this.InfoName;
    }

    public String getInfoOperator() {
        for (int i = 0; i < Query.OPERATORS.length; ++i) {
            if (!Query.OPERATORS[i].getValue().equals(this.Operator)) continue;
            return Query.OPERATORS[i].getName();
        }
        return this.Operator;
    }

    public String getInfoDisplayAll() {
        if (this.InfoDisplay_to == null) {
            return this.InfoDisplay;
        }
        StringBuffer sb = new StringBuffer(this.InfoDisplay);
        sb.append(" - ").append(this.InfoDisplay_to);
        return sb.toString();
    }
}

