/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.framework;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VO
implements Map<String, String>,
Serializable {
    private static final long serialVersionUID = 8683452581122892189L;
    private ArrayList<String> m_keys;
    private ArrayList<String> m_values;
    protected ArrayList<VO> p_vos = null;

    public VO(ArrayList<String> keys, ArrayList<String> values) {
        this.set(keys, values);
    }

    public VO(Object[] keys, Object[] values) {
        this.set(keys, values);
    }

    public VO() {
        this(new String[0], new String[0]);
    }

    public VO(VO vo) {
        this(vo.m_keys, vo.m_values);
    }

    public VO(Map<String, String> map) {
        this();
        Iterator<String> it = map.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            String value = map.get(key);
            this.put((Object)key, (Object)value);
        }
    }

    private synchronized void set(ArrayList<String> keys, ArrayList<String> values) {
        if (keys == null) {
            throw new IllegalArgumentException("No Keys");
        }
        if (values == null) {
            throw new IllegalArgumentException("No Values");
        }
        int size = keys.size();
        if (size != values.size()) {
            throw new IllegalArgumentException("Inconsistency: #Keys=" + keys.size() + "<>#Values=" + values.size());
        }
        int capacity = Math.max(size, 10);
        this.m_keys = new ArrayList(capacity);
        this.m_values = new ArrayList(capacity);
        for (int i = 0; i < size; ++i) {
            this.put(keys.get(i), values.get(i));
        }
    }

    private synchronized void set(Object[] keys, Object[] values) {
        if (keys == null) {
            throw new IllegalArgumentException("No Keys");
        }
        if (values == null) {
            throw new IllegalArgumentException("No Values");
        }
        int size = keys.length;
        if (size != values.length) {
            throw new IllegalArgumentException("Inconsistency: #Keys=" + keys.length + "<>#Values=" + values.length);
        }
        int capacity = Math.max(size, 10);
        this.m_keys = new ArrayList(capacity);
        this.m_values = new ArrayList(capacity);
        for (int i = 0; i < size; ++i) {
            this.put(keys[i], values[i]);
        }
    }

    @Override
    public int size() {
        int noV;
        if (this.m_keys == null) {
            return 0;
        }
        int noK = this.m_keys.size();
        if (noK != (noV = this.m_values.size())) {
            System.err.println(this.getClass() + " Inconsistency: #Keys=" + noK + "<>#Values=" + noV);
        }
        return noK;
    }

    @Override
    public boolean isEmpty() {
        return this.m_keys.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        return this.m_keys.contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        return this.m_values.contains(value);
    }

    @Override
    public synchronized String get(Object key) {
        if (key == null) {
            return null;
        }
        int index = this.m_keys.indexOf(key);
        if (index != -1) {
            return this.m_values.get(index);
        }
        return null;
    }

    @Override
    public synchronized String put(Object key, Object value) {
        if (key == null) {
            return null;
        }
        if (value == null) {
            return this.remove(key);
        }
        String stringKey = key.toString();
        String stringValue = value.toString();
        if (value instanceof Boolean) {
            stringValue = (Boolean)value != false ? "Y" : "N";
        }
        return this.put(stringKey, stringValue);
    }

    @Override
    public synchronized String put(String key, String value) {
        if (key == null) {
            return null;
        }
        if (value == null) {
            return this.remove(key);
        }
        int index = this.m_keys.indexOf(key);
        if (index != -1) {
            return this.m_values.set(index, value);
        }
        this.m_keys.add(key);
        this.m_values.add(value);
        return null;
    }

    @Override
    public synchronized String remove(Object key) {
        if (key == null) {
            return null;
        }
        int index = this.m_keys.indexOf(key);
        String old = null;
        if (index != -1) {
            old = this.m_values.get(index);
            this.m_keys.remove(index);
            this.m_values.remove(index);
        }
        return old;
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> t) {
        for (String string : t.keySet()) {
            String value = t.get(string);
            this.put(string.toString(), value.toString());
        }
    }

    @Override
    public void clear() {
        this.m_keys.clear();
        this.m_values.clear();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> set = new HashSet<String>(this.m_keys);
        return set;
    }

    @Override
    public Collection<String> values() {
        return this.m_values;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.getHashMap().entrySet();
    }

    public HashMap<String, String> getHashMap() {
        HashMap<String, String> map = new HashMap<String, String>(this.m_keys.size());
        for (int i = 0; i < this.m_keys.size(); ++i) {
            String key = this.m_keys.get(i);
            String value = this.get(key);
            map.put(key, value);
        }
        return map;
    }

    public VO clone() {
        return new VO(this);
    }

    public String[] getData(String[] columns) {
        String[] retValue = new String[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            String value;
            String key = columns[i];
            retValue[i] = value = this.get(key);
        }
        return retValue;
    }

    public void setEmbedded(ArrayList<VO> vos) {
        this.p_vos = vos;
    }

    public ArrayList<VO> getEmbedded() {
        return this.p_vos;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("VO[");
        if (this.m_keys != null) {
            sb.append("#").append(this.m_keys.size());
            if (this.m_keys.size() != this.m_values.size()) {
                sb.append("<>values#").append(this.m_values.size());
            }
        }
        if (this.p_vos != null) {
            sb.append(";Embedded=#").append(this.p_vos.size());
        }
        sb.append("]");
        return sb.toString();
    }

    public String toStringX() {
        int i;
        String className = this.getClass().toString();
        int index = className.lastIndexOf(".");
        if (index != -1) {
            className = className.substring(index + 1);
        }
        StringBuffer sb = new StringBuffer(className).append("[");
        for (i = 0; i < this.m_keys.size(); ++i) {
            if (i != 0) {
                sb.append(";");
            }
            String key = this.m_keys.get(i);
            sb.append(key).append("=").append(this.get(key));
        }
        if (this.p_vos != null) {
            for (i = 0; i < this.p_vos.size(); ++i) {
                VO vo = this.p_vos.get(i);
                sb.append("\n ").append(vo.toStringX());
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public void dump() {
        System.out.println(this.toStringX());
    }
}

