/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.controller.GridTabVO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class GridWindowVO
implements Serializable {
    static final long serialVersionUID = 3802628212531678981L;
    public Ctx ctx;
    public int WindowNo;
    public int AD_Window_ID = 0;
    public String Name = "";
    public String Description = "";
    public String Help = "";
    public String WindowType = "";
    public int AD_Image_ID = 0;
    public int AD_Color_ID = 0;
    public String IsReadWrite = null;
    public int WinWidth = 0;
    public int WinHeight = 0;
    public boolean IsSOTrx = false;
    public ArrayList<GridTabVO> Tabs = null;
    public int AD_Table_ID = 0;
    public static final String WINDOWTYPE_QUERY = "Q";
    public static final String WINDOWTYPE_TRX = "T";
    public static final String WINDOWTYPE_MMAINTAIN = "M";

    public static GridWindowVO create(Ctx ctx, int WindowNo, int AD_Window_ID) {
        return GridWindowVO.create(ctx, WindowNo, AD_Window_ID, 0);
    }

    public static GridWindowVO create(Ctx ctx, int WindowNo, int AD_Window_ID, int AD_Menu_ID) {
        CharSequence sql;
        CLogger.get().config("#" + WindowNo + " - AD_Window_ID=" + AD_Window_ID + "; AD_Menu_ID=" + AD_Menu_ID);
        GridWindowVO vo = new GridWindowVO(ctx, WindowNo);
        vo.AD_Window_ID = AD_Window_ID;
        if (vo.AD_Window_ID == 0 && AD_Menu_ID != 0) {
            sql = "SELECT m.AD_Window_ID, ctx.IsSOTrx, m.IsReadOnly FROM AD_Menu m left JOIN AD_WINDOW w on w.AD_WINDOW_ID = m.AD_WINDOW_ID left JOIN AD_CTXAREA ctx on ctx.AD_CTXAREA_ID = w.AD_CTXAREA_ID WHERE AD_Menu_ID=? AND Action='W' ";
            try {
                CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, AD_Menu_ID);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    vo.AD_Window_ID = rs.getInt(1);
                    String IsSOTrx = rs.getString(2);
                    ctx.setContext(WindowNo, "IsSOTrx", IsSOTrx != null && IsSOTrx.equals("Y"));
                    String IsReadOnly = rs.getString(3);
                    vo.IsReadWrite = IsReadOnly != null && IsReadOnly.equals("Y") ? "Y" : "N";
                }
                rs.close();
                pstmt.close();
            }
            catch (SQLException e) {
                CLogger.get().log(Level.SEVERE, "Menu", e);
                return null;
            }
            CLogger.get().config("AD_Window_ID=" + vo.AD_Window_ID);
        }
        sql = new StringBuffer("SELECT Name,Description,Help,WindowType, AD_Color_ID,AD_Image_ID, IsReadWrite, WinHeight,WinWidth, IsSOTrx, AD_UserDef_Win_ID ");
        if (Env.isBaseLanguage(vo.ctx, "AD_Window")) {
            ((StringBuffer)sql).append("FROM AD_Window_v WHERE AD_Window_ID=? AND AD_Role_ID=?");
        } else {
            ((StringBuffer)sql).append("FROM AD_Window_vt w WHERE AD_Window_ID=? AND AD_Role_ID=?").append(" AND AD_Language='").append(Env.getAD_Language(vo.ctx)).append("'");
        }
        int AD_Role_ID = vo.ctx.getAD_Role_ID();
        int AD_UserDef_Win_ID = 0;
        try {
            CPreparedStatement pstmt = DB.prepareStatement(((StringBuffer)sql).toString(), null);
            pstmt.setInt(1, vo.AD_Window_ID);
            pstmt.setInt(2, AD_Role_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                vo.Name = rs.getString(1);
                vo.Description = rs.getString(2);
                if (vo.Description == null) {
                    vo.Description = "";
                }
                vo.Help = rs.getString(3);
                if (vo.Help == null) {
                    vo.Help = "";
                }
                vo.WindowType = rs.getString(4);
                vo.AD_Color_ID = rs.getInt(5);
                vo.AD_Image_ID = rs.getInt(6);
                vo.IsReadWrite = rs.getString(7);
                vo.WinHeight = rs.getInt(8);
                vo.WinWidth = rs.getInt(9);
                vo.IsSOTrx = "Y".equals(rs.getString(10));
                AD_UserDef_Win_ID = rs.getInt(11);
            } else {
                vo = null;
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException ex) {
            CLogger.get().log(Level.SEVERE, ((StringBuffer)sql).toString(), ex);
            return null;
        }
        if (vo == null) {
            CLogger.get().log(Level.SEVERE, "No Window - AD_Window_ID=" + AD_Window_ID + ", AD_Role_ID=" + AD_Role_ID + " - " + sql);
            CLogger.get().saveError("AccessTableNoView", "(Not found)");
            return null;
        }
        if (vo.IsReadWrite == null) {
            CLogger.get().saveError("AccessTableNoView", "(found)");
            return null;
        }
        GridWindowVO.createTabs(vo, AD_UserDef_Win_ID);
        if (vo.Tabs == null || vo.Tabs.size() == 0) {
            return null;
        }
        return vo;
    }

    private static boolean createTabs(GridWindowVO mWindowVO, int AD_UserDef_Win_ID) {
        mWindowVO.Tabs = new ArrayList();
        String sql = GridTabVO.getSQL(mWindowVO.ctx, AD_UserDef_Win_ID);
        int TabNo = 0;
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, mWindowVO.AD_Window_ID);
            ResultSet rs = pstmt.executeQuery();
            boolean firstTab = true;
            while (rs.next()) {
                GridTabVO mTabVO;
                if (mWindowVO.AD_Table_ID == 0) {
                    mWindowVO.AD_Table_ID = rs.getInt("AD_Table_ID");
                }
                int onlyCurrentDays = 0;
                if (mWindowVO.WindowType.equals(WINDOWTYPE_TRX)) {
                    onlyCurrentDays = 1;
                }
                if ((mTabVO = GridTabVO.create(mWindowVO, TabNo, rs, mWindowVO.WindowType.equals(WINDOWTYPE_QUERY), onlyCurrentDays, AD_UserDef_Win_ID)) == null && firstTab) break;
                if (mTabVO == null) continue;
                if (!mTabVO.IsReadOnly && "N".equals(mWindowVO.IsReadWrite)) {
                    mTabVO.IsReadOnly = true;
                }
                mWindowVO.Tabs.add(mTabVO);
                ++TabNo;
                firstTab = false;
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            CLogger.get().log(Level.SEVERE, "createTabs", e);
            return false;
        }
        if (TabNo == 0 || mWindowVO.Tabs.size() == 0) {
            CLogger.get().log(Level.SEVERE, "No Tabs - AD_Window_ID=" + mWindowVO.AD_Window_ID + " - " + sql);
            return false;
        }
        mWindowVO.ctx.setContext(mWindowVO.WindowNo, "BaseTable_ID", mWindowVO.AD_Table_ID);
        return true;
    }

    private GridWindowVO(Ctx newCtx, int windowNo) {
        this.ctx = newCtx;
        this.WindowNo = windowNo;
    }

    public void setCtx(Ctx newCtx) {
        this.ctx = newCtx;
        for (int i = 0; i < this.Tabs.size(); ++i) {
            GridTabVO tab = this.Tabs.get(i);
            tab.setCtx(newCtx);
        }
    }

    public GridWindowVO clone(int windowNo) {
        GridWindowVO clone = null;
        try {
            clone = new GridWindowVO(this.ctx, windowNo);
            clone.AD_Window_ID = this.AD_Window_ID;
            clone.Name = this.Name;
            clone.Description = this.Description;
            clone.Help = this.Help;
            clone.WindowType = this.WindowType;
            clone.AD_Image_ID = this.AD_Image_ID;
            clone.AD_Color_ID = this.AD_Color_ID;
            clone.IsReadWrite = this.IsReadWrite;
            clone.WinWidth = this.WinWidth;
            clone.WinHeight = this.WinHeight;
            clone.IsSOTrx = this.IsSOTrx;
            this.ctx.setContext(windowNo, "IsSOTrx", clone.IsSOTrx);
            clone.AD_Table_ID = this.AD_Table_ID;
            this.ctx.setContext(windowNo, "BaseTable_ID", clone.AD_Table_ID);
            clone.Tabs = new ArrayList();
            for (int i = 0; i < this.Tabs.size(); ++i) {
                GridTabVO tab = this.Tabs.get(i);
                GridTabVO cloneTab = tab.clone(clone.ctx, windowNo);
                if (cloneTab == null) {
                    return null;
                }
                clone.Tabs.add(cloneTab);
            }
        }
        catch (Exception e) {
            clone = null;
        }
        return clone;
    }
}

