/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import org.compiere.framework.Lookup;
import org.compiere.framework.Query;
import org.compiere.framework.ZoomTarget;
import org.compiere.model.MLookupCache;
import org.compiere.model.MLookupInfo;
import org.compiere.util.CLogMgt;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.NamePair;
import org.compiere.util.ValueNamePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MLookup
extends Lookup
implements Serializable {
    public static final String INACTIVE_S = "~";
    public static final String INACTIVE_E = "~";
    private static final int MAX_ROWS = 10000;
    private static Integer MINUS_ONE = new Integer(-1);
    MLookupInfo m_info = null;
    volatile Map<Object, NamePair> m_lookup = new LinkedHashMap<Object, NamePair>();
    private MLoader m_loader;
    boolean m_allLoaded = false;
    boolean m_hasInactive = false;
    private long m_nextRead = 0L;
    private HashMap<Object, Object> m_lookupDirect = null;
    private Object m_directNullKey = null;

    public MLookup(Ctx ctx, int windowNo, int displayType) {
        super(ctx, windowNo, displayType);
    }

    public MLookup initialize(MLookupInfo info) {
        this.m_info = info;
        this.log.fine(this.m_info.KeyColumn);
        if (MLookupCache.loadFromCache(this.m_info, this.m_lookup)) {
            return this;
        }
        if (this.getDisplayType() == 30 || this.m_info.IsCreadedUpdatedBy) {
            return this;
        }
        if (this.m_info.IsParent || this.m_info.IsKey) {
            this.m_hasInactive = true;
            return this;
        }
        this.m_loader = new MLoader();
        this.m_loader.start();
        return this;
    }

    @Override
    public void dispose() {
        if (this.m_info != null) {
            this.log.fine(this.m_info.KeyColumn + ": dispose");
        }
        if (this.m_loader != null && this.m_loader.isAlive()) {
            this.m_loader.interrupt();
        }
        this.m_loader = null;
        if (this.m_lookup != null) {
            this.m_lookup.clear();
        }
        this.m_lookup = null;
        if (this.m_lookupDirect != null) {
            this.m_lookupDirect.clear();
        }
        this.m_lookupDirect = null;
        this.m_info = null;
        super.dispose();
    }

    @Override
    public void loadComplete() {
        if (this.m_loader != null && this.m_loader.isAlive()) {
            try {
                this.m_loader.join();
                this.m_loader = null;
            }
            catch (InterruptedException ie) {
                this.log.log(Level.SEVERE, this.m_info.KeyColumn + ": Interrupted", ie);
            }
        }
    }

    @Override
    public NamePair get(Object key) {
        NamePair retValue;
        if (key == null || MINUS_ONE.equals(key)) {
            return null;
        }
        if (this.m_info.IsParent && this.m_nextRead < System.currentTimeMillis()) {
            this.m_lookup.clear();
            if (this.m_lookupDirect != null) {
                this.m_lookupDirect.clear();
            }
            this.m_nextRead = System.currentTimeMillis() + 500L;
        }
        if ((retValue = this.m_lookup.get(key)) != null) {
            return retValue;
        }
        if (this.m_loader != null && this.m_loader.isAlive()) {
            this.log.finer((this.m_info.KeyColumn == null ? "ID=" + this.m_info.Column_ID : this.m_info.KeyColumn) + ": waiting for Loader");
            this.loadComplete();
            retValue = this.m_lookup.get(key);
            if (retValue != null) {
                return retValue;
            }
        }
        if (!this.m_info.IsParent && this.m_info.IsValidated && this.m_allLoaded) {
            this.log.finer(this.m_info.KeyColumn + ": <NULL> - " + key + "; Size=" + this.m_lookup.size());
            return this.getDirect(key, false, true);
        }
        this.log.finest(this.m_info.KeyColumn + ": " + key + "; Size=" + this.m_lookup.size() + "; Validated=" + this.m_info.IsValidated + "; All Loaded=" + this.m_allLoaded + "; HasInactive=" + this.m_hasInactive);
        if (!(this.m_allLoaded || this.m_lookup.size() != 0 || this.m_info.IsCreadedUpdatedBy || this.m_info.IsParent || this.getDisplayType() == 30)) {
            this.m_loader = new MLoader();
            this.m_loader.run();
            retValue = this.m_lookup.get(key);
            if (retValue != null) {
                return retValue;
            }
        }
        boolean cacheLocal = this.m_info.IsValidated;
        return this.getDirect(key, false, cacheLocal);
    }

    @Override
    public String getDisplay(Object key) {
        if (key == null) {
            return "";
        }
        NamePair display = this.get(key);
        if (display == null) {
            return "<" + key.toString() + ">";
        }
        return display.toString();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.m_lookup.containsKey(key);
    }

    @Override
    public String toString() {
        return "MLookup[" + this.m_info.KeyColumn + ",Column_ID=" + this.m_info.Column_ID + ",Size=" + this.m_lookup.size() + ",Validated=" + this.isValidated() + "-" + this.getValidation() + "]";
    }

    public boolean equals(Object obj) {
        if (obj instanceof MLookup) {
            MLookup ll = (MLookup)obj;
            if (ll.m_info.Column_ID == this.m_info.Column_ID) {
                return true;
            }
        }
        return false;
    }

    public int size() {
        return this.m_lookup.size();
    }

    public boolean isAllLoaded() {
        return this.m_allLoaded;
    }

    @Override
    public void disableValidation() {
        String validationCode = this.m_info.ValidationCode;
        super.disableValidation();
        this.m_info.IsValidated = true;
        this.m_info.ValidationCode = "";
        if (validationCode != null && validationCode.length() > 0 && (validationCode.indexOf("@") != -1 && this.getDisplayType() == 18 || this.getDisplayType() == 19)) {
            this.setDisplayType(30);
        }
    }

    @Override
    public boolean isValidated() {
        if (this.isValidationDisabled()) {
            return true;
        }
        if (this.m_info == null) {
            return false;
        }
        return this.m_info.IsValidated;
    }

    @Override
    public String getValidation() {
        if (this.isValidationDisabled()) {
            return "";
        }
        return this.m_info.ValidationCode;
    }

    public int getAD_Reference_Value_ID() {
        return this.m_info.AD_Reference_Value_ID;
    }

    @Override
    public boolean hasInactive() {
        return this.m_hasInactive;
    }

    private ArrayList<NamePair> getData(boolean onlyValidated, boolean loadParent) {
        if (this.m_loader != null && this.m_loader.isAlive()) {
            this.log.fine((this.m_info.KeyColumn == null ? "ID=" + this.m_info.Column_ID : this.m_info.KeyColumn) + ": waiting for Loader");
            this.loadComplete();
        }
        if (!this.m_allLoaded || this.m_lookup.size() == 0) {
            this.refresh(loadParent);
        }
        if (this.m_info.IsValidated) {
            return new ArrayList<NamePair>(this.m_lookup.values());
        }
        if (!this.m_info.IsValidated && onlyValidated) {
            this.refresh(loadParent);
            this.log.fine(this.m_info.KeyColumn + ": Validated - #" + this.m_lookup.size());
        }
        return new ArrayList<NamePair>(this.m_lookup.values());
    }

    @Override
    public ArrayList<NamePair> getData(boolean mandatory, boolean onlyValidated, boolean onlyActive, boolean temporary) {
        ArrayList<NamePair> list = this.getData(onlyValidated, temporary);
        if (onlyActive && this.m_hasInactive) {
            for (int i = list.size(); i > 0; --i) {
                String s;
                NamePair o = list.get(i - 1);
                if (o == null || !(s = o.toString()).startsWith("~") || !s.endsWith("~")) continue;
                list.remove(i - 1);
            }
        }
        if (!mandatory) {
            Object p = null;
            p = this.m_info.KeyColumn != null && this.m_info.KeyColumn.endsWith("_ID") ? new KeyNamePair(-1, "") : new ValueNamePair("", "");
            list.add(0, (NamePair)p);
        }
        return list;
    }

    @Override
    public NamePair getDirect(Object key, boolean saveInCache, boolean cacheLocal) {
        if (key == null || this.m_info.QueryDirect == null || this.m_info.QueryDirect.length() == 0) {
            return null;
        }
        if (key.equals(this.m_directNullKey)) {
            return null;
        }
        NamePair directValue = null;
        if (this.m_lookupDirect != null && (directValue = (NamePair)this.m_lookupDirect.get(key)) != null) {
            return directValue;
        }
        this.log.finer(this.m_info.KeyColumn + ": " + key + ", SaveInCache=" + saveInCache + ",Local=" + cacheLocal);
        boolean isNumber = this.m_info.KeyColumn.endsWith("_ID");
        try {
            CPreparedStatement pstmt = DB.prepareStatement(this.m_info.QueryDirect, null);
            if (isNumber) {
                pstmt.setInt(1, Integer.parseInt(key.toString()));
            } else {
                pstmt.setString(1, key.toString());
            }
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                String name = rs.getString(3);
                if (isNumber) {
                    int keyValue = rs.getInt(1);
                    KeyNamePair p = new KeyNamePair(keyValue, name);
                    if (saveInCache) {
                        this.m_lookup.put(new Integer(keyValue), (NamePair)p);
                    }
                    directValue = p;
                } else {
                    String value = rs.getString(2);
                    ValueNamePair p = new ValueNamePair(value, name);
                    if (saveInCache) {
                        this.m_lookup.put(value, (NamePair)p);
                    }
                    directValue = p;
                }
                if (rs.next()) {
                    this.log.log(Level.SEVERE, this.m_info.KeyColumn + ": Not unique (first returned) for " + key + " SQL=" + this.m_info.QueryDirect);
                }
            } else {
                this.m_directNullKey = key;
                directValue = null;
            }
            rs.close();
            pstmt.close();
            if (CLogMgt.isLevelFinest()) {
                this.log.finest(this.m_info.KeyColumn + ": " + directValue + " - " + this.m_info);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, this.m_info.KeyColumn + ": SQL=" + this.m_info.QueryDirect + "; Key=" + key, e);
            directValue = null;
        }
        if (cacheLocal && !saveInCache && directValue != null) {
            if (this.m_lookupDirect == null) {
                this.m_lookupDirect = new HashMap();
            }
            this.m_lookupDirect.put(key, directValue);
        }
        this.m_hasInactive = true;
        return directValue;
    }

    @Override
    public int getZoomWindow() {
        return this.m_info.ZoomWindow;
    }

    @Override
    public int getZoomWindow(Query query) {
        int AD_Window_ID = ZoomTarget.getZoomAD_Window_ID(this.m_info.TableName, this.m_WindowNo, query.getWhereClause(), this.getCtx().isSOTrx(this.m_WindowNo));
        return AD_Window_ID;
    }

    @Override
    public Query getZoomQuery() {
        return this.m_info.ZoomQuery;
    }

    @Override
    public String getColumnName() {
        return this.m_info.KeyColumn;
    }

    @Override
    public int refresh() {
        return this.refresh(true);
    }

    public int refresh(boolean loadParent) {
        if (!loadParent && this.m_info.IsParent) {
            return 0;
        }
        if (this.getDisplayType() == 30 || this.m_info.IsCreadedUpdatedBy) {
            return 0;
        }
        this.log.fine(this.m_info.KeyColumn + ": start");
        this.m_loader = new MLoader();
        this.m_loader.start();
        this.loadComplete();
        this.log.fine(this.m_info.KeyColumn + ": #" + this.m_lookup.size());
        return this.m_lookup.size();
    }

    @Override
    public void removeAllElements() {
        super.removeAllElements();
        this.m_lookup.clear();
        if (this.m_lookupDirect != null) {
            this.m_lookupDirect.clear();
        }
    }

    class MLoader
    extends Thread
    implements Serializable {
        private long m_startTime;

        public MLoader() {
            super("MLoader-" + MLookup.this.m_info.KeyColumn);
            this.m_startTime = System.currentTimeMillis();
        }

        public void run() {
            long startTime = System.currentTimeMillis();
            MLookupCache.loadStart(MLookup.this.m_info);
            String sql = MLookup.this.m_info.Query;
            if (!MLookup.this.m_info.IsValidated) {
                String validation = Env.parseContext(MLookup.this.getCtx(), MLookup.this.getWindowNo(), MLookup.this.m_info.ValidationCode, false);
                if (validation.length() == 0 && MLookup.this.m_info.ValidationCode.length() > 0) {
                    MLookup.this.log.fine(MLookup.this.m_info.KeyColumn + ": Loader NOT Validated: " + MLookup.this.m_info.ValidationCode);
                    return;
                }
                MLookup.this.log.fine(MLookup.this.m_info.KeyColumn + ": Loader Validated: " + validation);
                int posFrom = sql.lastIndexOf(" FROM ");
                boolean hasWhere = sql.indexOf(" WHERE ", posFrom) != -1;
                int posOrder = sql.lastIndexOf(" ORDER BY ");
                sql = posOrder != -1 ? sql.substring(0, posOrder) + (hasWhere ? " AND " : " WHERE ") + validation + sql.substring(posOrder) : sql + (hasWhere ? " AND " : " WHERE ") + validation;
                if (CLogMgt.isLevelFinest()) {
                    MLookup.this.log.fine(MLookup.this.m_info.KeyColumn + ": Validation=" + validation);
                }
            }
            if (this.isInterrupted()) {
                MLookup.this.log.log(Level.WARNING, MLookup.this.m_info.KeyColumn + ": Loader interrupted");
                return;
            }
            if (CLogMgt.isLevelFiner()) {
                MLookup.this.getCtx().setContext(1111, MLookup.this.m_info.Column_ID, MLookup.this.m_info.KeyColumn, sql);
            }
            if (CLogMgt.isLevelFinest()) {
                MLookup.this.log.fine(MLookup.this.m_info.KeyColumn + ": " + sql);
            }
            MLookup.this.m_lookup.clear();
            boolean isNumber = MLookup.this.m_info.KeyColumn.endsWith("_ID");
            MLookup.this.m_hasInactive = false;
            int rows = 0;
            try {
                CPreparedStatement pstmt = DB.prepareStatement(sql, null);
                ResultSet rs = pstmt.executeQuery();
                MLookup.this.m_allLoaded = true;
                while (rs.next()) {
                    KeyNamePair p;
                    if (rows++ > 10000) {
                        MLookup.this.log.warning(MLookup.this.m_info.KeyColumn + ": Loader - Too many records");
                        MLookup.this.m_allLoaded = false;
                        break;
                    }
                    if (rows % 20 == 0 && this.isInterrupted()) break;
                    String name = rs.getString(3);
                    boolean isActive = rs.getString(4).equals("Y");
                    if (!isActive) {
                        name = "~" + name + "~";
                        MLookup.this.m_hasInactive = true;
                    }
                    if (isNumber) {
                        int key = rs.getInt(1);
                        p = new KeyNamePair(key, name);
                        MLookup.this.m_lookup.put(new Integer(key), (NamePair)p);
                        continue;
                    }
                    String value = rs.getString(2);
                    p = new ValueNamePair(value, name);
                    MLookup.this.m_lookup.put(value, (NamePair)p);
                }
                rs.close();
                pstmt.close();
            }
            catch (SQLException e) {
                MLookup.this.log.log(Level.SEVERE, MLookup.this.m_info.KeyColumn + ": Loader - " + sql, e);
            }
            int size = MLookup.this.m_lookup.size();
            MLookup.this.log.finer(MLookup.this.m_info.KeyColumn + " (" + MLookup.this.m_info.Column_ID + "):" + " - Loader complete #" + size + " - all=" + MLookup.this.m_allLoaded + " - ms=" + String.valueOf(System.currentTimeMillis() - this.m_startTime) + " (" + String.valueOf(System.currentTimeMillis() - startTime) + ")");
            MLookupCache.loadEnd(MLookup.this.m_info, MLookup.this.m_lookup);
        }
    }
}

