/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MPInstanceLog;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MProcess;
import org.compiere.model.MProcessPara;
import org.compiere.model.MRole;
import org.compiere.model.MSession;
import org.compiere.model.X_AD_PInstance;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class MPInstance
extends X_AD_PInstance {
    private MPInstancePara[] m_parameters = null;
    private ArrayList<MPInstanceLog> m_log = new ArrayList();
    public static final int RESULT_OK = 1;
    public static final int RESULT_ERROR = 0;

    public MPInstance(Ctx ctx, int AD_PInstance_ID, String ignored) {
        super(ctx, AD_PInstance_ID, null);
        if (AD_PInstance_ID == 0) {
            int AD_Role_ID = ctx.getAD_Role_ID();
            if (AD_Role_ID != 0) {
                this.setAD_Role_ID(AD_Role_ID);
            }
            this.setIsProcessing(false);
        }
    }

    public MPInstance(Ctx ctx, ResultSet rs, String ignored) {
        super(ctx, rs, null);
    }

    public MPInstance(MProcess process, int Record_ID) {
        this(process.getCtx(), 0, null);
        this.setAD_Process_ID(process.getAD_Process_ID());
        this.setRecord_ID(Record_ID);
        this.setAD_User_ID(process.getCtx().getAD_User_ID());
        if (!this.save()) {
            throw new IllegalArgumentException("Cannot Save");
        }
        MProcessPara[] para = process.getParameters();
        for (int i = 0; i < para.length; ++i) {
            MPInstancePara pip = new MPInstancePara(this, para[i].getSeqNo());
            pip.setParameterName(para[i].getColumnName());
            pip.setInfo(para[i].getName());
            pip.save();
        }
    }

    public MPInstance(Ctx ctx, int AD_Process_ID, int Record_ID) {
        this(ctx, 0, null);
        this.setAD_Process_ID(AD_Process_ID);
        this.setRecord_ID(Record_ID);
        this.setAD_User_ID(ctx.getAD_User_ID());
        this.setIsProcessing(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MPInstancePara[] getParameters() {
        if (this.m_parameters != null) {
            return this.m_parameters;
        }
        ArrayList<MPInstancePara> list = new ArrayList<MPInstancePara>();
        String sql = "SELECT * FROM AD_PInstance_Para WHERE AD_PInstance_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.getAD_PInstance_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MPInstancePara(this.getCtx(), rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            pstmt = null;
        }
        this.m_parameters = new MPInstancePara[list.size()];
        list.toArray(this.m_parameters);
        return this.m_parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MPInstanceLog[] getLog() {
        this.m_log.clear();
        String sql = "SELECT * FROM AD_PInstance_Log WHERE AD_PInstance_ID=? ORDER BY Log_ID";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.getAD_PInstance_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                this.m_log.add(new MPInstanceLog(rs));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            pstmt = null;
        }
        MPInstanceLog[] retValue = new MPInstanceLog[this.m_log.size()];
        this.m_log.toArray(retValue);
        return retValue;
    }

    public void addLog(Timestamp P_Date, int P_ID, BigDecimal P_Number, String P_Msg) {
        MPInstanceLog logEntry = new MPInstanceLog(this.getAD_PInstance_ID(), this.m_log.size() + 1, P_Date, P_ID, P_Number, P_Msg);
        this.m_log.add(logEntry);
    }

    public void setAD_Process_ID(int AD_Process_ID) {
        MRole role;
        Boolean access;
        int AD_Role_ID = this.getCtx().getAD_Role_ID();
        if (!(AD_Role_ID == 0 || (access = (role = MRole.get(this.getCtx(), AD_Role_ID)).getProcessAccess(AD_Process_ID)) != null && access.booleanValue())) {
            throw new IllegalAccessError("Cannot access Process " + AD_Process_ID + " with Role: " + role.getName());
        }
        super.setAD_Process_ID(AD_Process_ID);
    }

    public void setRecord_ID(int Record_ID) {
        if (Record_ID < 0) {
            this.log.info("Set to 0 from " + Record_ID);
            Record_ID = 0;
        }
        this.set_ValueNoCheck("Record_ID", new Integer(Record_ID));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MPInstance[").append(this.get_ID()).append(",OK=").append(this.isOK());
        String msg = this.getErrorMsg();
        if (msg != null && msg.length() > 0) {
            sb.append(msg);
        }
        sb.append("]");
        return sb.toString();
    }

    public void log() {
        this.log.info(this.toString());
        MPInstanceLog[] pil = this.getLog();
        for (int i = 0; i < pil.length; ++i) {
            this.log.info(i + "=" + pil[i]);
        }
    }

    public boolean isOK() {
        return this.getResult() == 1;
    }

    public void setResult(boolean ok) {
        super.setResult(ok ? 1 : 0);
    }

    protected boolean beforeSave(boolean newRecord) {
        if (newRecord && this.getAD_Session_ID() == 0) {
            MSession session = MSession.get(this.getCtx(), true);
            int AD_Session_ID = session.getAD_Session_ID();
            this.setAD_Session_ID(AD_Session_ID);
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!newRecord && !this.isProcessing() && this.is_ValueChanged("IsProcessing")) {
            long ms = System.currentTimeMillis() - this.getCreated().getTime();
            int seconds = (int)(ms / 1000L);
            if (seconds < 1) {
                seconds = 1;
            }
            MProcess prc = MProcess.get(this.getCtx(), this.getAD_Process_ID());
            prc.addStatistics(seconds);
            if (prc.get_ID() != 0 && prc.save()) {
                this.log.fine("afterSave - Process Statistics updated Sec=" + seconds);
            } else {
                this.log.warning("afterSave - Process Statistics not updated");
            }
        }
        return success;
    }
}

