/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;
import org.compiere.Compiere;
import org.compiere.framework.PO;
import org.compiere.model.MCountry;
import org.compiere.model.X_C_Region;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MRegion
extends X_C_Region
implements Comparator<PO>,
Serializable {
    private static CCache<String, MRegion> s_regions = null;
    private static MRegion s_default = null;
    private static CLogger s_log = CLogger.getCLogger(MRegion.class);

    private static void loadAllRegions(Ctx ctx) {
        s_regions = new CCache("C_Region", 100);
        String sql = "SELECT * FROM C_Region WHERE IsActive='Y'";
        try {
            Statement stmt = DB.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                MRegion r = new MRegion(ctx, rs, null);
                s_regions.put(String.valueOf(r.getC_Region_ID()), r);
                if (!r.isDefault()) continue;
                s_default = r;
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        s_log.fine(s_regions.size() + " - default=" + s_default);
    }

    public static MRegion get(Ctx ctx, int C_Region_ID) {
        String key;
        MRegion r;
        if (s_regions == null || s_regions.size() == 0) {
            MRegion.loadAllRegions(ctx);
        }
        if ((r = s_regions.get(key = String.valueOf(C_Region_ID))) != null) {
            return r;
        }
        r = new MRegion(ctx, C_Region_ID, null);
        if (r.getC_Region_ID() == C_Region_ID) {
            s_regions.put(key, r);
            return r;
        }
        return null;
    }

    public static MRegion getDefault(Ctx ctx) {
        if (s_regions == null || s_regions.size() == 0) {
            MRegion.loadAllRegions(ctx);
        }
        return s_default;
    }

    public static MRegion[] getRegions(Ctx ctx) {
        if (s_regions == null || s_regions.size() == 0) {
            MRegion.loadAllRegions(ctx);
        }
        MRegion[] retValue = new MRegion[s_regions.size()];
        s_regions.values().toArray(retValue);
        Arrays.sort(retValue, new MRegion(ctx, 0, null));
        return retValue;
    }

    public static MRegion[] getRegions(Ctx ctx, int C_Country_ID) {
        if (s_regions == null || s_regions.size() == 0) {
            MRegion.loadAllRegions(ctx);
        }
        ArrayList<MRegion> list = new ArrayList<MRegion>();
        for (MRegion r : s_regions.values()) {
            if (r.getC_Country_ID() != C_Country_ID) continue;
            list.add(r);
        }
        MRegion[] retValue = new MRegion[list.size()];
        list.toArray(retValue);
        Arrays.sort(retValue, new MRegion(ctx, 0, null));
        return retValue;
    }

    public MRegion(Ctx ctx, int C_Region_ID, String trxName) {
        super(ctx, C_Region_ID, trxName);
        if (C_Region_ID == 0) {
            // empty if block
        }
    }

    public MRegion(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MRegion(MCountry country, String regionName) {
        super(country.getCtx(), 0, country.get_TrxName());
        this.setC_Country_ID(country.getC_Country_ID());
        this.setName(regionName);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public int compare(PO o1, PO o2) {
        String s2;
        String s1 = o1.toString();
        if (s1 == null) {
            s1 = "";
        }
        if ((s2 = o2.toString()) == null) {
            s2 = "";
        }
        return s1.compareTo(s2);
    }

    public static void main(String[] args) {
        Compiere.startup(true);
        int C_Country_ID = 216;
        MCountry country = new MCountry(Env.getCtx(), C_Country_ID, null);
        MRegion temp = new MRegion(country, "\u5317\u6d77\u9053");
        temp.setDescription("\u5317\u6d77\u9053(Hokkaido)");
        temp.save();
        temp = new MRegion(country, "\u9752\u68ee\u770c");
        temp.setDescription("\u9752\u68ee\u770c(Aomori)");
        temp.save();
        temp = new MRegion(country, "\u5ca9\u624b\u770c");
        temp.setDescription("\u5ca9\u624b\u770c(Iwate)");
        temp.save();
        temp = new MRegion(country, "\u5bae\u57ce\u770c");
        temp.setDescription("\u5bae\u57ce\u770c(Miyagi)");
        temp.save();
        temp = new MRegion(country, "\u79cb\u7530\u770c");
        temp.setDescription("\u79cb\u7530\u770c(Akita)");
        temp.save();
        temp = new MRegion(country, "\u5c71\u5f62\u770c");
        temp.setDescription("\u5c71\u5f62\u770c(Yamagata)");
        temp.save();
        temp = new MRegion(country, "\u798f\u5cf6\u770c");
        temp.setDescription("\u798f\u5cf6\u770c(Fukushima)");
        temp.save();
        temp = new MRegion(country, "\u8328\u57ce\u770c");
        temp.setDescription("\u8328\u57ce\u770c(Ibaraki)");
        temp.save();
        temp = new MRegion(country, "\u7fa4\u99ac\u770c");
        temp.setDescription("\u7fa4\u99ac\u770c(Gunma)");
        temp.save();
        temp = new MRegion(country, "\u57fc\u7389\u770c");
        temp.setDescription("\u57fc\u7389\u770c(Saitama)");
        temp.save();
        temp = new MRegion(country, "\u5343\u8449\u770c");
        temp.setDescription("\u5343\u8449\u770c(Chiba)");
        temp.save();
        temp = new MRegion(country, "\u6771\u4eac\u90fd");
        temp.setDescription("\u6771\u4eac\u90fd(Tokyo)");
        temp.save();
        temp = new MRegion(country, "\u795e\u5948\u5ddd\u770c");
        temp.setDescription("\u795e\u5948\u5ddd\u770c(Kanagawa)");
        temp.save();
        temp = new MRegion(country, "\u65b0\u6f5f\u770c");
        temp.setDescription("\u65b0\u6f5f\u770c(Niigata)");
        temp.save();
        temp = new MRegion(country, "\u5bcc\u5c71\u770c");
        temp.setDescription("\u5bcc\u5c71\u770c(Toyama)");
        temp.save();
        temp = new MRegion(country, "\u77f3\u5ddd\u770c");
        temp.setDescription("\u77f3\u5ddd\u770c(Ishikawa)");
        temp.save();
        temp = new MRegion(country, "\u798f\u4e95\u770c");
        temp.setDescription("\u798f\u4e95\u770c(Fukui)");
        temp.save();
        temp = new MRegion(country, "\u5c71\u68a8\u770c");
        temp.setDescription("\u5c71\u68a8\u770c(Yamanashi)");
        temp.save();
        temp = new MRegion(country, "\u5c90\u961c\u770c");
        temp.setDescription("\u5c90\u961c\u770c(Gifu)");
        temp.save();
        temp = new MRegion(country, "\u9759\u5ca1\u770c");
        temp.setDescription("\u9759\u5ca1\u770c(Shizuoka)");
        temp.save();
        temp = new MRegion(country, "\u611b\u77e5\u770c");
        temp.setDescription("\u611b\u77e5\u770c(Aichi)");
        temp.save();
        temp = new MRegion(country, "\u4e09\u91cd\u770c");
        temp.setDescription("\u4e09\u91cd\u770c(Mie)");
        temp.save();
        temp = new MRegion(country, "\u6ecb\u8cc0\u770c");
        temp.setDescription("\u6ecb\u8cc0\u770c(Siga)");
        temp.save();
        temp = new MRegion(country, "\u4eac\u90fd\u5e9c");
        temp.setDescription("\u4eac\u90fd\u5e9c(Kyoto)");
        temp.save();
        temp = new MRegion(country, "\u5927\u962a\u5e9c");
        temp.setDescription("\u5927\u962a\u5e9c(Osaka)");
        temp.save();
        temp = new MRegion(country, "\u5175\u5eab\u770c");
        temp.setDescription("\u5175\u5eab\u770c(Hyogo)");
        temp.save();
        temp = new MRegion(country, "\u5948\u826f\u770c");
        temp.setDescription("\u5948\u826f\u770c(Nara)");
        temp.save();
        temp = new MRegion(country, "\u548c\u6b4c\u5c71\u770c");
        temp.setDescription("\u548c\u6b4c\u5c71\u770c(Wakayama)");
        temp.save();
        temp = new MRegion(country, "\u9ce5\u53d6\u770c");
        temp.setDescription("\u9ce5\u53d6\u770c(Tottori)");
        temp.save();
        temp = new MRegion(country, "\u5cf6\u6839\u770c");
        temp.setDescription("\u5cf6\u6839\u770c(Shimane)");
        temp.save();
        temp = new MRegion(country, "\u5ca1\u5c71\u770c");
        temp.setDescription("\u5ca1\u5c71\u770c(Okayama)");
        temp.save();
        temp = new MRegion(country, "\u5e83\u5cf6\u770c");
        temp.setDescription("\u5e83\u5cf6\u770c(Hiroshima)");
        temp.save();
        temp = new MRegion(country, "\u5c71\u53e3\u770c");
        temp.setDescription("\u5c71\u53e3\u770c(Yamaguchi)");
        temp.save();
        temp = new MRegion(country, "\u5fb3\u5cf6\u770c");
        temp.setDescription("\u5fb3\u5cf6\u770c(Tokushima)");
        temp.save();
        temp = new MRegion(country, "\u9999\u5ddd\u770c");
        temp.setDescription("\u9999\u5ddd\u770c(Kagawa)");
        temp.save();
        temp = new MRegion(country, "\u611b\u5a9b\u770c");
        temp.setDescription("\u611b\u5a9b\u770c(Ehime)");
        temp.save();
        temp = new MRegion(country, "\u9ad8\u77e5\u770c");
        temp.setDescription("\u9ad8\u77e5\u770c(Kouchi)");
        temp.save();
        temp = new MRegion(country, "\u798f\u5ca1\u770c");
        temp.setDescription("\u798f\u5ca1\u770c(Fukuoka)");
        temp.save();
        temp = new MRegion(country, "\u4f50\u8cc0\u770c");
        temp.setDescription("\u4f50\u8cc0\u770c(Saga)");
        temp.save();
        temp = new MRegion(country, "\u9577\u5d0e\u770c");
        temp.setDescription("\u9577\u5d0e\u770c(Nagasaki)");
        temp.save();
        temp = new MRegion(country, "\u718a\u672c\u770c");
        temp.setDescription("\u718a\u672c\u770c(Kumamoto)");
        temp.save();
        temp = new MRegion(country, "\u5927\u5206\u770c");
        temp.setDescription("\u5927\u5206\u770c(Ohita)");
        temp.save();
        temp = new MRegion(country, "\u5bae\u5d0e\u770c");
        temp.setDescription("\u5bae\u5d0e\u770c(Miyasaki)");
        temp.save();
        temp = new MRegion(country, "\u9e7f\u5150\u5cf6\u770c");
        temp.setDescription("\u9e7f\u5150\u5cf6\u770c(Kagoshima)");
        temp.save();
        temp = new MRegion(country, "\u6c96\u7e04\u770c");
        temp.setDescription("\u6c96\u7e04\u770c(Okinawa)");
        temp.save();
    }
}

