/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import org.compiere.db.CConnection;
import org.compiere.db.LDAP;
import org.compiere.model.X_AD_System;
import org.compiere.util.CLogMgt;
import org.compiere.util.CMemoryUsage;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;

public class MSystem
extends X_AD_System {
    private static MSystem s_system = null;

    public static MSystem get(Ctx ctx) {
        if (s_system != null) {
            return s_system;
        }
        String sql = "SELECT * FROM AD_System ORDER BY AD_System_ID";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                s_system = new MSystem(ctx, rs, null);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            String info = "No System - " + DB.getDatabaseInfo() + " - " + ex.getLocalizedMessage();
            System.err.println(info);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        pstmt = null;
        if (s_system == null) {
            return null;
        }
        if (!Ini.isClient() && s_system.setInfo()) {
            s_system.save();
        }
        return s_system;
    }

    public MSystem(Ctx ctx, int ignored, String mtrxName) {
        super(ctx, 0, mtrxName);
        String trxName = null;
        if (ignored >= 0) {
            this.load(trxName);
        }
        if (s_system == null) {
            s_system = this;
        }
    }

    public MSystem(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
        if (s_system == null) {
            s_system = this;
        }
    }

    public MSystem() {
        this(new Ctx(), 0, null);
    }

    public boolean isLDAP() {
        String host = this.getLDAPHost();
        if (host == null || host.length() == 0) {
            return false;
        }
        String domain = this.getLDAPDomain();
        return domain != null && domain.length() > 0;
    }

    public boolean isLDAP(String userName, String password) {
        return LDAP.validate(this.getLDAPHost(), this.getLDAPDomain(), userName, password);
    }

    public String getDBAddress(boolean actual) {
        String s = super.getDBAddress();
        if (actual || s == null || s.length() == 0) {
            CConnection cc = CConnection.get();
            s = cc.getConnectionURL() + "#" + cc.getDbUid();
            s = s.toLowerCase();
        }
        return s;
    }

    public String getStatisticsInfo(boolean recalc) {
        String s = super.getStatisticsInfo();
        if (s == null || recalc) {
            String count = DB.TO_CHAR("COUNT(*)", 22, Env.getAD_Language(Env.getCtx()));
            String sql = "SELECT 'C'||(SELECT " + count + " FROM AD_Client)" + " ||'U'||(SELECT " + count + " FROM AD_User)" + " ||'B'||(SELECT " + count + " FROM C_BPartner)" + " ||'P'||(SELECT " + count + " FROM M_Product)" + " ||'I'||(SELECT " + count + " FROM C_Invoice)" + " ||'L'||(SELECT " + count + " FROM C_InvoiceLine)" + " ||'M'||(SELECT " + count + " FROM M_Transaction)" + " ||'c'||(SELECT " + count + " FROM AD_Column WHERE EntityType NOT IN ('C','D'))" + " ||'t'||(SELECT " + count + " FROM AD_Table WHERE EntityType NOT IN ('C','D'))" + " ||'f'||(SELECT " + count + " FROM AD_Field WHERE EntityType NOT IN ('C','D'))" + " FROM AD_System";
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement(sql, null);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    s = rs.getString(1);
                }
                rs.close();
                pstmt.close();
                pstmt = null;
                this.setStatisticsInfo(s);
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql, e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception e) {
                pstmt = null;
            }
        }
        return s;
    }

    public String getProfileInfo(boolean recalc) {
        String s = super.getProfileInfo();
        if (s == null || recalc) {
            String sql = "SELECT Value FROM AD_Client WHERE IsActive='Y' ORDER BY AD_Client_ID DESC";
            CPreparedStatement pstmt = null;
            StringBuffer sb = new StringBuffer();
            try {
                pstmt = DB.prepareStatement(sql, null);
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    sb.append(rs.getString(1)).append('|');
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql, e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception e) {
                pstmt = null;
            }
            s = sb.toString();
        }
        return s;
    }

    protected boolean beforeSave(boolean newRecord) {
        boolean userChange;
        if (this.get_Value("IsAutoErrorReport") == null) {
            this.setIsAutoErrorReport(true);
        }
        boolean bl = userChange = Ini.isClient() && (this.is_ValueChanged("Name") || this.is_ValueChanged("UserName") || this.is_ValueChanged("Password") || this.is_ValueChanged("LDAPHost") || this.is_ValueChanged("LDAPDomain") || this.is_ValueChanged("CustomPrefix"));
        if (userChange) {
            String name = this.getName();
            if (name.equals("?") || name.length() < 2) {
                this.log.saveError("Error", "Define a unique System name (e.g. Company name) not " + name);
                return false;
            }
            if (this.getUserName().equals("?") || this.getUserName().length() < 2) {
                this.log.saveError("Error", "Use the same EMail address as in the Compiere Web Store");
                return false;
            }
            if (this.getPassword().equals("?") || this.getPassword().length() < 2) {
                this.log.saveError("Error", "Use the same Password as in the Compiere Web Store");
                return false;
            }
        }
        if (this.getSupportLevel() == null) {
            this.setSupportLevel("U");
        }
        this.setInfo();
        return true;
    }

    public boolean save() {
        if (!this.beforeSave(false)) {
            return false;
        }
        return this.saveUpdate();
    }

    public String toString() {
        return "MSystem[" + this.getName() + ",User=" + this.getUserName() + ",ReleaseNo=" + this.getReleaseNo() + "]";
    }

    public boolean isValid() {
        if (this.getName() == null || this.getName().length() < 2) {
            this.log.log(Level.WARNING, "Name not valid: " + this.getName());
            return false;
        }
        if (this.getPassword() == null || this.getPassword().length() < 2) {
            this.log.log(Level.WARNING, "Password not valid: " + this.getPassword());
            return false;
        }
        if (this.getInfo() == null || this.getInfo().length() < 2) {
            this.log.log(Level.WARNING, "Need to run Migration once");
            return false;
        }
        return true;
    }

    public boolean isPDFLicense() {
        String key = this.getSummary();
        return key != null && key.length() > 25;
    }

    public String getSupportLevel() {
        String sl = null;
        if (this.get_ColumnIndex("SupportLevel") != -1) {
            sl = super.getSupportLevel();
        }
        if (sl == null) {
            return "U";
        }
        return sl;
    }

    public int getRecord_ID() {
        if (this.get_ColumnIndex("Record_ID") == -1) {
            return -1;
        }
        return super.getRecord_ID();
    }

    public int getSupportUnits() {
        if (this.get_ColumnIndex("SupportUnits") == -1) {
            return 0;
        }
        return super.getSupportUnits();
    }

    public String getSystemStatus() {
        String ss = null;
        if (this.get_ColumnIndex("SystemStatus") != -1) {
            ss = super.getSystemStatus();
        }
        if (ss == null) {
            ss = "E";
        }
        return ss;
    }

    public boolean setInfo() {
        if (!TimeUtil.getDay(this.getUpdated()).before(TimeUtil.getDay(null))) {
            return false;
        }
        try {
            this.setDBInfo();
            this.setInternalUsers();
            if (this.isAllowStatistics()) {
                this.setStatisticsInfo(this.getStatisticsInfo(true));
                this.setProfileInfo(this.getProfileInfo(true));
            }
        }
        catch (Exception e) {
            this.setSupportUnits(9999);
            this.setInfo(e.getLocalizedMessage());
            this.log.log(Level.SEVERE, "", e);
        }
        return true;
    }

    private void setInternalUsers() {
        String sql = "SELECT COUNT(DISTINCT (u.AD_User_ID)) AS iu FROM AD_User u INNER JOIN AD_User_Roles ur ON (u.AD_User_ID=ur.AD_User_ID) WHERE u.AD_Client_ID<>11 AND u.AD_User_ID NOT IN (0,100)";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                int internalUsers = rs.getInt(1);
                this.setSupportUnits(internalUsers);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
    }

    private void setDBInfo() {
        if (!DB.isRemoteObjects()) {
            String dbAddress = this.getDBAddress(true);
            this.setDBAddress(dbAddress);
        }
        if (!Ini.isClient()) {
            int noProcessors = Runtime.getRuntime().availableProcessors();
            this.setNoProcessors(noProcessors);
        }
        try {
            DatabaseMetaData md = DB.getConnectionRO().getMetaData();
            String db1 = md.getDatabaseProductName();
            String db2 = md.getDatabaseProductVersion();
            db1 = db2.startsWith(db1) ? db2 : db1 + "-" + db2;
            int fieldLength = this.p_info.getFieldLength("DBInstance");
            if (db1.length() > fieldLength) {
                db1 = Util.replace(db1, "Database ", "");
                db1 = Util.replace(db1, "Version ", "");
                db1 = Util.replace(db1, "Edition ", "");
                db1 = Util.replace(db1, "Release ", "");
            }
            if ((db1 = Util.removeCRLF(db1)).length() > fieldLength) {
                db1 = db1.substring(0, fieldLength);
            }
            this.setDBInstance(db1);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "MetaData", e);
        }
    }

    public void info() {
        if (!CLogMgt.isLevelFine()) {
            return;
        }
        RuntimeMXBean rt = ManagementFactory.getRuntimeMXBean();
        this.log.fine(rt.getName() + " (" + rt.getVmVersion() + ") Up=" + TimeUtil.formatElapsed(rt.getUptime()));
        if (CLogMgt.isLevelFiner()) {
            List<MemoryPoolMXBean> list = ManagementFactory.getMemoryPoolMXBeans();
            for (MemoryPoolMXBean pool : list) {
                this.log.finer(pool.getName() + " " + (Object)((Object)pool.getType()) + ": " + new CMemoryUsage(pool.getUsage()));
            }
        } else {
            MemoryMXBean memory = ManagementFactory.getMemoryMXBean();
            this.log.fine("VM: " + new CMemoryUsage(memory.getNonHeapMemoryUsage()));
            this.log.fine("Heap: " + new CMemoryUsage(memory.getHeapMemoryUsage()));
        }
        ThreadMXBean th = ManagementFactory.getThreadMXBean();
        this.log.fine("Threads=" + th.getThreadCount() + ", Peak=" + th.getPeakThreadCount() + ", Demons=" + th.getDaemonThreadCount() + ", Total=" + th.getTotalStartedThreadCount());
    }

    public static void main(String[] args) {
        new MSystem();
    }

    public boolean saveLicenseOnly() {
        StringBuffer sql = new StringBuffer("UPDATE ");
        sql.append(this.p_info.getTableName()).append(" SET Name = '").append(this.getName()).append("',").append("UserName = '").append(this.getUserName()).append("',").append("Password = '").append(this.getPassword()).append("',").append("Summary = '").append(this.getSummary()).append("'").append(" WHERE AD_System_ID = ").append(this.getAD_System_ID());
        this.log.fine(sql.toString());
        int no = DB.executeUpdate(sql.toString(), null);
        return no == 1;
    }
}

