/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MField;
import org.compiere.model.MTab;
import org.compiere.model.MUserDefField;
import org.compiere.model.MUserDefWin;
import org.compiere.model.X_AD_UserDef_Tab;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class MUserDefTab
extends X_AD_UserDef_Tab {
    private MUserDefField[] m_fields = null;
    private MTab m_tab = null;

    public MUserDefTab(Ctx ctx, int AD_UserDef_Tab_ID, String trxName) {
        super(ctx, AD_UserDef_Tab_ID, trxName);
    }

    public MUserDefTab(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MUserDefTab(MUserDefWin parent) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setAD_UserDef_Win_ID(parent.getAD_UserDef_Win_ID());
    }

    public MUserDefField[] getFields(boolean reload) {
        if (this.m_fields != null && !reload) {
            return this.m_fields;
        }
        String sql = "SELECT * FROM AD_UserDef_Field WHERE AD_UserDef_Tab_ID=?";
        ArrayList<MUserDefField> list = new ArrayList<MUserDefField>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getAD_UserDef_Tab_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MUserDefField(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_fields = new MUserDefField[list.size()];
        list.toArray(this.m_fields);
        return this.m_fields;
    }

    public MUserDefField getField(String columnName) {
        MTab tab = this.getTab();
        if (tab == null) {
            return null;
        }
        int AD_Field_ID = tab.getAD_Field_ID(columnName);
        return this.getField(AD_Field_ID);
    }

    public MUserDefField getField(int AD_Field_ID) {
        if (AD_Field_ID == 0) {
            return null;
        }
        MUserDefField[] fields = this.getFields(false);
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].getAD_Field_ID() != AD_Field_ID) continue;
            return fields[i];
        }
        return null;
    }

    public MTab getTab() {
        if (this.m_tab == null) {
            this.m_tab = MTab.get(this.getCtx(), this.getAD_Tab_ID());
        }
        return this.m_tab;
    }

    public boolean create(MTab tab) {
        if (this.getAD_UserDef_Tab_ID() != 0) {
            throw new IllegalStateException("Needs to be new");
        }
        this.m_tab = tab;
        this.setAD_Tab_ID(tab.getAD_Tab_ID());
        if (!this.save()) {
            return false;
        }
        MField[] fields = tab.getFields(false, this.get_TrxName());
        for (int i = 0; i < fields.length; ++i) {
            MUserDefField ff = new MUserDefField(this);
            if (!ff.create(fields[i])) {
                return false;
            }
            this.m_fields = null;
        }
        return true;
    }
}

