/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.awt.Dimension;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MRole;
import org.compiere.model.MTab;
import org.compiere.model.MUser;
import org.compiere.model.MUserDefTab;
import org.compiere.model.MWindow;
import org.compiere.model.X_AD_UserDef_Win;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class MUserDefWin
extends X_AD_UserDef_Win {
    public static final String SYSTEMDEFAULT = "SystemDefault";
    private static CLogger s_log = CLogger.getCLogger(MUserDefWin.class);
    private MUserDefTab[] m_tabs = null;

    public static MUserDefWin[] get(Ctx ctx, int AD_Window_ID, int AD_Client_ID, int AD_Role_ID, int AD_User_ID) {
        ArrayList<MUserDefWin> list = new ArrayList<MUserDefWin>();
        StringBuffer sql = new StringBuffer("SELECT * FROM AD_UserDef_Win WHERE AD_Client_ID=? AND AD_Window_ID=?");
        if (AD_Role_ID != 0 || AD_User_ID != 0) {
            if (AD_Role_ID == 0 && AD_User_ID != 0) {
                sql.append(" AND AD_User_ID=?");
            } else if (AD_Role_ID != 0 && AD_User_ID != 0) {
                sql.append(" AND (AD_Role_ID=? OR AD_User_ID=?)");
            } else if (AD_Role_ID != 0 && AD_User_ID == 0) {
                sql.append(" AND AD_Role_ID=?");
            }
        }
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setInt(1, AD_Client_ID);
            pstmt.setInt(2, AD_Window_ID);
            if (AD_Role_ID == 0 && AD_User_ID != 0) {
                pstmt.setInt(3, AD_User_ID);
            } else if (AD_Role_ID != 0 && AD_User_ID != 0) {
                pstmt.setInt(3, AD_Role_ID);
                pstmt.setInt(4, AD_User_ID);
            } else if (AD_Role_ID != 0 && AD_User_ID == 0) {
                pstmt.setInt(3, AD_Role_ID);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MUserDefWin(ctx, rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql.toString(), e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MUserDefWin[] retValue = new MUserDefWin[list.size()];
        list.toArray(retValue);
        s_log.fine("#" + retValue.length);
        return retValue;
    }

    public static MUserDefWin create(Ctx ctx, int AD_Client_ID, int AD_Window_ID, String prefix, int AD_Role_ID, int AD_User_ID) {
        MWindow win = MWindow.get(ctx, AD_Window_ID);
        if (win.get_ID() != AD_Window_ID) {
            return null;
        }
        MUserDefWin retValue = new MUserDefWin(ctx, 0, null);
        retValue.setClientOrg(AD_Client_ID, 0);
        if (retValue.create(win, prefix, AD_Role_ID, AD_User_ID)) {
            MUserDefWin.createSystemDefault(ctx, AD_Window_ID);
            return retValue;
        }
        return null;
    }

    private static boolean createSystemDefault(Ctx ctx, int AD_Window_ID) {
        if (MUserDefWin.getSystemDefault(ctx, AD_Window_ID) != null) {
            return false;
        }
        MUserDefWin retValue = new MUserDefWin(ctx, 0, null);
        retValue.setClientOrg(0, 0);
        retValue.setAD_Window_ID(AD_Window_ID);
        retValue.setCustomizationName(SYSTEMDEFAULT);
        retValue.setIsSystemDefault(true);
        return retValue.save();
    }

    public static MUserDefWin getSystemDefault(Ctx ctx, int AD_Window_ID) {
        MUserDefWin retValue = null;
        String sql = "SELECT * FROM AD_UserDef_Win WHERE AD_Window_ID=? AND IsSystemDefault='Y'";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Window_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                retValue = new MUserDefWin(ctx, rs, null);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public MUserDefWin(Ctx ctx, int AD_UserDef_Win_ID, String trxName) {
        super(ctx, AD_UserDef_Win_ID, trxName);
        if (AD_UserDef_Win_ID == 0) {
            this.setIsSystemDefault(false);
        }
    }

    public MUserDefWin(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MUserDefTab[] getTabs(boolean reload) {
        if (this.m_tabs != null && !reload) {
            return this.m_tabs;
        }
        String sql = "SELECT * FROM AD_UserDef_Tab WHERE AD_UserDef_Win_ID=?";
        ArrayList<MUserDefTab> list = new ArrayList<MUserDefTab>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getAD_UserDef_Win_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MUserDefTab(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_tabs = new MUserDefTab[list.size()];
        list.toArray(this.m_tabs);
        return this.m_tabs;
    }

    public MUserDefTab getTab(int AD_Tab_ID) {
        MUserDefTab[] tabs = this.getTabs(false);
        for (int i = 0; i < tabs.length; ++i) {
            if (tabs[i].getAD_Tab_ID() != AD_Tab_ID) continue;
            return tabs[i];
        }
        return null;
    }

    private boolean create(MWindow win, String prefix, int AD_Role_ID, int AD_User_ID) {
        if (this.getAD_UserDef_Win_ID() != 0) {
            throw new IllegalStateException("Needs to be new");
        }
        this.setAD_Window_ID(win.getAD_Window_ID());
        this.setAD_Org_ID(0);
        StringBuffer name = new StringBuffer();
        if (prefix != null && prefix.length() > 0) {
            name.append(prefix).append(" ");
        }
        if (AD_Role_ID != 0) {
            name.append(MRole.get(this.getCtx(), AD_Role_ID).getName());
        }
        if (AD_User_ID != 0) {
            name.append(MUser.get(this.getCtx(), AD_User_ID).getName());
        }
        if (name.length() > 0) {
            name.append(": ");
        }
        name.append(win.getName());
        this.setCustomizationName(name.toString());
        if (!this.save()) {
            return false;
        }
        MTab[] tabs = win.getTabs(false, this.get_TrxName());
        for (int i = 0; i < tabs.length; ++i) {
            MUserDefTab tt = new MUserDefTab(this);
            if (!tt.create(tabs[i])) {
                return false;
            }
            this.m_tabs = null;
        }
        return true;
    }

    public void setWindowSize(Dimension size) {
        if (size != null) {
            this.setWinWidth(size.width);
            this.setWinHeight(size.height);
        } else {
            this.set_Value("WinWidth", null);
            this.set_Value("WinHeight", null);
        }
    }

    protected boolean beforeSave(boolean newRecord) {
        return newRecord || !this.isSystemDefault();
    }

    public String toString() {
        return this.getCustomizationName();
    }
}

