/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MUserQueryLine;
import org.compiere.model.X_AD_UserQuery;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MUserQuery
extends X_AD_UserQuery {
    private static CLogger s_log = CLogger.getCLogger(MUserQuery.class);
    private MUserQueryLine[] m_lines = null;

    public static MUserQuery[] get(Ctx ctx, int AD_Tab_ID, int AD_Table_ID) {
        String sql = "SELECT * FROM AD_UserQuery WHERE AD_Client_ID=? AND IsActive='Y' AND (AD_Tab_ID=? OR AD_Table_ID=?) ORDER BY Name";
        int AD_Client_ID = ctx.getAD_Client_ID();
        ArrayList<MUserQuery> list = new ArrayList<MUserQuery>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Client_ID);
            pstmt.setInt(2, AD_Tab_ID);
            pstmt.setInt(3, AD_Table_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MUserQuery(ctx, rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MUserQuery[] retValue = new MUserQuery[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static ArrayList<String> getSavedQueryNames(int AD_Client_ID, int AD_Tab_ID) {
        String sql = "SELECT Name FROM AD_UserQuery WHERE AD_Client_ID=? AND AD_Tab_ID=? AND IsActive='Y' ORDER BY Name";
        ArrayList<String> retValue = new ArrayList<String>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Client_ID);
            pstmt.setInt(2, AD_Tab_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                String name = rs.getString(1);
                retValue.add(name);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public static ArrayList<String> getSavedQueryNamesForUser(int AD_User_ID, int AD_Tab_ID) {
        String sql = "SELECT Name FROM AD_UserQuery WHERE AD_User_ID=? AND AD_Tab_ID=? AND IsActive='Y' ORDER BY Name";
        ArrayList<String> retValue = new ArrayList<String>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_User_ID);
            pstmt.setInt(2, AD_Tab_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                String name = rs.getString(1);
                retValue.add(name);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public static MUserQuery get(Ctx ctx, int AD_Tab_ID, String name) {
        String sql = "SELECT * FROM AD_UserQuery WHERE AD_Client_ID=? AND AD_Tab_ID=? AND UPPER(Name) LIKE ? AND IsActive='Y' ORDER BY Name";
        int AD_Client_ID = ctx.getAD_Client_ID();
        if (name == null) {
            name = "%";
        }
        MUserQuery retValue = null;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Client_ID);
            pstmt.setInt(2, AD_Tab_ID);
            pstmt.setString(3, name.toUpperCase());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MUserQuery(ctx, rs, null);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public static MUserQuery getForUser(Ctx ctx, int AD_Tab_ID, String name) {
        String sql = "SELECT * FROM AD_UserQuery WHERE AD_User_ID=? AND AD_Tab_ID=? AND UPPER(Name) LIKE ? AND IsActive='Y' ORDER BY Name";
        int AD_User_ID = ctx.getAD_User_ID();
        if (name == null) {
            name = "%";
        }
        MUserQuery retValue = null;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_User_ID);
            pstmt.setInt(2, AD_Tab_ID);
            pstmt.setString(3, name.toUpperCase());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MUserQuery(ctx, rs, null);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public MUserQuery(Ctx ctx, int AD_UserQuery_ID, String trxName) {
        super(ctx, AD_UserQuery_ID, trxName);
    }

    public MUserQuery(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MUserQueryLine[] getLines(boolean reload) {
        if (this.m_lines != null && !reload) {
            return this.m_lines;
        }
        ArrayList<MUserQueryLine> list = new ArrayList<MUserQueryLine>();
        String sql = "SELECT * FROM AD_UserQueryLine WHERE AD_UserQuery_ID=? ORDER BY SeqNo";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getAD_UserQuery_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MUserQueryLine(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_lines = new MUserQueryLine[list.size()];
        list.toArray(this.m_lines);
        return this.m_lines;
    }

    public boolean deleteLines() {
        String sql = "DELETE FROM AD_UserQueryLine WHERE AD_UserQuery_ID=?";
        int no = DB.executeUpdate(sql, this.getAD_UserQuery_ID(), null);
        this.log.info("#" + no);
        this.m_lines = null;
        return no >= 0;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public String toStringX() {
        StringBuffer sb = new StringBuffer("MUserQuery[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }
}

