/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.plaf;

import java.awt.AWTKeyStroke;
import java.beans.PropertyChangeEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;

public class CompiereTextAreaUI
extends BasicTextAreaUI {
    private JTextComponent m_editor = null;
    private static KeyStroke s_stroke = KeyStroke.getKeyStroke(9, 2);
    private static Action s_action = new DefaultEditorKit.InsertTabAction();

    public static ComponentUI createUI(JComponent ta) {
        return new CompiereTextAreaUI(ta);
    }

    public CompiereTextAreaUI(JComponent ta) {
        if (ta instanceof JTextComponent) {
            this.m_editor = (JTextComponent)ta;
        }
    }

    protected Keymap createKeymap() {
        Keymap map = super.createKeymap();
        map.addActionForKeyStroke(s_stroke, s_action);
        return map;
    }

    protected void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("editable".equals(name)) {
            this.updateFocusTraversalKeysX();
        } else {
            super.propertyChange(evt);
        }
    }

    void updateFocusTraversalKeysX() {
        if (this.m_editor == null) {
            return;
        }
        EditorKit editorKit = this.getEditorKit(this.m_editor);
        if (editorKit != null && editorKit instanceof DefaultEditorKit) {
            Set<AWTKeyStroke> storedForwardTraversalKeys = this.m_editor.getFocusTraversalKeys(0);
            Set<AWTKeyStroke> storedBackwardTraversalKeys = this.m_editor.getFocusTraversalKeys(1);
            HashSet<AWTKeyStroke> forwardTraversalKeys = new HashSet<AWTKeyStroke>(storedForwardTraversalKeys);
            HashSet<AWTKeyStroke> backwardTraversalKeys = new HashSet<AWTKeyStroke>(storedBackwardTraversalKeys);
            forwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 0));
            forwardTraversalKeys.remove(s_stroke);
            backwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 1));
            LookAndFeel.installProperty(this.m_editor, "focusTraversalKeysForward", forwardTraversalKeys);
            LookAndFeel.installProperty(this.m_editor, "focusTraversalKeysBackward", backwardTraversalKeys);
        }
    }
}

