/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.plaf;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JTextArea;
import org.compiere.plaf.CompierePLAF;
import org.compiere.plaf.FontStyle;
import org.compiere.swing.CButton;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CDialog;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;

public class FontChooser
extends CDialog
implements ActionListener {
    static ResourceBundle s_res = ResourceBundle.getBundle("org.compiere.translate.PlafRes");
    public static FontStyle[] s_list = new FontStyle[]{new FontStyle(s_res.getString("Plain"), 0), new FontStyle(s_res.getString("Italic"), 2), new FontStyle(s_res.getString("Bold"), 1), new FontStyle(s_res.getString("BoldItalic"), 3)};
    private Font m_font = super.getFont();
    private Font m_retFont = null;
    private boolean m_setting = false;
    private CPanel mainPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel selectPanel = new CPanel();
    private CLabel nameLabel = new CLabel();
    private CComboBox fontName = new CComboBox();
    private CLabel sizeLabel = new CLabel();
    private CLabel styleLabel = new CLabel();
    private CComboBox fontStyle = new CComboBox();
    private CComboBox fontSize = new CComboBox();
    private JTextArea fontTest = new JTextArea();
    private JTextArea fontInfo = new JTextArea();
    private GridBagLayout selectLayout = new GridBagLayout();
    private CPanel confirmPanel = new CPanel();
    private CButton bCancel = CompierePLAF.getCancelButton();
    private CButton bOK = CompierePLAF.getOKButton();
    private FlowLayout confirmLayout = new FlowLayout();

    public static Font showDialog(Dialog owner, String title, Font initFont) {
        Font retValue = initFont;
        FontChooser fc = new FontChooser(owner, title, initFont);
        retValue = fc.getFont();
        fc = null;
        return retValue;
    }

    public FontChooser(Dialog owner, String title, Font initFont) {
        super(owner, title, true);
        try {
            this.jbInit();
            this.dynInit();
            this.setFont(initFont);
            CompierePLAF.showCenterScreen(this);
        }
        catch (Exception ex) {
            System.err.println("FontChooser");
            ex.printStackTrace();
        }
    }

    public FontChooser() {
        this(null, s_res.getString("FontChooser"), null);
    }

    private void jbInit() throws Exception {
        this.mainPanel.setLayout(this.mainLayout);
        this.nameLabel.setText(s_res.getString("Name"));
        this.selectPanel.setLayout(this.selectLayout);
        this.sizeLabel.setText(s_res.getString("Size"));
        this.styleLabel.setText(s_res.getString("Style"));
        this.fontTest.setText(s_res.getString("TestString"));
        this.fontTest.setLineWrap(true);
        this.fontTest.setWrapStyleWord(true);
        this.fontTest.setBackground(CompierePLAF.getFieldBackground_Inactive());
        this.fontTest.setBorder(BorderFactory.createLoweredBevelBorder());
        this.fontTest.setPreferredSize(new Dimension(220, 100));
        this.fontInfo.setText(s_res.getString("FontString"));
        this.fontInfo.setLineWrap(true);
        this.fontInfo.setWrapStyleWord(true);
        this.fontInfo.setBackground(CompierePLAF.getFieldBackground_Inactive());
        this.fontInfo.setOpaque(false);
        this.fontInfo.setEditable(false);
        this.confirmPanel.setLayout(this.confirmLayout);
        this.confirmLayout.setAlignment(2);
        this.confirmPanel.setOpaque(false);
        this.selectPanel.setOpaque(false);
        this.getContentPane().add(this.mainPanel);
        this.mainPanel.add((Component)this.selectPanel, "Center");
        this.selectPanel.add((Component)this.nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.selectPanel.add((Component)this.fontName, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.selectPanel.add((Component)this.sizeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.selectPanel.add((Component)this.styleLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.selectPanel.add((Component)this.fontStyle, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.selectPanel.add((Component)this.fontSize, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.selectPanel.add((Component)this.fontTest, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(20, 5, 5, 5), 0, 0));
        this.selectPanel.add((Component)this.fontInfo, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 1, new Insets(10, 5, 10, 5), 0, 0));
        this.mainPanel.add((Component)this.confirmPanel, "South");
        this.confirmPanel.add((Component)this.bCancel, null);
        this.confirmPanel.add((Component)this.bOK, null);
        this.bCancel.addActionListener(this);
        this.bOK.addActionListener(this);
    }

    private void dynInit() {
        int i;
        Object[] names = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        Arrays.sort(names);
        for (i = 0; i < names.length; ++i) {
            this.fontName.addItem(names[i]);
        }
        this.fontName.addActionListener(this);
        for (i = 6; i < 32; ++i) {
            this.fontSize.addItem(String.valueOf(i));
        }
        this.fontSize.addActionListener(this);
        for (i = 0; i < s_list.length; ++i) {
            this.fontStyle.addItem(s_list[i]);
        }
        this.fontStyle.addActionListener(this);
    }

    public void setFont(Font font) {
        if (font == null) {
            return;
        }
        if (this.m_retFont == null) {
            this.m_retFont = font;
        }
        this.fontTest.setFont(font);
        this.fontInfo.setFont(font);
        this.fontInfo.setText(font.toString());
        this.m_setting = true;
        this.fontName.setSelectedItem(font.getName());
        if (!this.fontName.getSelectedItem().equals(font.getName())) {
            System.err.println("FontChooser.setFont" + this.fontName.getSelectedItem().toString() + " <> " + font.getName());
        }
        this.fontSize.setSelectedItem(String.valueOf(font.getSize()));
        if (!this.fontSize.getSelectedItem().equals(String.valueOf(font.getSize()))) {
            System.err.println("FontChooser.setFont" + this.fontSize.getSelectedItem() + " <> " + font.getSize());
        }
        for (int i = 0; i < s_list.length; ++i) {
            if (s_list[i].getID() != font.getStyle()) continue;
            this.fontStyle.setSelectedItem(s_list[i]);
        }
        if (((FontStyle)this.fontStyle.getSelectedItem()).getID() != font.getStyle()) {
            System.err.println("FontChooser.setFont" + ((FontStyle)this.fontStyle.getSelectedItem()).getID() + " <> " + font.getStyle());
        }
        this.m_font = font;
        this.pack();
        this.m_setting = false;
    }

    public Font getFont() {
        return this.m_retFont;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.m_setting) {
            return;
        }
        if (e.getSource() == this.bOK) {
            this.m_retFont = this.m_font;
            this.dispose();
        } else if (e.getSource() == this.bCancel) {
            this.dispose();
        } else if (e.getSource() == this.fontName) {
            String s = this.fontName.getSelectedItem().toString();
            this.m_font = new Font(s, this.m_font.getStyle(), this.m_font.getSize());
        } else if (e.getSource() == this.fontSize) {
            String s = this.fontSize.getSelectedItem().toString();
            this.m_font = new Font(this.m_font.getName(), this.m_font.getStyle(), Integer.parseInt(s));
        } else if (e.getSource() == this.fontStyle) {
            FontStyle fs = (FontStyle)this.fontStyle.getSelectedItem();
            this.m_font = new Font(this.m_font.getName(), fs.getID(), this.m_font.getSize());
        }
        this.setFont(this.m_font);
    }
}

