/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import org.compiere.model.MIssue;
import org.compiere.model.MSystem;
import org.compiere.process.SvrProcess;
import org.compiere.util.CompiereSystemException;

public class IssueReport
extends SvrProcess {
    private int m_AD_Issue_ID = 0;

    protected void prepare() {
        this.m_AD_Issue_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        this.log.info("AD_Issue_ID=" + this.m_AD_Issue_ID);
        if (!MSystem.get(this.getCtx()).isAutoErrorReport()) {
            return "NOT reported - Enable Error Reporting in Window System";
        }
        MIssue issue = new MIssue(this.getCtx(), this.m_AD_Issue_ID, this.get_TrxName());
        if (issue.get_ID() == 0) {
            return "No Issue to report - ID=" + this.m_AD_Issue_ID;
        }
        String error = issue.report();
        if (error != null) {
            throw new CompiereSystemException(error);
        }
        if (issue.save()) {
            return "Issue Reported: " + issue.getRequestDocumentNo();
        }
        throw new CompiereSystemException("Issue Not Saved");
    }
}

