/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import org.compiere.plaf.CompiereColor;
import org.compiere.plaf.CompierePLAF;
import org.compiere.plaf.CompierePanelUI;
import org.compiere.util.Trace;
import sun.swing.UIAction;

public class CTabbedPane
extends JTabbedPane {
    private ArrayList<Character> m_mnemonic = new ArrayList(10);
    private static final String ACTION_SELECT = "CAS";
    private static CTAction s_action = new CTAction("CAS");

    public CTabbedPane() {
        this.init();
    }

    public CTabbedPane(int tabPlacement) {
        super(tabPlacement);
        this.init();
    }

    public CTabbedPane(int tabPlacement, int tabLayoutPolicy) {
        super(tabPlacement, tabLayoutPolicy);
        this.init();
    }

    public CTabbedPane(CompiereColor bg) {
        this.init();
        this.setBackgroundColor(bg);
    }

    private void init() {
        this.setOpaque(false);
        this.setFont(CompierePLAF.getFont_Label());
        this.setForeground(CompierePLAF.getTextColor_Label());
        this.setFocusable(false);
    }

    public void setBackground(Color bg) {
        if (bg.equals(this.getBackground())) {
            return;
        }
        super.setBackground(bg);
        if (!Trace.getCallerClass(1).startsWith("javax")) {
            this.setBackgroundColor(new CompiereColor(bg));
        }
    }

    public void setBackgroundColor() {
        this.setBackgroundColor(null);
    }

    public void setBackgroundColor(CompiereColor bg) {
        if (bg == null) {
            bg = CompierePanelUI.getDefaultBackground();
        }
        this.setOpaque(true);
        this.putClientProperty("CompiereBackground", bg);
        super.setBackground(bg.getFlatColor());
        this.repaint();
    }

    public CompiereColor getBackgroundColor() {
        try {
            return (CompiereColor)this.getClientProperty("CompiereBackground");
        }
        catch (Exception e) {
            System.err.println("ClientProperty: " + e.getMessage());
            return null;
        }
    }

    public void insertTab(String text, Icon icon, Component component, String tip, int index) {
        JPanel p;
        int pos;
        String title = text;
        if (!title.startsWith("<html>") && (pos = title.indexOf(38)) != -1) {
            title = title.substring(0, pos) + title.substring(pos + 1);
        }
        if (tip == null || tip.length() == 0) {
            tip = title;
        }
        super.insertTab(title, icon, component, tip, index);
        if (component instanceof JPanel && (p = (JPanel)component).getClientProperty("CompiereBackground") == null) {
            CompiereColor.setBackground(p);
            p.setOpaque(true);
        }
        if (index == 0) {
            this.getActionMap().put(ACTION_SELECT, s_action);
        }
        if (!this.setMnemonicAt(index, text)) {
            if (index < 9) {
                this.setMnemonicAt(index, 49 + index);
            } else if (index == 9) {
                this.setMnemonicAt(index, 48);
            }
        } else if (index < 9) {
            this.getInputMap(2).put(KeyStroke.getKeyStroke(49 + index, 8), ACTION_SELECT);
        } else if (index == 9) {
            this.getInputMap(2).put(KeyStroke.getKeyStroke(48, 8), ACTION_SELECT);
        }
    }

    public void setTitleAt(int index, String text) {
        int pos;
        String title = text;
        if (!title.startsWith("<html>") && (pos = title.indexOf(38)) != -1) {
            title = title.substring(0, pos) + title.substring(pos + 1);
        }
        super.setTitleAt(index, title);
    }

    public boolean setMnemonicAt(int index, String text) {
        int pos;
        while (this.m_mnemonic.size() < index + 1) {
            this.m_mnemonic.add(Character.valueOf('\u0000'));
        }
        char keyCode = this.m_mnemonic.get(index).charValue();
        if (keyCode != '\u0000') {
            this.getInputMap(2).remove(KeyStroke.getKeyStroke((int)keyCode, 8));
        }
        this.m_mnemonic.set(index, Character.valueOf('\u0000'));
        if (!text.startsWith("<html>") && (pos = text.indexOf(38)) != -1 && text.length() > pos && (keyCode = text.toUpperCase().charAt(pos + 1)) != ' ') {
            this.setMnemonicAt(index, keyCode);
            this.m_mnemonic.set(index, Character.valueOf(keyCode));
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("CTabbedPane [");
        sb.append(super.toString());
        CompiereColor bg = this.getBackgroundColor();
        if (bg != null) {
            sb.append(bg.toString());
        }
        sb.append("]");
        return sb.toString();
    }

    private static class CTAction
    extends UIAction {
        public CTAction(String actionName) {
            super(actionName);
        }

        public void actionPerformed(ActionEvent e) {
            String key = this.getName();
            if (!key.equals(CTabbedPane.ACTION_SELECT) || !(e.getSource() instanceof CTabbedPane)) {
                return;
            }
            CTabbedPane pane = (CTabbedPane)e.getSource();
            String command = e.getActionCommand();
            if (command == null || command.length() != 1) {
                return;
            }
            int index = command.charAt(0) - 49;
            if (index > -1 && index < pane.getTabCount()) {
                pane.setSelectedIndex(index);
            } else {
                System.out.println("Action: " + e);
            }
        }
    }
}

