/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.compiere.swing.CRowHeader;
import org.compiere.swing.MSort;

public class CTable
extends JTable {
    private boolean m_sortEnabled = true;
    protected int p_lastSortIndex = -1;
    protected boolean p_asc = true;
    private final int SLACK = 15;
    private final int MAXSIZE = 250;
    protected int p_keyColumnIndex = -1;
    private CRowHeader m_rowHeader = null;
    MSort m_sortTemp1 = new MSort(0, null);
    MSort m_sortTemp2 = new MSort(1, null);
    private static Logger log = Logger.getLogger(CTable.class.getName());

    public CTable() {
        this(true);
    }

    public CTable(boolean withRowHeader) {
        super(new DefaultTableModel());
        if (withRowHeader) {
            this.m_rowHeader = new CRowHeader(this);
        }
        this.setColumnSelectionAllowed(false);
        this.setSelectionMode(0);
        this.setAutoResizeMode(0);
        this.getTableHeader().addMouseListener(new CTableMouseListener());
        this.setSurrendersFocusOnKeystroke(true);
    }

    protected void configureEnclosingScrollPane() {
        super.configureEnclosingScrollPane();
        if (this.m_rowHeader == null) {
            return;
        }
        Container parent = this.getParent();
        if (parent instanceof JViewport && (parent = parent.getParent()) instanceof JScrollPane) {
            ((JScrollPane)parent).setRowHeaderView(this.m_rowHeader);
            this.m_rowHeader.setTable(this);
        }
    }

    public CRowHeader getRowHeader() {
        return this.m_rowHeader;
    }

    public void setRowHeader(CRowHeader rowHeader) {
        if (this.m_rowHeader != null && this.m_rowHeader.getParent() != null) {
            this.m_rowHeader.getParent().remove(this.m_rowHeader);
        }
        this.m_rowHeader = rowHeader;
        if (rowHeader != null) {
            rowHeader.setTable(this);
            this.configureEnclosingScrollPane();
        }
    }

    public void setKeyColumnIndex(int keyColumnIndex) {
        this.p_keyColumnIndex = keyColumnIndex;
    }

    public int getKeyColumnIndex() {
        return this.p_keyColumnIndex;
    }

    public Object getSelectedKeyColumnValue() {
        int row = this.getSelectedRow();
        if (row != -1 && this.p_keyColumnIndex != -1) {
            return this.getModel().getValueAt(row, this.p_keyColumnIndex);
        }
        return null;
    }

    public Object getSelectedValue() {
        int row = this.getSelectedRow();
        int col = this.getSelectedColumn();
        if (row == -1 || col == -1) {
            return null;
        }
        return this.getValueAt(row, col);
    }

    public void stopEditor(boolean saveValue) {
        ChangeEvent ce = new ChangeEvent(this);
        if (saveValue) {
            this.editingStopped(ce);
        } else {
            this.editingCanceled(ce);
        }
        if (this.getInputContext() != null) {
            this.getInputContext().endComposition();
        }
        this.transferFocus();
    }

    public void autoSize(boolean useColumnIdentifier) {
        TableModel model = this.getModel();
        int size = model.getColumnCount();
        for (int c = 0; c < size; ++c) {
            TableColumn column = this.getColumnModel().getColumn(c);
            if (useColumnIdentifier && (column.getIdentifier() == null || column.getMaxWidth() == 0 || column.getIdentifier().toString().length() == 0)) continue;
            int width = 0;
            TableCellRenderer renderer = column.getHeaderRenderer();
            if (renderer == null) {
                renderer = new DefaultTableCellRenderer();
            }
            Component comp = null;
            if (renderer != null) {
                comp = renderer.getTableCellRendererComponent(this, column.getHeaderValue(), false, false, 0, 0);
            }
            if (comp != null) {
                width = comp.getPreferredSize().width;
                width = Math.max(width, comp.getWidth());
                int maxRow = Math.min(15, this.getRowCount());
                TableCellRenderer cRenderer = null;
                Component cComp = null;
                try {
                    for (int row = 0; row < maxRow; ++row) {
                        cRenderer = this.getCellRenderer(row, c);
                        cComp = cRenderer.getTableCellRendererComponent(this, this.getValueAt(row, c), false, false, row, c);
                        int rowWidth = cComp.getPreferredSize().width;
                        width = Math.max(width, rowWidth);
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, column.getIdentifier().toString(), e);
                }
                width = Math.min(250, width + 15);
            }
            column.setPreferredWidth(width);
        }
    }

    public void setSortEnabled(boolean enable) {
        this.m_sortEnabled = enable;
    }

    public boolean isSortEnabled() {
        return this.m_sortEnabled;
    }

    protected void sort(final int modelColumnIndex) {
        int selCol;
        if (!this.m_sortEnabled) {
            return;
        }
        int rows = this.getRowCount();
        if (rows == 0) {
            return;
        }
        this.p_asc = modelColumnIndex != this.p_lastSortIndex ? true : !this.p_asc;
        this.p_lastSortIndex = modelColumnIndex;
        log.config("#" + modelColumnIndex + " - rows=" + rows + ", asc=" + this.p_asc);
        Object selected = null;
        int selRow = this.getSelectedRow();
        int n = selCol = this.p_keyColumnIndex == -1 ? 0 : this.p_keyColumnIndex;
        if (this.getSelectedRow() >= 0) {
            selected = this.getValueAt(selRow, selCol);
        }
        DefaultTableModel model = (DefaultTableModel)this.getModel();
        Vector<Vector> modelData = model.getDataVector();
        Collections.sort(modelData, new Comparator(){
            {
                CTable.this.m_sortTemp1.setSortAsc(CTable.this.p_asc);
            }

            public int compare(Object o1, Object o2) {
                CTable.this.m_sortTemp1.data = ((Vector)o1).get(modelColumnIndex);
                CTable.this.m_sortTemp2.data = ((Vector)o2).get(modelColumnIndex);
                return CTable.this.m_sortTemp1.compare(CTable.this.m_sortTemp1, CTable.this.m_sortTemp2);
            }
        });
        model.fireTableDataChanged();
        this.clearSelection();
        if (selected != null) {
            for (int r = 0; r < rows; ++r) {
                if (!selected.equals(this.getValueAt(r, selCol))) continue;
                this.setRowSelectionInterval(r, r);
                break;
            }
        }
    }

    public String toString() {
        return new StringBuffer("CTable[").append(this.getModel()).append("]").toString();
    }

    class CTableMouseListener
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            int vc = CTable.this.getColumnModel().getColumnIndexAtX(e.getX());
            int mc = CTable.this.convertColumnIndexToModel(vc);
            CTable.this.sort(mc);
        }
    }
}

