/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.tools;

import java.util.Arrays;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.label;
import org.apache.ecs.xhtml.option;
import org.apache.ecs.xhtml.select;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.textarea;
import org.apache.ecs.xhtml.tr;
import org.compiere.Compiere;
import org.compiere.framework.PO;
import org.compiere.model.MColumn;
import org.compiere.model.MRefList;
import org.compiere.model.MTable;
import org.compiere.model.M_Element;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;

public class GenerateForm {
    private int m_AD_Client_ID = 0;
    private String[] m_ignoreColumns = null;
    private String[] m_hideColumns = null;

    public GenerateForm(int AD_Client_ID, int AD_Table_ID, String[] ignoreColumns, String[] hideColumns) {
        this.m_AD_Client_ID = AD_Client_ID;
        this.m_ignoreColumns = ignoreColumns;
        this.m_hideColumns = hideColumns;
        String s = this.createForm(AD_Table_ID);
        System.out.println(s);
    }

    private String createForm(int AD_Table_ID) {
        MTable table2 = MTable.get(Env.getCtx(), AD_Table_ID);
        MColumn[] columns = table2.getColumns(true);
        form f = new form("/wstore/", "post".concat("application/x-www-form-urlencoded"));
        f.setID(table2.getTableName());
        table t = new table(0);
        for (int i = 0; i < columns.length; ++i) {
            this.createColumn(f, t, columns[i]);
        }
        tr row = new tr();
        row.addElement((Element)new input("reset", "Reset", "Reset"));
        row.addElement((Element)new input("submit", "Submit", "Submit"));
        t.addElement((Element)row);
        f.addElement((Element)t);
        return f.toString();
    }

    private void createColumn(form f, table t, MColumn column) {
        int index;
        String columnName = column.getColumnName();
        int dt = column.getAD_Reference_ID();
        if (this.m_ignoreColumns != null && this.m_ignoreColumns.length > 0 && (index = Arrays.binarySearch(this.m_ignoreColumns, columnName)) > -1) {
            return;
        }
        if (this.m_hideColumns != null && this.m_hideColumns.length > 0 && (index = Arrays.binarySearch(this.m_hideColumns, columnName)) > -1) {
            f.addElement((Element)new input("hidden", columnName, 0));
            return;
        }
        if (columnName.startsWith("Created") || columnName.startsWith("Updated") || columnName.equals("IsActive") || columnName.equals("Processed") || dt == 28) {
            return;
        }
        if (columnName.equals("AD_Client_ID") || columnName.equals("AD_Org_ID")) {
            f.addElement((Element)new input("hidden", columnName, 0));
            return;
        }
        tr row = new tr();
        if (20 == dt) {
            row.addElement((Element)new td("&sbsp;"));
            input i = new input("checkbox", columnName, "").setChecked(true);
            row.addElement((Element)new td((Element)i).setAlign("left").setVAlign("top"));
        } else {
            this.createLabel(row, column);
            this.createField(row, column);
        }
        t.addElement((Element)row);
    }

    private void createLabel(tr row, MColumn column) {
        M_Element element = column.getElement();
        label myLabel = new label(column.getColumnName(), null, Util.maskHTML(element.getName()));
        myLabel.setID(column.getColumnName() + "L");
        if (element.getDescription() != null) {
            myLabel.setTitle(Util.maskHTML(element.getDescription()));
        }
        row.addElement((Element)new td((Element)myLabel).setAlign("right").setVAlign("top"));
    }

    private void createField(tr row, MColumn column) {
        MTable table2;
        String columnName = column.getColumnName();
        int dt = column.getAD_Reference_ID();
        input e = null;
        if (DisplayType.isText((int)dt)) {
            if (column.getFieldLength() > 60) {
                e = new textarea(columnName, 3, 60);
            } else if (column.getFieldLength() > 255) {
                e = new textarea(columnName, 5, 60);
            } else {
                int size = column.getFieldLength();
                if (size > 60) {
                    size = 60;
                }
                e = new input("text", columnName, "").setSize(size);
            }
        } else if (DisplayType.isDate((int)dt)) {
            e = new input("text", columnName, "");
        } else if (DisplayType.isNumeric((int)dt)) {
            e = new input("text", columnName, "");
        } else if (17 == dt) {
            ValueNamePair[] options = MRefList.getList(column.getAD_Reference_Value_ID(), column.isMandatoryUI());
            e = new select(columnName, this.getOptions(options, column.isMandatoryUI()));
        } else if (DisplayType.isLookup((int)dt) && (table2 = column.getFKTable()) != null) {
            String displayColumn = null;
            String[] ids = table2.getIdentifierColumns();
            displayColumn = ids.length > 0 ? ids[0] : columnName;
            String where = "AD_Client_ID IN (0," + this.m_AD_Client_ID + ")";
            PO[] options = table2.getPOs(Env.getCtx(), where, displayColumn, null);
            e = new select(columnName, this.getOptions(options, displayColumn, column.isMandatoryUI()));
        }
        if (e != null) {
            row.addElement((Element)new td((Element)e).setAlign("left").setVAlign("top"));
        }
    }

    private option[] getOptions(ValueNamePair[] in, boolean mandatory) {
        option[] out = null;
        int add = 0;
        if (!mandatory) {
            out = new option[in.length + 1];
            out[0] = new option("", "");
            add = 1;
        } else {
            out = new option[in.length];
        }
        for (int i = 0; i < in.length; ++i) {
            out[i + add] = new option(in[i].getValue()).addElement(in[i].getName());
        }
        return out;
    }

    private option[] getOptions(PO[] in, String displayColumn, boolean mandatory) {
        option[] out = null;
        int add = 0;
        if (!mandatory) {
            out = new option[in.length + 1];
            out[0] = new option("", "");
            add = 1;
        } else {
            out = new option[in.length];
        }
        for (int i = 0; i < in.length; ++i) {
            Object display = in[i].get_Value(displayColumn);
            if (display == null) {
                display = "?";
            }
            Integer id = in[i].get_ID();
            out[i + add] = new option(id.toString()).addElement(display.toString());
        }
        return out;
    }

    public static void main(String[] args) {
        Compiere.startup(true);
        String[] ignoreColumns = new String[]{"AD_User_ID", "C_BPartner_ID", "C_BPartner_Location_ID", "SalesRep_ID", "C_BP_Status_ID", "C_LeadQualification_ID", "LeadRating", "R_Status_ID", "C_Region_ID", "C_City_ID", "C_SalesRegion_ID", "C_Project_ID", "R_Request_ID", "DocumentNo", "C_Lead_ID", "C_Project_ID"};
        String[] hideColumns = new String[]{"R_InterestArea_ID", "R_Source_ID", "C_BPartnerSR_ID", "C_Campaign_ID"};
        int AD_Client_ID = 11;
        new GenerateForm(AD_Client_ID, 923, ignoreColumns, hideColumns);
    }
}

