/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.tools;

import java.io.File;
import java.io.FileWriter;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.Compiere;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;

public class GenerateVO {
    private static CLogger log = CLogger.getCLogger(GenerateVO.class);
    private StringBuffer m_jdbcLoad = new StringBuffer();
    private long m_createdMS = System.currentTimeMillis();

    public GenerateVO(String tableName, String className, String directory, String packageName) {
        try {
            StringBuffer sb = this.createColumns(tableName);
            this.createVOHeader(tableName, className, packageName, sb);
            this.writeToFile(sb, directory + className + ".java");
            sb = this.createFT(tableName, className, packageName);
            this.writeToFile(sb, directory + className + "FT.java");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    private StringBuffer createColumns(String tableName) throws Exception {
        String baseTable = tableName;
        if (tableName.endsWith("_v")) {
            baseTable = baseTable.substring(0, baseTable.length() - 2);
        }
        DatabaseMetaData md = DB.getConnectionRO().getMetaData();
        String catalog = DB.getDatabase().getCatalog();
        String schema = DB.getDatabase().getSchema();
        if (DB.isOracle()) {
            tableName = tableName.toUpperCase();
        }
        int noColumns = 0;
        StringBuffer sb = new StringBuffer();
        ResultSet rs = md.getColumns(catalog, schema, tableName, null);
        while (rs.next()) {
            ++noColumns;
            String columnName = rs.getString("COLUMN_NAME");
            int dataType = rs.getInt("DATA_TYPE");
            this.createColumn(baseTable, columnName, dataType, sb);
        }
        rs.close();
        rs = null;
        return sb;
    }

    private void createColumn(String baseTable, String columnName, int dataType, StringBuffer sb) {
        ResultSet rs;
        String name = columnName;
        int AD_Reference_ID = 0;
        int AD_Reference_Value_ID = 0;
        String sql = "SELECT e.ColumnName, e.Name, c.AD_Reference_ID, c.AD_Reference_Value_ID FROM AD_Element e  INNER JOIN AD_Column c ON (e.AD_Element_ID=c.AD_Element_ID)WHERE (UPPER(e.ColumnName)=?)";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setString(1, columnName.toUpperCase());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                columnName = rs.getString(1);
                name = rs.getString(2);
                AD_Reference_ID = rs.getInt(3);
                AD_Reference_Value_ID = rs.getInt(4);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
        if (AD_Reference_ID == 0) {
            sql = "SELECT ColumnName, Name, AD_Reference_ID, AD_Reference_Value_ID FROM AD_Element WHERE (UPPER(ColumnName)=?)";
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setString(1, columnName.toUpperCase());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    columnName = rs.getString(1);
                    name = rs.getString(2);
                    AD_Reference_ID = rs.getInt(3);
                    AD_Reference_Value_ID = rs.getInt(4);
                } else {
                    log.warning("Not Found: " + columnName);
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, sql, e);
            }
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (columnName.equals(columnName.toUpperCase())) {
            log.warning("Did not Convert " + columnName);
        }
        String dataTypeString = null;
        String jdbcMethod = null;
        String getMethod = "get";
        String methodColumn = columnName;
        String nullValue = "null";
        String conversionGet = "";
        String conversionSet = null;
        if (AD_Reference_ID == 20 || AD_Reference_ID == 17 && AD_Reference_Value_ID == 319) {
            dataTypeString = "boolean";
            jdbcMethod = "\"Y\".equals(rs.getString(index))";
            getMethod = "is";
            if (columnName.startsWith("Is")) {
                methodColumn = columnName.substring(2);
            }
            nullValue = "false";
            conversionGet = "boolean retValue = \"true\".equals(value) || \"Y\".equals(value);";
            conversionSet = "PO.convertToBoolean";
        } else if (DisplayType.isText((int)AD_Reference_ID) || AD_Reference_ID == 17 || AD_Reference_ID == 0 && (dataType == 1 || dataType == 2005 || dataType == 12 || dataType == 1111)) {
            dataTypeString = "String";
            nullValue = "\"\"";
            conversionGet = "String retValue = value;if (value == null) retValue = \"\";";
        } else if (DisplayType.isID((int)AD_Reference_ID) || AD_Reference_ID == 11 || dataType == 4 || columnName.endsWith("_ID")) {
            dataTypeString = "int";
            jdbcMethod = "rs.getInt(index)";
            nullValue = "0";
            conversionGet = "int retValue = 0;if (value != null) retValue = Integer.parseInt(value);";
            conversionSet = "PO.convertToInt";
        } else if (DisplayType.isNumeric((int)AD_Reference_ID) || dataType == 2 || dataType == 3) {
            dataTypeString = "java.math.BigDecimal";
            jdbcMethod = "rs.getBigDecimal(index)";
            conversionGet = "java.math.BigDecimal retValue = null;if (value == null) retValue = new java.math.BigDecimal(0);else\n\tretValue = new java.math.BigDecimal(value);";
            conversionSet = "PO.convertToBigDecimal";
        } else if (DisplayType.isDate((int)AD_Reference_ID)) {
            dataTypeString = "java.sql.Timestamp";
            jdbcMethod = "rs.getTimestamp(index)";
            conversionGet = "java.sql.Timestamp retValue = null; if (value != null) retValue = java.sql.Timestamp.valueOf(value);";
            conversionSet = "PO.convertToTimestamp";
        } else {
            if (AD_Reference_ID == 28) {
                log.fine("Ignored Button: " + baseTable + "." + columnName);
                return;
            }
            if (DisplayType.isLOB((int)AD_Reference_ID)) {
                log.fine("Ignored LOB: " + baseTable + "." + columnName);
                return;
            }
            if (AD_Reference_ID == 0) {
                log.warning("Ignored (Type=" + dataType + "): " + baseTable + "." + columnName);
                return;
            }
            log.warning("Ignored (" + AD_Reference_ID + "): " + baseTable + "." + columnName + " - " + nullValue);
            return;
        }
        if (jdbcMethod == null) {
            jdbcMethod = "rs.get" + dataTypeString + "(index)";
        }
        sb.append("/** Get: ").append(name).append(" */\n").append("public ").append(dataTypeString).append(" ").append(getMethod).append(methodColumn).append("(){").append("String value = (String)get(\"").append(columnName).append("\");").append(conversionGet).append("\treturn retValue;}");
        sb.append("/** Set: ").append(name).append(" */\n").append("protected void set").append(columnName).append("(").append(dataTypeString).append(" p_").append(columnName).append("){\t").append("put(\"").append(columnName).append("\", p_").append(columnName).append(");}");
        if (!dataTypeString.equals("String") && conversionSet != null) {
            sb.append("/** Set String: ").append(name).append(" */\n").append("protected void set").append(columnName).append("(String p_").append(columnName).append("){\t");
            sb.append("set").append(columnName).append("(").append(conversionSet).append("(p_").append(columnName).append("));");
            sb.append("}");
        }
        if (this.m_jdbcLoad.length() == 0) {
            this.m_jdbcLoad.append("\n\tif (colName.equalsIgnoreCase(\"");
        } else {
            this.m_jdbcLoad.append("\telse if (colName.equalsIgnoreCase(\"");
        }
        this.m_jdbcLoad.append(columnName).append("\"))\n\t\tvo.set").append(columnName).append("(").append(jdbcMethod).append(");");
    }

    private String createVOHeader(String tableName, String className, String packageName, StringBuffer sb) {
        long serialVersionUID = 38026282125316789L + (long)tableName.hashCode();
        StringBuffer start = new StringBuffer().append("/******************************************************************************\r\n * Product: Compiere ERP & CRM Smart Business Solution                        *\r\n * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *\r\n * This program is free software, you can redistribute it and/or modify it    *\r\n * under the terms version 2 of the GNU General Public License as published   *\r\n * by the Free Software Foundation. This program is distributed in the hope   *\r\n * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *\r\n * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *\r\n * See the GNU General Public License for more details.                       *\r\n * You should have received a copy of the GNU General Public License along    *\r\n * with this program, if not, write to the Free Software Foundation, Inc.,    *\r\n * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *\r\n * For the text or an alternative of this public license, you may reach us    *\r\n * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *\r\n * or via info@compiere.org or http://www.compiere.org/license.html           *\r\n *****************************************************************************/\r\n").append("package " + packageName + ";\n" + "/** Generated VO - DO NOT CHANGE */\n");
        start.append("import org.compiere.framework.*;\n/** Generated VO for ").append(tableName).append("\n *  @author Jorg Janke (generated) \n *  @version ").append("Release 3.0.0").append(" - $Id: GenerateVO.java,v 1.1 2008/07/29 16:04:37 jrmt Exp $").append(" */\npublic class ").append(className).append(" extends VO implements java.io.Serializable{/** Standard Constructor\n*/\npublic ").append(className).append("(){super();}/** Clone Constructor\n*/\npublic ").append(className).append("(VO vo){super(vo);}/** Serial Version No */\nstatic final long serialVersionUID = " + serialVersionUID + "L;" + "/** Created Timestamp */\n" + "public static final long createdMS = " + this.m_createdMS + "L;" + "/** Info\n@return info\n*/\n" + "public String toString()" + "{" + "StringBuffer sb = new StringBuffer (\"").append(className).append("[#\").append(size()).append(\"]\");return sb.toString();}");
        StringBuffer end = new StringBuffer("}");
        sb.insert(0, start);
        sb.append(end);
        return className;
    }

    private StringBuffer createFT(String tableName, String className, String packageName) {
        StringBuffer sb = new StringBuffer().append("/******************************************************************************\r\n * Product: Compiere ERP & CRM Smart Business Solution                        *\r\n * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *\r\n * This program is free software, you can redistribute it and/or modify it    *\r\n * under the terms version 2 of the GNU General Public License as published   *\r\n * by the Free Software Foundation. This program is distributed in the hope   *\r\n * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *\r\n * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *\r\n * See the GNU General Public License for more details.                       *\r\n * You should have received a copy of the GNU General Public License along    *\r\n * with this program, if not, write to the Free Software Foundation, Inc.,    *\r\n * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *\r\n * For the text or an alternative of this public license, you may reach us    *\r\n * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *\r\n * or via info@compiere.org or http://www.compiere.org/license.html           *\r\n *****************************************************************************/\r\n").append("package ").append(packageName).append(";\n").append("/** Generated Factory Template - DO NOT CHANGE */\n").append("import java.sql.*;").append("import java.util.logging.*;").append("import org.compiere.util.*;").append("/** Generated FT for ").append(tableName).append("\n *  @author Jorg Janke (generated) \n *  @version ").append("Release 3.0.0").append(" - $Id: GenerateVO.java,v 1.1 2008/07/29 16:04:37 jrmt Exp $").append(" */\n").append("public class ").append(className).append("FT extends VOFactory<").append(className).append(">{/** Standard Constructor\n*/\npublic ").append(className).append("FT (){}/** Info\n@return info\n*/\npublic String toString(){StringBuffer sb = new StringBuffer (\"").append(className).append("FT[\").append(\"]\");return sb.toString();}");
        this.createFTLoad(className, sb);
        sb.append("}");
        return sb;
    }

    private void createFTLoad(String className, StringBuffer sb) {
        sb.append("/** Load from ResultSet **/\n").append("protected ").append(className).append(" load (ResultSet rs){").append(className).append(" vo = new ").append(className).append("();").append("String colName = null;").append("try{ResultSetMetaData rsmd = rs.getMetaData();").append("for (int index = 1; index <= rsmd.getColumnCount(); index++){").append("colName = rsmd.getColumnName(index);").append(this.m_jdbcLoad).append("}}catch (Exception e){log.log(Level.SEVERE, colName, e);}").append("return vo;}");
    }

    private void writeToFile(StringBuffer sb, String fileName) {
        try {
            File out = new File(fileName);
            FileWriter fw = new FileWriter(out);
            for (int i = 0; i < sb.length(); ++i) {
                char c = sb.charAt(i);
                if (c == ';' || c == '}') {
                    fw.write(c);
                    if (sb.substring(i + 1).startsWith("//")) {
                        fw.write(9);
                        continue;
                    }
                    fw.write(Env.NL);
                    continue;
                }
                if (c == '{') {
                    fw.write(Env.NL);
                    fw.write(c);
                    fw.write(Env.NL);
                    continue;
                }
                fw.write(c);
            }
            fw.flush();
            fw.close();
            float size = out.length();
            log.info(out.getAbsolutePath() + " - " + (size /= 1024.0f) + " kB");
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, fileName, ex);
        }
    }

    public static void main(String[] args) {
        Compiere.startup(true);
        String directory = "C:\\Compiere\\core\\trunk\\ad\\src\\org\\compiere\\controller\\";
        String packageName = "org.compiere.controller";
        new GenerateVO("AD_Window_v", "UIWindowVO", directory, packageName);
        new GenerateVO("AD_Tab_v", "UITabVO", directory, packageName);
        new GenerateVO("AD_Field_v", "UIFieldVO", directory, packageName);
    }
}

