/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.rmi.RemoteException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.logging.Level;
import javax.sql.RowSet;
import org.compiere.db.CConnection;
import org.compiere.db.CompiereDatabase;
import org.compiere.interfaces.Server;
import org.compiere.util.CCachedRowSet;
import org.compiere.util.CStatement;
import org.compiere.util.CStatementVO;
import org.compiere.util.DB;
import org.compiere.util.DBException;
import org.compiere.util.NullParameter;
import org.compiere.util.Trx;

public class CPreparedStatement
extends CStatement
implements PreparedStatement {
    private Connection m_connRO = null;

    public CPreparedStatement(int resultSetType, int resultSetConcurrency, String sql0, String trxName) {
        if (sql0 == null || sql0.length() == 0) {
            throw new IllegalArgumentException("sql required");
        }
        this.log.finest("TrxName=" + trxName + ",SQL=" + sql0 + ", resultSetConcurrency = " + resultSetConcurrency);
        String sql1 = DB.getDatabase().convertStatement(sql0);
        this.p_vo = new CStatementVO(resultSetType, resultSetConcurrency, sql1);
        if (!DB.isRemoteObjects()) {
            Connection conn = null;
            try {
                Trx trx;
                Trx trx2 = trx = trxName == null ? null : Trx.get(trxName, true);
                if (trx != null) {
                    conn = trx.getConnection();
                } else if (resultSetConcurrency == 1008) {
                    conn = DB.getConnectionRW();
                } else {
                    conn = DB.getConnectionRO();
                    if (DB.isDB2()) {
                        this.m_connRO = conn;
                    }
                }
                if (conn == null) {
                    throw new DBException("No Connection");
                }
                this.p_stmt = conn.prepareStatement(this.p_vo.getSql(), resultSetType, resultSetConcurrency);
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, this.p_vo.getSql(), e);
            }
        }
    }

    public CPreparedStatement(CStatementVO vo) {
        super(vo);
    }

    public void close() throws SQLException {
        if (this.m_connRO != null && DB.isDB2()) {
            try {
                this.m_connRO.commit();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_connRO = null;
        super.close();
    }

    public ResultSet executeQuery() throws SQLException {
        if (this.p_stmt != null) {
            ResultSet rs = ((PreparedStatement)this.p_stmt).executeQuery();
            if (!DB.isOracle()) {
                this.p_stmt.getConnection().commit();
            }
            return rs;
        }
        this.log.finest("server => " + this.p_vo + ", Remote=" + DB.isRemoteObjects());
        try {
            boolean remote;
            boolean bl = remote = DB.isRemoteObjects() && CConnection.get().isAppsServerOK(false);
            if (remote && this.p_remoteErrors > 1) {
                remote = CConnection.get().isAppsServerOK(true);
            }
            if (remote) {
                Server server = CConnection.get().getServer();
                if (server != null) {
                    RowSet rs = server.pstmt_getRowSet(this.p_vo);
                    this.p_vo.clearParameters();
                    if (rs == null) {
                        this.log.warning("ResultSet is null - " + this.p_vo);
                    } else {
                        this.p_remoteErrors = 0;
                    }
                    return rs;
                }
                this.log.log(Level.SEVERE, "AppsServer not found");
                ++this.p_remoteErrors;
            }
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, "AppsServer error", ex);
            ++this.p_remoteErrors;
        }
        this.log.warning("Execute locally");
        PreparedStatement pstmt = this.local_getPreparedStatement(false, null);
        if (pstmt == null) {
            this.log.log(Level.SEVERE, " Error: could not get a valid preparedStatement in local.");
            return null;
        }
        this.p_vo.clearParameters();
        ResultSet rs = pstmt.executeQuery();
        return rs;
    }

    public ResultSet executeQuery(String sql0) throws SQLException {
        this.p_vo.setSql(DB.getDatabase().convertStatement(sql0));
        if (this.p_stmt != null) {
            return this.p_stmt.executeQuery(this.p_vo.getSql());
        }
        return this.executeQuery();
    }

    public int executeUpdate() throws SQLException {
        if (this.p_stmt != null) {
            return ((PreparedStatement)this.p_stmt).executeUpdate();
        }
        this.log.finest("server => " + this.p_vo + ", Remote=" + DB.isRemoteObjects());
        try {
            if (DB.isRemoteObjects() && CConnection.get().isAppsServerOK(false)) {
                Server server = CConnection.get().getServer();
                if (server != null) {
                    int result = server.stmt_executeUpdate(this.p_vo);
                    this.p_vo.clearParameters();
                    return result;
                }
                this.log.log(Level.SEVERE, "AppsServer not found");
            }
        }
        catch (RemoteException ex) {
            this.log.log(Level.SEVERE, "AppsServer error", ex);
        }
        this.log.warning("execute locally");
        PreparedStatement pstmt = this.local_getPreparedStatement(false, null);
        this.p_vo.clearParameters();
        return pstmt.executeUpdate();
    }

    public int executeUpdate(String sql0) throws SQLException {
        this.p_vo.setSql(DB.getDatabase().convertStatement(sql0));
        if (this.p_stmt != null) {
            return this.p_stmt.executeUpdate(this.p_vo.getSql());
        }
        return this.executeUpdate();
    }

    public boolean execute() throws SQLException {
        if (this.p_stmt != null) {
            return ((PreparedStatement)this.p_stmt).execute();
        }
        throw new UnsupportedOperationException("Method execute() not yet implemented.");
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.p_stmt != null) {
            return ((PreparedStatement)this.p_stmt).getMetaData();
        }
        throw new UnsupportedOperationException("Method getMetaData() not yet implemented.");
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        if (this.p_stmt != null) {
            return ((PreparedStatement)this.p_stmt).getParameterMetaData();
        }
        throw new UnsupportedOperationException("Method getParameterMetaData() not yet implemented.");
    }

    public void addBatch() throws SQLException {
        if (this.p_stmt == null) {
            throw new UnsupportedOperationException("Method addBatch() not yet implemented.");
        }
        ((PreparedStatement)this.p_stmt).addBatch();
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        if (this.p_stmt != null) {
            ((PreparedStatement)this.p_stmt).setNull(parameterIndex, sqlType);
        } else {
            this.p_vo.setParameter(parameterIndex, new NullParameter(sqlType));
        }
    }

    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        if (this.p_stmt != null) {
            ((PreparedStatement)this.p_stmt).setNull(parameterIndex, sqlType);
        } else {
            this.p_vo.setParameter(parameterIndex, new NullParameter(sqlType));
        }
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        if (this.p_stmt != null) {
            ((PreparedStatement)this.p_stmt).setBoolean(parameterIndex, x);
        } else {
            this.p_vo.setParameter(parameterIndex, new Boolean(x));
        }
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        if (this.p_stmt != null) {
            ((PreparedStatement)this.p_stmt).setByte(parameterIndex, x);
        } else {
            this.p_vo.setParameter(parameterIndex, new Byte(x));
        }
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        if (this.p_stmt != null) {
            ((PreparedStatement)this.p_stmt).setShort(parameterIndex, x);
        } else {
            this.p_vo.setParameter(parameterIndex, new Short(x));
        }
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        if (this.p_stmt != null) {
            ((PreparedStatement)this.p_stmt).setInt(parameterIndex, x);
        } else {
            this.p_vo.setParameter(parameterIndex, new Integer(x));
        }
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        if (this.p_stmt != null) {
            ((PreparedStatement)this.p_stmt).setLong(parameterIndex, x);
        } else {
            this.p_vo.setParameter(parameterIndex, new Long(x));
        }
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        if (this.p_stmt != null) {
            ((PreparedStatement)this.p_stmt).setFloat(parameterIndex, x);
        } else {
            this.p_vo.setParameter(parameterIndex, new Float(x));
        }
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        if (this.p_stmt != null) {
            ((PreparedStatement)this.p_stmt).setDouble(parameterIndex, x);
        } else {
            this.p_vo.setParameter(parameterIndex, new Double(x));
        }
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        if (this.p_stmt != null) {
            ((PreparedStatement)this.p_stmt).setBigDecimal(parameterIndex, x);
        } else {
            this.p_vo.setParameter(parameterIndex, x);
        }
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        if (this.p_stmt != null) {
            ((PreparedStatement)this.p_stmt).setString(parameterIndex, x);
        } else {
            this.p_vo.setParameter(parameterIndex, x);
        }
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        if (this.p_stmt != null) {
            ((PreparedStatement)this.p_stmt).setBytes(parameterIndex, x);
        } else {
            this.p_vo.setParameter(parameterIndex, x);
        }
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        if (this.p_stmt != null) {
            ((PreparedStatement)this.p_stmt).setDate(parameterIndex, x);
        } else {
            this.p_vo.setParameter(parameterIndex, x);
        }
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        if (this.p_stmt != null) {
            ((PreparedStatement)this.p_stmt).setTime(parameterIndex, x);
        } else {
            this.p_vo.setParameter(parameterIndex, x);
        }
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        if (this.p_stmt != null) {
            ((PreparedStatement)this.p_stmt).setTimestamp(parameterIndex, x);
        } else {
            this.p_vo.setParameter(parameterIndex, x);
        }
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (this.p_stmt == null) {
            throw new UnsupportedOperationException("Method setAsciiStream() not yet implemented.");
        }
        ((PreparedStatement)this.p_stmt).setAsciiStream(parameterIndex, x, length);
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("Method setUnicodeStream() not yet implemented.");
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (this.p_stmt == null) {
            throw new UnsupportedOperationException("Method setBinaryStream() not yet implemented.");
        }
        ((PreparedStatement)this.p_stmt).setBinaryStream(parameterIndex, x, length);
    }

    public void clearParameters() throws SQLException {
        if (this.p_stmt != null) {
            ((PreparedStatement)this.p_stmt).clearParameters();
        } else {
            this.p_vo.clearParameters();
        }
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        if (this.p_stmt == null) {
            throw new UnsupportedOperationException("Method setObject() not yet implemented.");
        }
        ((PreparedStatement)this.p_stmt).setObject(parameterIndex, x, targetSqlType, scale);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        if (this.p_stmt == null) {
            throw new UnsupportedOperationException("Method setObject() not yet implemented.");
        }
        ((PreparedStatement)this.p_stmt).setObject(parameterIndex, x);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (this.p_stmt != null) {
            ((PreparedStatement)this.p_stmt).setObject(parameterIndex, x);
        } else {
            this.p_vo.setParameter(parameterIndex, x);
        }
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        if (this.p_stmt == null) {
            throw new UnsupportedOperationException("Method setCharacterStream() not yet implemented.");
        }
        ((PreparedStatement)this.p_stmt).setCharacterStream(parameterIndex, reader, length);
    }

    public void setRef(int parameterIndex, Ref x) throws SQLException {
        if (this.p_stmt != null) {
            ((PreparedStatement)this.p_stmt).setRef(parameterIndex, x);
        } else {
            this.p_vo.setParameter(parameterIndex, x);
        }
    }

    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        if (this.p_stmt != null) {
            if (DB.isPostgreSQL()) {
                ((PreparedStatement)this.p_stmt).setBytes(parameterIndex, x.getBytes(1L, (int)x.length()));
            } else {
                ((PreparedStatement)this.p_stmt).setBlob(parameterIndex, x);
            }
        } else {
            this.p_vo.setParameter(parameterIndex, x);
        }
    }

    public void setClob(int parameterIndex, Clob x) throws SQLException {
        if (this.p_stmt != null) {
            ((PreparedStatement)this.p_stmt).setClob(parameterIndex, x);
        } else {
            this.p_vo.setParameter(parameterIndex, x);
        }
    }

    public void setArray(int parameterIndex, Array x) throws SQLException {
        if (this.p_stmt != null) {
            ((PreparedStatement)this.p_stmt).setArray(parameterIndex, x);
        } else {
            this.p_vo.setParameter(parameterIndex, x);
        }
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        if (this.p_stmt == null) {
            throw new UnsupportedOperationException("Method setDate() not yet implemented.");
        }
        ((PreparedStatement)this.p_stmt).setDate(parameterIndex, x, cal);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        if (this.p_stmt == null) {
            throw new UnsupportedOperationException("Method setTime() not yet implemented.");
        }
        ((PreparedStatement)this.p_stmt).setTime(parameterIndex, x, cal);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        if (this.p_stmt == null) {
            throw new UnsupportedOperationException("Method setTimestamp() not yet implemented.");
        }
        ((PreparedStatement)this.p_stmt).setTimestamp(parameterIndex, x, cal);
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        if (this.p_stmt != null) {
            ((PreparedStatement)this.p_stmt).setObject(parameterIndex, x);
        } else {
            this.p_vo.setParameter(parameterIndex, x);
        }
    }

    public String toString() {
        if (this.p_stmt != null) {
            return "CPreparedStatement[Local=" + this.p_stmt + "]";
        }
        return "CPreparedStatement[" + this.p_vo + "]";
    }

    private PreparedStatement local_getPreparedStatement(boolean dedicatedConnection, String trxName) {
        Trx trx;
        this.log.finest(this.p_vo.getSql());
        Connection conn = null;
        Trx trx2 = trx = trxName == null ? null : Trx.get(trxName, true);
        conn = trx != null ? trx.getConnection() : (dedicatedConnection ? DB.createConnection(false, 2) : this.local_getConnection(trxName));
        if (conn == null) {
            throw new IllegalStateException("Local - No Connection");
        }
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(this.p_vo.getSql(), this.p_vo.getResultSetType(), this.p_vo.getResultSetConcurrency());
            ArrayList<?> parameters = this.p_vo.getParameters();
            for (int i = 0; i < parameters.size(); ++i) {
                Object o = parameters.get(i);
                if (o == null) {
                    throw new IllegalArgumentException("Local - Null Parameter #" + i);
                }
                if (o instanceof NullParameter) {
                    int type = ((NullParameter)o).getType();
                    pstmt.setNull(i + 1, type);
                    this.log.finest("#" + (i + 1) + " - Null");
                    continue;
                }
                if (o instanceof Integer) {
                    pstmt.setInt(i + 1, (Integer)o);
                    this.log.finest("#" + (i + 1) + " - int=" + o);
                    continue;
                }
                if (o instanceof String) {
                    pstmt.setString(i + 1, (String)o);
                    this.log.finest("#" + (i + 1) + " - String=" + o);
                    continue;
                }
                if (o instanceof Timestamp) {
                    pstmt.setTimestamp(i + 1, (Timestamp)o);
                    this.log.finest("#" + (i + 1) + " - Timestamp=" + o);
                    continue;
                }
                if (o instanceof BigDecimal) {
                    pstmt.setBigDecimal(i + 1, (BigDecimal)o);
                    this.log.finest("#" + (i + 1) + " - BigDecimal=" + o);
                    continue;
                }
                throw new UnsupportedOperationException("Unknown Parameter Class=" + o.getClass());
            }
        }
        catch (SQLException ex) {
            this.log.log(Level.SEVERE, "local", ex);
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (SQLException ex1) {
                // empty catch block
            }
        }
        return pstmt;
    }

    public RowSet local_getRowSet() {
        this.log.finest("local");
        Connection conn = DB.createConnection(false, 2);
        PreparedStatement pstmt = null;
        RowSet rowSet = null;
        try {
            pstmt = conn.prepareStatement(DB.getDatabase().convertStatement(this.p_vo.getSql()), 1004, 1007);
            ArrayList<?> parameters = this.p_vo.getParameters();
            for (int i = 0; i < parameters.size(); ++i) {
                Object o = parameters.get(i);
                if (o == null) {
                    throw new IllegalArgumentException("Null Parameter #" + i);
                }
                if (o instanceof NullParameter) {
                    int type = ((NullParameter)o).getType();
                    pstmt.setNull(i + 1, type);
                    this.log.finest("#" + (i + 1) + " - Null");
                    continue;
                }
                if (o instanceof Integer) {
                    pstmt.setInt(i + 1, (Integer)o);
                    this.log.finest("#" + (i + 1) + " - int=" + o);
                    continue;
                }
                if (o instanceof String) {
                    pstmt.setString(i + 1, (String)o);
                    this.log.finest("#" + (i + 1) + " - String=" + o);
                    continue;
                }
                if (o instanceof Timestamp) {
                    pstmt.setTimestamp(i + 1, (Timestamp)o);
                    this.log.finest("#" + (i + 1) + " - Timestamp=" + o);
                    continue;
                }
                if (o instanceof BigDecimal) {
                    pstmt.setBigDecimal(i + 1, (BigDecimal)o);
                    this.log.finest("#" + (i + 1) + " - BigDecimal=" + o);
                    continue;
                }
                throw new UnsupportedOperationException("Unknown Parameter Class=" + o.getClass());
            }
            ResultSet rs = pstmt.executeQuery();
            rowSet = CCachedRowSet.getRowSet(rs);
            pstmt.close();
            pstmt = null;
            if (!DB.isDB2()) {
                conn.close();
            }
            conn = null;
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, this.p_vo.toString(), ex);
            throw new RuntimeException(ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
            if (!DB.isDB2() && conn != null) {
                conn.close();
            }
            conn = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "close", e);
        }
        return rowSet;
    }

    public RowSet remote_getRowSet() {
        this.log.finest("remote");
        Connection conn = this.local_getConnection(null);
        PreparedStatement pstmt = null;
        RowSet rowSet = null;
        try {
            pstmt = conn.prepareStatement(this.p_vo.getSql(), 1004, 1007);
            ArrayList<?> parameters = this.p_vo.getParameters();
            for (int i = 0; i < parameters.size(); ++i) {
                Object o = parameters.get(i);
                if (o == null) {
                    throw new IllegalArgumentException("Null Parameter #" + i);
                }
                if (o instanceof NullParameter) {
                    int type = ((NullParameter)o).getType();
                    pstmt.setNull(i + 1, type);
                    this.log.finest("#" + (i + 1) + " - Null");
                    continue;
                }
                if (o instanceof Integer) {
                    pstmt.setInt(i + 1, (Integer)o);
                    this.log.finest("#" + (i + 1) + " - int=" + o);
                    continue;
                }
                if (o instanceof String) {
                    pstmt.setString(i + 1, (String)o);
                    this.log.finest("#" + (i + 1) + " - String=" + o);
                    continue;
                }
                if (o instanceof Timestamp) {
                    pstmt.setTimestamp(i + 1, (Timestamp)o);
                    this.log.finest("#" + (i + 1) + " - Timestamp=" + o);
                    continue;
                }
                if (o instanceof BigDecimal) {
                    pstmt.setBigDecimal(i + 1, (BigDecimal)o);
                    this.log.finest("#" + (i + 1) + " - BigDecimal=" + o);
                    continue;
                }
                throw new UnsupportedOperationException("Unknown Parameter Class=" + o.getClass());
            }
            ResultSet rs = pstmt.executeQuery();
            rowSet = CCachedRowSet.getRowSet(rs);
            pstmt.close();
            pstmt = null;
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, this.p_vo.toString(), ex);
            throw new RuntimeException(ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "close pstmt", e);
        }
        return rowSet;
    }

    public int remote_executeUpdate() {
        this.log.finest("Update");
        try {
            CompiereDatabase db = CConnection.get().getDatabase();
            if (db == null) {
                throw new NullPointerException("Remote - No Database");
            }
            PreparedStatement pstmt = this.local_getPreparedStatement(false, null);
            int result = pstmt.executeUpdate();
            pstmt.close();
            return result;
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, this.p_vo.toString(), ex);
            throw new RuntimeException(ex);
        }
    }

    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
    }

    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
    }

    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
    }

    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    public void setNString(int parameterIndex, String value) throws SQLException {
    }
}

