/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.sql.RowSet;
import org.compiere.db.CConnection;
import org.compiere.db.CompiereDatabase;
import org.compiere.interfaces.Server;
import org.compiere.util.CCachedRowSet;
import org.compiere.util.CLogger;
import org.compiere.util.CStatementVO;
import org.compiere.util.DB;
import org.compiere.util.DBException;
import org.compiere.util.NullParameter;
import org.compiere.util.Trx;

public class CStatement
implements Statement {
    protected transient CLogger log = CLogger.getCLogger(this.getClass());
    protected transient Statement p_stmt = null;
    protected CStatementVO p_vo = null;
    protected int p_remoteErrors = 0;

    public CStatement(int resultSetType, int resultSetConcurrency, String trxName) {
        this.p_vo = new CStatementVO(resultSetType, resultSetConcurrency);
        if (!DB.isRemoteObjects()) {
            try {
                Trx trx;
                Connection conn = null;
                Trx trx2 = trx = trxName == null ? null : Trx.get(trxName, true);
                conn = trx != null ? trx.getConnection() : (resultSetConcurrency == 1008 ? DB.getConnectionRW() : DB.getConnectionRO());
                if (conn == null) {
                    throw new DBException("No Connection");
                }
                this.p_stmt = conn.createStatement(resultSetType, resultSetConcurrency);
                return;
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, "CStatement", e);
            }
        }
    }

    protected CStatement() {
    }

    public CStatement(CStatementVO vo) {
        this.p_vo = vo;
    }

    public ResultSet executeQuery(String sql0) throws SQLException {
        this.p_vo.setSql(DB.getDatabase().convertStatement(sql0));
        if (this.p_stmt != null) {
            return this.p_stmt.executeQuery(this.p_vo.getSql());
        }
        this.log.finest("server => " + this.p_vo + ", Remote=" + DB.isRemoteObjects());
        try {
            boolean remote;
            boolean bl = remote = DB.isRemoteObjects() && CConnection.get().isAppsServerOK(false);
            if (remote && this.p_remoteErrors > 1) {
                remote = CConnection.get().isAppsServerOK(true);
            }
            if (remote) {
                Server server = CConnection.get().getServer();
                if (server != null) {
                    RowSet rs = server.stmt_getRowSet(this.p_vo);
                    if (rs == null) {
                        this.log.warning("ResultSet is null - " + this.p_vo);
                    } else {
                        this.p_remoteErrors = 0;
                    }
                    return rs;
                }
                this.log.log(Level.SEVERE, "AppsServer not found");
                ++this.p_remoteErrors;
            }
        }
        catch (RemoteException ex) {
            this.log.log(Level.SEVERE, "AppsServer error", ex);
            ++this.p_remoteErrors;
        }
        this.log.warning("execute locally");
        Statement stmt = this.local_getStatement(false, null);
        return stmt.executeQuery(this.p_vo.getSql());
    }

    public int executeUpdate(String sql0) throws SQLException {
        this.p_vo.setSql(DB.getDatabase().convertStatement(sql0));
        if (this.p_stmt != null) {
            return this.p_stmt.executeUpdate(this.p_vo.getSql());
        }
        this.log.finest("server => " + this.p_vo + ", Remote=" + DB.isRemoteObjects());
        try {
            boolean remote;
            boolean bl = remote = DB.isRemoteObjects() && CConnection.get().isAppsServerOK(false);
            if (remote && this.p_remoteErrors > 1) {
                remote = CConnection.get().isAppsServerOK(true);
            }
            if (remote) {
                Server server = CConnection.get().getServer();
                if (server != null) {
                    int result = server.stmt_executeUpdate(this.p_vo);
                    this.p_vo.clearParameters();
                    return result;
                }
                this.log.log(Level.SEVERE, "AppsServer not found");
                ++this.p_remoteErrors;
            }
        }
        catch (RemoteException ex) {
            this.log.log(Level.SEVERE, "AppsServer error", ex);
            ++this.p_remoteErrors;
        }
        this.log.warning("execute locally");
        Statement pstmt = this.local_getStatement(false, null);
        return pstmt.executeUpdate(this.p_vo.getSql());
    }

    public String getSql() {
        if (this.p_vo != null) {
            return this.p_vo.getSql();
        }
        return null;
    }

    public Connection getConnection() throws SQLException {
        if (this.p_stmt != null) {
            return this.p_stmt.getConnection();
        }
        return null;
    }

    public void commit() throws SQLException {
        Connection conn = this.getConnection();
        if (conn != null && !conn.getAutoCommit()) {
            conn.commit();
            this.log.fine("commit");
        }
    }

    public int executeUpdate(String sql0, int autoGeneratedKeys) throws SQLException {
        this.p_vo.setSql(DB.getDatabase().convertStatement(sql0));
        if (this.p_stmt != null) {
            return this.p_stmt.executeUpdate(this.p_vo.getSql(), autoGeneratedKeys);
        }
        throw new UnsupportedOperationException("Method executeUpdate() not yet implemented.");
    }

    public int executeUpdate(String sql0, int[] columnIndexes) throws SQLException {
        this.p_vo.setSql(DB.getDatabase().convertStatement(sql0));
        if (this.p_stmt != null) {
            return this.p_stmt.executeUpdate(this.p_vo.getSql(), columnIndexes);
        }
        throw new UnsupportedOperationException("Method executeUpdate() not yet implemented.");
    }

    public int executeUpdate(String sql0, String[] columnNames) throws SQLException {
        this.p_vo.setSql(DB.getDatabase().convertStatement(sql0));
        if (this.p_stmt != null) {
            return this.p_stmt.executeUpdate(this.p_vo.getSql(), columnNames);
        }
        throw new UnsupportedOperationException("Method executeUpdate() not yet implemented.");
    }

    public boolean execute(String sql0) throws SQLException {
        this.p_vo.setSql(DB.getDatabase().convertStatement(sql0));
        if (this.p_stmt != null) {
            return this.p_stmt.execute(this.p_vo.getSql());
        }
        throw new UnsupportedOperationException("Method execute() not yet implemented.");
    }

    public boolean execute(String sql0, int autoGeneratedKeys) throws SQLException {
        this.p_vo.setSql(DB.getDatabase().convertStatement(sql0));
        if (this.p_stmt != null) {
            return this.p_stmt.execute(this.p_vo.getSql(), autoGeneratedKeys);
        }
        throw new UnsupportedOperationException("Method execute() not yet implemented.");
    }

    public boolean execute(String sql0, int[] columnIndexes) throws SQLException {
        this.p_vo.setSql(DB.getDatabase().convertStatement(sql0));
        if (this.p_stmt != null) {
            return this.p_stmt.execute(this.p_vo.getSql(), columnIndexes);
        }
        throw new UnsupportedOperationException("Method execute() not yet implemented.");
    }

    public boolean execute(String sql0, String[] columnNames) throws SQLException {
        this.p_vo.setSql(DB.getDatabase().convertStatement(sql0));
        if (this.p_stmt != null) {
            return this.p_stmt.execute(this.p_vo.getSql(), columnNames);
        }
        throw new UnsupportedOperationException("Method execute() not yet implemented.");
    }

    public int getMaxFieldSize() throws SQLException {
        if (this.p_stmt != null) {
            return this.p_stmt.getMaxFieldSize();
        }
        throw new UnsupportedOperationException("Method getMaxFieldSize() not yet implemented.");
    }

    public void setMaxFieldSize(int max) throws SQLException {
        if (this.p_stmt == null) {
            throw new UnsupportedOperationException("Method setMaxFieldSize() not yet implemented.");
        }
        this.p_stmt.setMaxFieldSize(max);
    }

    public int getMaxRows() throws SQLException {
        if (this.p_stmt != null) {
            return this.p_stmt.getMaxRows();
        }
        throw new UnsupportedOperationException("Method getMaxRows() not yet implemented.");
    }

    public void setMaxRows(int max) throws SQLException {
        if (this.p_stmt == null) {
            throw new UnsupportedOperationException("Method setMaxRows() not yet implemented.");
        }
        this.p_stmt.setMaxRows(max);
    }

    public void addBatch(String sql) throws SQLException {
        if (this.p_stmt == null) {
            throw new UnsupportedOperationException("Method addBatch() not yet implemented.");
        }
        this.p_stmt.addBatch(sql);
    }

    public void clearBatch() throws SQLException {
        if (this.p_stmt == null) {
            throw new UnsupportedOperationException("Method clearBatch() not yet implemented.");
        }
        this.p_stmt.clearBatch();
    }

    public int[] executeBatch() throws SQLException {
        if (this.p_stmt != null) {
            return this.p_stmt.executeBatch();
        }
        throw new UnsupportedOperationException("Method executeBatch() not yet implemented.");
    }

    public boolean getMoreResults(int current) throws SQLException {
        if (this.p_stmt != null) {
            return this.p_stmt.getMoreResults(current);
        }
        throw new UnsupportedOperationException("Method getMoreResults() not yet implemented.");
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        if (this.p_stmt != null) {
            return this.p_stmt.getGeneratedKeys();
        }
        throw new UnsupportedOperationException("Method getGeneratedKeys() not yet implemented.");
    }

    public int getResultSetHoldability() throws SQLException {
        if (this.p_stmt != null) {
            return this.p_stmt.getResultSetHoldability();
        }
        throw new UnsupportedOperationException("Method getResultSetHoldability() not yet implemented.");
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        if (this.p_stmt == null) {
            throw new UnsupportedOperationException("Method setEscapeProcessing() not yet implemented.");
        }
        this.p_stmt.setEscapeProcessing(enable);
    }

    public int getQueryTimeout() throws SQLException {
        if (this.p_stmt != null) {
            return this.p_stmt.getQueryTimeout();
        }
        throw new UnsupportedOperationException("Method getQueryTimeout() not yet implemented.");
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        if (this.p_stmt == null) {
            throw new UnsupportedOperationException("Method setQueryTimeout() not yet implemented.");
        }
        this.p_stmt.setQueryTimeout(seconds);
    }

    public void cancel() throws SQLException {
        if (this.p_stmt == null) {
            throw new UnsupportedOperationException("Method cancel() not yet implemented.");
        }
        this.p_stmt.cancel();
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.p_stmt != null) {
            return this.p_stmt.getWarnings();
        }
        throw new UnsupportedOperationException("Method getWarnings() not yet implemented.");
    }

    public void clearWarnings() throws SQLException {
        if (this.p_stmt == null) {
            throw new UnsupportedOperationException("Method clearWarnings() not yet implemented.");
        }
        this.p_stmt.clearWarnings();
    }

    public void setCursorName(String name) throws SQLException {
        if (this.p_stmt == null) {
            throw new UnsupportedOperationException("Method setCursorName() not yet implemented.");
        }
        this.p_stmt.setCursorName(name);
    }

    public ResultSet getResultSet() throws SQLException {
        if (this.p_stmt != null) {
            return this.p_stmt.getResultSet();
        }
        throw new UnsupportedOperationException("Method getResultSet() not yet implemented.");
    }

    public int getUpdateCount() throws SQLException {
        if (this.p_stmt != null) {
            return this.p_stmt.getUpdateCount();
        }
        throw new UnsupportedOperationException("Method getUpdateCount() not yet implemented.");
    }

    public boolean getMoreResults() throws SQLException {
        if (this.p_stmt != null) {
            return this.p_stmt.getMoreResults();
        }
        throw new UnsupportedOperationException("Method getMoreResults() not yet implemented.");
    }

    public void setFetchDirection(int direction) throws SQLException {
        if (this.p_stmt == null) {
            throw new UnsupportedOperationException("Method setFetchDirection() not yet implemented.");
        }
        this.p_stmt.setFetchDirection(direction);
    }

    public int getFetchDirection() throws SQLException {
        if (this.p_stmt != null) {
            return this.p_stmt.getFetchDirection();
        }
        throw new UnsupportedOperationException("Method getFetchDirection() not yet implemented.");
    }

    public void setFetchSize(int rows) throws SQLException {
        if (this.p_stmt == null) {
            throw new UnsupportedOperationException("Method setFetchSize() not yet implemented.");
        }
        this.p_stmt.setFetchSize(rows);
    }

    public int getFetchSize() throws SQLException {
        if (this.p_stmt != null) {
            return this.p_stmt.getFetchSize();
        }
        throw new UnsupportedOperationException("Method getFetchSize() not yet implemented.");
    }

    public int getResultSetConcurrency() throws SQLException {
        if (this.p_stmt != null) {
            return this.p_stmt.getResultSetConcurrency();
        }
        throw new UnsupportedOperationException("Method getResultSetConcurrency() not yet implemented.");
    }

    public int getResultSetType() throws SQLException {
        if (this.p_stmt != null) {
            return this.p_stmt.getResultSetType();
        }
        throw new UnsupportedOperationException("Method getResultSetType() not yet implemented.");
    }

    public void close() throws SQLException {
        if (this.p_stmt != null) {
            this.p_stmt.close();
        }
    }

    public int remote_executeUpdate() {
        this.log.finest("");
        try {
            CompiereDatabase db = CConnection.get().getDatabase();
            if (db == null) {
                throw new NullPointerException("Remote - No Database");
            }
            Statement pstmt = this.local_getStatement(false, null);
            int result = pstmt.executeUpdate(this.p_vo.getSql());
            pstmt.close();
            return result;
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, this.p_vo.toString(), ex);
            throw new RuntimeException(ex);
        }
    }

    private Statement local_getStatement(boolean dedicatedConnection, String trxName) {
        Trx trx;
        this.log.finest("");
        Connection conn = null;
        Trx trx2 = trx = trxName == null ? null : Trx.get(trxName, true);
        conn = trx != null ? trx.getConnection() : (dedicatedConnection ? DB.createConnection(false, 2) : this.local_getConnection(trxName));
        Statement stmt = null;
        try {
            stmt = conn.createStatement(this.p_vo.getResultSetType(), this.p_vo.getResultSetConcurrency());
        }
        catch (SQLException ex) {
            this.log.log(Level.SEVERE, "local", ex);
            try {
                if (stmt != null) {
                    stmt.close();
                }
                stmt = null;
            }
            catch (SQLException ex1) {
                // empty catch block
            }
        }
        return stmt;
    }

    protected Connection local_getConnection(String trxName) {
        Trx trx;
        Connection conn = null;
        Trx trx2 = trx = trxName == null ? null : Trx.get(trxName, true);
        conn = trx != null ? trx.getConnection() : (this.p_vo.getResultSetConcurrency() == 1008 ? DB.getConnectionRW() : DB.getConnectionRO());
        return conn;
    }

    public RowSet remote_getRowSet() {
        this.log.finest("remote");
        Connection conn = this.local_getConnection(null);
        PreparedStatement pstmt = null;
        RowSet rowSet = null;
        try {
            pstmt = conn.prepareStatement(this.p_vo.getSql(), 1004, 1007);
            ArrayList<?> parameters = this.p_vo.getParameters();
            for (int i = 0; i < parameters.size(); ++i) {
                Object o = parameters.get(i);
                if (o == null) {
                    throw new IllegalArgumentException("Null Parameter #" + i);
                }
                if (o instanceof NullParameter) {
                    int type = ((NullParameter)o).getType();
                    pstmt.setNull(i + 1, type);
                    this.log.finest("#" + (i + 1) + " - Null");
                    continue;
                }
                if (o instanceof Integer) {
                    pstmt.setInt(i + 1, (Integer)o);
                    this.log.finest("#" + (i + 1) + " - int=" + o);
                    continue;
                }
                if (o instanceof String) {
                    pstmt.setString(i + 1, (String)o);
                    this.log.finest("#" + (i + 1) + " - String=" + o);
                    continue;
                }
                if (o instanceof Timestamp) {
                    pstmt.setTimestamp(i + 1, (Timestamp)o);
                    this.log.finest("#" + (i + 1) + " - Timestamp=" + o);
                    continue;
                }
                if (o instanceof BigDecimal) {
                    pstmt.setBigDecimal(i + 1, (BigDecimal)o);
                    this.log.finest("#" + (i + 1) + " - BigDecimal=" + o);
                    continue;
                }
                throw new UnsupportedOperationException("Unknown Parameter Class=" + o.getClass());
            }
            ResultSet rs = pstmt.executeQuery();
            rowSet = CCachedRowSet.getRowSet(rs);
            pstmt.close();
            pstmt = null;
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, this.p_vo.toString(), ex);
            throw new RuntimeException(ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "close pstmt", e);
        }
        return rowSet;
    }
}

