/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipUtil {
    private ZipFile m_zipFile;

    public ZipUtil() {
    }

    public ZipUtil(String fileName) {
        this.open(fileName);
    }

    public ZipUtil(File file) {
        this.open(file);
    }

    public ZipUtil(URI uri) {
        this.open(uri);
    }

    public boolean open(URI uri) {
        if (uri == null) {
            return false;
        }
        try {
            return this.open(new File(uri));
        }
        catch (Exception ex) {
            System.err.println("ZipUtil.open - " + ex);
            ex.printStackTrace();
            return false;
        }
    }

    public boolean open(String fileName) {
        if (fileName == null) {
            return false;
        }
        try {
            return this.open(new File(fileName));
        }
        catch (Exception ex) {
            System.err.println("ZipUtil.open - " + ex);
            return false;
        }
    }

    public boolean open(File file) {
        if (file == null) {
            return false;
        }
        try {
            this.m_zipFile = file.getName().endsWith("jar") ? new JarFile(file, false, 1) : new ZipFile(file, 1);
        }
        catch (IOException ex) {
            System.err.println("ZipUtil.open - " + ex);
            this.m_zipFile = null;
            return false;
        }
        return true;
    }

    public void close() {
        try {
            if (this.m_zipFile != null) {
                this.m_zipFile.close();
            }
        }
        catch (IOException ex) {
            System.err.println("ZipUtil.close - " + ex);
        }
        this.m_zipFile = null;
    }

    public boolean isOpen() {
        return this.m_zipFile != null;
    }

    public boolean isJar() {
        return this.m_zipFile != null && this.m_zipFile instanceof JarFile;
    }

    public JarFile getJar() {
        if (this.m_zipFile != null && this.m_zipFile instanceof JarFile) {
            return (JarFile)this.m_zipFile;
        }
        return null;
    }

    public String toString() {
        if (this.m_zipFile != null) {
            return this.m_zipFile.toString();
        }
        return "ZipUtil";
    }

    public String[] getContent() {
        if (!this.isOpen()) {
            return null;
        }
        Enumeration<? extends ZipEntry> e = this.m_zipFile.entries();
        ArrayList<ZipEntry> list = new ArrayList<ZipEntry>();
        while (e.hasMoreElements()) {
            list.add(e.nextElement());
        }
        Object[] retValue = new String[list.size()];
        for (int i = 0; i < retValue.length; ++i) {
            retValue[i] = ((ZipEntry)list.get(i)).getName();
        }
        Arrays.sort(retValue);
        return retValue;
    }

    public Enumeration<? extends ZipEntry> entries() {
        if (!this.isOpen()) {
            return null;
        }
        return this.m_zipFile.entries();
    }

    public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        if (!this.isOpen()) {
            return null;
        }
        return this.m_zipFile.getInputStream(zipEntry);
    }

    public ZipEntry getEntry(String name) {
        if (!this.isOpen()) {
            return null;
        }
        return this.m_zipFile.getEntry(name);
    }

    public String getEntryInfo(String name) {
        StringBuffer sb = new StringBuffer(name);
        ZipEntry e = this.getEntry(name);
        if (e == null) {
            sb.append(": -");
        } else {
            Timestamp ts = new Timestamp(e.getTime());
            sb.append(": ").append(ts).append(" - ").append(e.getSize());
        }
        return sb.toString();
    }

    public Manifest getManifest() {
        try {
            JarFile jar = this.getJar();
            if (jar != null) {
                return jar.getManifest();
            }
        }
        catch (IOException ex) {
            System.err.println("ZipUtil.getManifest - " + ex);
        }
        return null;
    }

    public static ZipEntry getEntry(String fileName, String entryName) {
        ZipUtil zu;
        if (fileName == null || entryName == null) {
            return null;
        }
        File file = new File(fileName);
        if (!file.exists()) {
            String fn = ZipUtil.findInPath(fileName);
            if (fn == null) {
                return null;
            }
            file = new File(fn);
        }
        if (!(zu = new ZipUtil(file)).isOpen()) {
            return null;
        }
        ZipEntry retValue = zu.getEntry(entryName);
        if (retValue == null) {
            Enumeration<? extends ZipEntry> e = zu.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                if (entry.getName().indexOf(entryName) == -1) continue;
                retValue = entry;
                break;
            }
        }
        zu.close();
        return retValue;
    }

    public static JarFile getJar(String fileName) {
        if (fileName == null) {
            return null;
        }
        File file = new File(fileName);
        if (!file.exists()) {
            String fn = ZipUtil.findInPath(fileName);
            if (fn == null) {
                return null;
            }
            file = new File(fn);
        }
        ZipUtil zu = new ZipUtil(file);
        return zu.getJar();
    }

    public static Manifest getManifest(String fileName) {
        if (fileName == null) {
            return null;
        }
        JarFile jar = ZipUtil.getJar(fileName);
        if (jar == null) {
            return null;
        }
        try {
            return jar.getManifest();
        }
        catch (IOException ex) {
            System.err.println("ZipUtil.getManifest - " + ex);
            return null;
        }
    }

    public static JarEntry getJarEntry(String fileName, String jarEntry) {
        if (fileName == null) {
            return null;
        }
        JarFile jar = ZipUtil.getJar(fileName);
        if (jar == null) {
            return null;
        }
        return jar.getJarEntry(jarEntry);
    }

    public static void dumpManifest(String fileName) {
        Manifest mf = ZipUtil.getManifest(fileName);
        if (mf == null) {
            System.out.println("No Jar file: " + fileName);
            return;
        }
        System.out.println(mf.getEntries());
    }

    public static String getEntryTime(String fileName, String entryName) {
        ZipEntry entry = ZipUtil.getEntry(fileName, entryName);
        if (entry == null) {
            return null;
        }
        Timestamp ts = new Timestamp(entry.getTime());
        return ts.toString();
    }

    public static String findInPath(String jarFile) {
        int i;
        String path = System.getProperty("java.class.path");
        String[] pathEntries = path.split(System.getProperty("path.separator"));
        for (i = 0; i < pathEntries.length; ++i) {
            if (pathEntries[i].indexOf(jarFile) == -1) continue;
            return pathEntries[i];
        }
        path = System.getProperty("sun.boot.class.path");
        pathEntries = path.split(System.getProperty("path.separator"));
        for (i = 0; i < pathEntries.length; ++i) {
            if (pathEntries[i].indexOf(jarFile) == -1) continue;
            return pathEntries[i];
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            JarFile jar = ZipUtil.getJar("CClient.jar");
            if (jar == null) {
                jar = ZipUtil.getJar("CTools.jar");
            }
            if (jar == null) {
                return;
            }
            Manifest mf = jar.getManifest();
            if (mf != null) {
                Attributes atts = mf.getMainAttributes();
                atts.getValue("Implementation-Vendor");
                atts.getValue("Implementation-Version");
            }
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
    }
}

