/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.struts.button;

import com.ampiere.dto.CodeValue;
import com.ampiere.search.ColBean;
import com.ampiere.util.AmpiereUtil;
import com.ampiere.web.struts.button.CreateFromBaseForm;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MLocatorLookup;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.X_C_OrderLine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateFromShipmentForm
extends CreateFromBaseForm {
    private static final long serialVersionUID = -2388216106087950733L;
    protected String locatorLabel;
    protected String locatorSelected;
    protected List<CodeValue> locatorList;

    @Override
    public void statInit(Ctx ctx) {
        super.statInit(ctx);
        this.setTitle(Msg.getElement(ctx, "M_InOut_ID", false) + " .. " + Msg.translate(ctx, "CreateFrom"));
        this.setLocatorLabel(Msg.getElement(ctx, "M_Locator_ID"));
        this.locatorList = new ArrayList<CodeValue>();
        MLocatorLookup locator = new MLocatorLookup(ctx, this.getWindowNo());
        locator.setOnly_Warehouse_ID(AmpiereUtil.getOnly_Warehouse_ID(ctx, this.getWindowNo()));
        ArrayList<NamePair> col = locator.getData(true, true, true, false);
        for (NamePair loc : col) {
            String key = String.valueOf(loc.getID());
            String name = loc.getName();
            this.locatorList.add(new CodeValue(key, name));
        }
        this.initBPartner(this.getBpartnerID(), false, ctx);
    }

    @Override
    protected void initBPDetails(int C_BPartner_ID, Ctx ctx) {
        this.log.config("C_BPartner_ID=" + C_BPartner_ID);
        this.invoiceList = new ArrayList();
        CodeValue pp = new CodeValue("0", "");
        this.invoiceList.add(pp);
        StringBuffer display = new StringBuffer("i.DocumentNo||' - '||").append(DB.TO_CHAR("DateInvoiced", 15, Env.getAD_Language(ctx))).append("|| ' - ' ||").append(DB.TO_CHAR("GrandTotal", 12, Env.getAD_Language(ctx)));
        StringBuffer sql = new StringBuffer("SELECT i.C_Invoice_ID,").append(display).append(" FROM C_Invoice i WHERE i.C_BPartner_ID=? AND i.IsSOTrx='N' AND i.DocStatus IN ('CL','CO') AND i.C_Invoice_ID IN (SELECT il.C_Invoice_ID FROM C_InvoiceLine il LEFT OUTER JOIN M_MatchInv mi ON (il.C_InvoiceLine_ID=mi.C_InvoiceLine_ID) GROUP BY il.C_Invoice_ID,mi.C_InvoiceLine_ID,il.QtyInvoiced HAVING (il.QtyInvoiced<>SUM(mi.Qty) AND mi.C_InvoiceLine_ID IS NOT NULL) OR mi.C_InvoiceLine_ID IS NULL) ORDER BY i.DateInvoiced");
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setInt(1, C_BPartner_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                pp = new CodeValue(rs.getString(1), rs.getString(2));
                this.invoiceList.add(pp);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
        }
        this.invoiceSelected = "0";
    }

    public List loadInvoice(int C_Invoice_ID, Ctx ctx, int maxRecNo) {
        this.log.config("C_Invoice_ID=" + C_Invoice_ID);
        StringBuffer sql = new StringBuffer("SELECT l.QtyInvoiced-SUM(NVL(mi.Qty,0)),l.QtyEntered/l.QtyInvoiced, l.C_UOM_ID,COALESCE(uom.UOMSymbol,uom.Name), l.M_Product_ID,p.Name, l.C_InvoiceLine_ID,l.Line, l.C_OrderLine_ID ");
        if (Env.isBaseLanguage(ctx, "C_UOM")) {
            sql.append("FROM C_UOM uom, C_InvoiceLine l, M_Product p, M_MatchInv mi ");
            sql.append("WHERE l.C_UOM_ID=uom.C_UOM_ID");
        } else {
            sql.append("FROM C_UOM_Trl uom, C_InvoiceLine_v l, M_Product p, M_MatchInv mi ");
            sql.append("WHERE l.C_UOM_ID=uom.C_UOM_ID AND uom.AD_Language='").append(Env.getAD_Language(ctx)).append("'");
        }
        sql.append(" AND l.M_Product_ID=p.M_Product_ID AND l.C_InvoiceLine_ID=mi.C_InvoiceLine_ID(+) AND l.C_Invoice_ID=? GROUP BY l.QtyInvoiced,l.QtyEntered/l.QtyInvoiced,l.C_UOM_ID,COALESCE(uom.UOMSymbol,uom.Name),l.M_Product_ID,p.Name, l.C_InvoiceLine_ID,l.Line,l.C_OrderLine_ID ORDER BY l.Line");
        ArrayList<ColBean> resultList = new ArrayList<ColBean>();
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setInt(1, C_Invoice_ID);
            ResultSet rs = pstmt.executeQuery();
            int lineCount = 0;
            while (rs.next()) {
                ColBean colBean = new ColBean();
                colBean.setColId(Integer.toString(lineCount));
                int beanOffset = 0;
                if (++lineCount > maxRecNo) break;
                colBean.setColData(beanOffset, "false");
                colBean.setColTitle(beanOffset, Msg.translate(ctx, "Select"));
                colBean.setStyle(beanOffset, "text-align: center;");
                BigDecimal qtyInvoiced = rs.getBigDecimal(1);
                BigDecimal multiplier = rs.getBigDecimal(2);
                BigDecimal qtyEntered = qtyInvoiced.multiply(multiplier);
                colBean.setColData(++beanOffset, qtyEntered);
                colBean.setColTitle(beanOffset, Msg.translate(ctx, "Quantity"));
                colBean.setStyle(beanOffset, "text-align: right;");
                KeyNamePair pp = new KeyNamePair(rs.getInt(3), rs.getString(4).trim());
                colBean.setColData(++beanOffset, pp);
                colBean.setColTitle(beanOffset, Msg.translate(ctx, "C_UOM_ID"));
                colBean.setStyle(beanOffset, "text-align: left;");
                pp = new KeyNamePair(rs.getInt(5), rs.getString(6));
                colBean.setColData(++beanOffset, pp);
                colBean.setColTitle(beanOffset, Msg.translate(ctx, "M_Product_ID"));
                colBean.setStyle(beanOffset, "text-align: left;");
                ++beanOffset;
                int C_OrderLine_ID = rs.getInt(9);
                if (rs.wasNull()) {
                    colBean.setColData(beanOffset, null);
                } else {
                    colBean.setColData(beanOffset, new KeyNamePair(C_OrderLine_ID, "."));
                }
                colBean.setColTitle(beanOffset, Msg.getElement(ctx, "C_Order_ID", false));
                colBean.setStyle(beanOffset, "text-align: left;");
                colBean.setColData(++beanOffset, null);
                colBean.setColTitle(beanOffset, Msg.getElement(ctx, "M_InOut_ID", false));
                colBean.setStyle(beanOffset, "text-align: left;");
                pp = new KeyNamePair(rs.getInt(7), rs.getString(8));
                colBean.setColData(++beanOffset, null);
                colBean.setColTitle(beanOffset, Msg.getElement(ctx, "C_Invoice_ID", false));
                colBean.setStyle(beanOffset, "text-align: left;");
                ++beanOffset;
                resultList.add(colBean);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
        }
        return resultList;
    }

    protected boolean save(Ctx ctx, int M_InOut_ID, List resultList) {
        this.log.config("");
        if (this.selectedIndex == null || this.selectedIndex.length() <= 0) {
            return false;
        }
        String[] ppp = this.selectedIndex.split("\\,");
        if (ppp == null || ppp.length <= 0) {
            return false;
        }
        if (this.locatorSelected == null || this.locatorSelected.length() <= 0) {
            return false;
        }
        int M_Locator_ID = Integer.parseInt(this.locatorSelected);
        MInOut inout = new MInOut(ctx, M_InOut_ID, null);
        this.log.config(inout + ", C_Locator_ID=" + M_Locator_ID);
        MOrder p_order = null;
        int C_Invoice_ID = Integer.parseInt(this.invoiceSelected);
        MInvoice invoice = null;
        if (C_Invoice_ID != 0) {
            invoice = new MInvoice(ctx, C_Invoice_ID, null);
        } else {
            int C_Order_ID = Integer.parseInt(this.orderSelected);
            if (C_Order_ID != 0) {
                p_order = new MOrder(ctx, C_Order_ID, null);
            }
        }
        for (int i2 = 0; i2 < ppp.length; ++i2) {
            int idx = Integer.parseInt(ppp[i2]);
            ColBean colBean = (ColBean)resultList.get(idx);
            if (colBean == null) continue;
            BigDecimal QtyEntered = (BigDecimal)colBean.getColData(1);
            KeyNamePair pp = (KeyNamePair)colBean.getColData(2);
            int C_UOM_ID = pp.getKey();
            pp = (KeyNamePair)colBean.getColData(3);
            int M_Product_ID = pp.getKey();
            int C_OrderLine_ID = 0;
            pp = (KeyNamePair)colBean.getColData(4);
            if (pp != null) {
                C_OrderLine_ID = pp.getKey();
            }
            int C_InvoiceLine_ID = 0;
            MInvoiceLine il = null;
            pp = (KeyNamePair)colBean.getColData(6);
            if (pp != null) {
                C_InvoiceLine_ID = pp.getKey();
            }
            if (C_InvoiceLine_ID != 0) {
                il = new MInvoiceLine(ctx, C_InvoiceLine_ID, null);
            }
            this.log.fine("Line QtyEntered=" + QtyEntered + ", Product=" + M_Product_ID + ", OrderLine=" + C_OrderLine_ID + ", InvoiceLine=" + C_InvoiceLine_ID);
            if (invoice != null && invoice.isCreditMemo()) {
                QtyEntered = QtyEntered.negate();
            }
            MInOutLine iol = new MInOutLine(inout);
            iol.setM_Product_ID(M_Product_ID, C_UOM_ID);
            iol.setQty(QtyEntered);
            X_C_OrderLine ol = null;
            if (C_OrderLine_ID != 0) {
                iol.setC_OrderLine_ID(C_OrderLine_ID);
                ol = new MOrderLine(ctx, C_OrderLine_ID, null);
                if (ol.getQtyEntered().compareTo(ol.getQtyOrdered()) != 0) {
                    iol.setMovementQty(QtyEntered.multiply(ol.getQtyOrdered()).divide(ol.getQtyEntered(), 12, 4));
                    iol.setC_UOM_ID(ol.getC_UOM_ID());
                }
                iol.setM_AttributeSetInstance_ID(ol.getM_AttributeSetInstance_ID());
                iol.setDescription(ol.getDescription());
            } else if (il != null) {
                if (il.getQtyEntered().compareTo(il.getQtyInvoiced()) != 0) {
                    iol.setQtyEntered(QtyEntered.multiply(il.getQtyInvoiced()).divide(il.getQtyEntered(), 12, 4));
                    iol.setC_UOM_ID(il.getC_UOM_ID());
                }
                iol.setDescription(il.getDescription());
            }
            if (M_Product_ID == 0) {
                if (ol != null && ol.getC_Charge_ID() != 0) {
                    iol.setC_Charge_ID(ol.getC_Charge_ID());
                } else if (il != null && il.getC_Charge_ID() != 0) {
                    iol.setC_Charge_ID(il.getC_Charge_ID());
                }
            }
            iol.setM_Locator_ID(M_Locator_ID);
            if (!iol.save()) {
                this.log.log(Level.SEVERE, "Line NOT created #" + i2);
                continue;
            }
            if (il == null) continue;
            il.setM_InOutLine_ID(iol.getM_InOutLine_ID());
            il.save();
        }
        if (p_order != null) {
            inout.setC_Order_ID(p_order.getC_Order_ID());
            inout.setAD_OrgTrx_ID(p_order.getAD_OrgTrx_ID());
            inout.setC_Project_ID(p_order.getC_Project_ID());
            inout.setC_Campaign_ID(p_order.getC_Campaign_ID());
            inout.setC_Activity_ID(p_order.getC_Activity_ID());
            inout.setUser1_ID(p_order.getUser1_ID());
            inout.setUser2_ID(p_order.getUser2_ID());
        }
        if (invoice != null && invoice.getC_Invoice_ID() != 0) {
            if (inout.getC_Order_ID() == 0) {
                inout.setC_Order_ID(invoice.getC_Order_ID());
            }
            inout.setC_Invoice_ID(invoice.getC_Invoice_ID());
            inout.setAD_OrgTrx_ID(invoice.getAD_OrgTrx_ID());
            inout.setC_Project_ID(invoice.getC_Project_ID());
            inout.setC_Campaign_ID(invoice.getC_Campaign_ID());
            inout.setC_Activity_ID(invoice.getC_Activity_ID());
            inout.setUser1_ID(invoice.getUser1_ID());
            inout.setUser2_ID(invoice.getUser2_ID());
        }
        inout.save();
        return true;
    }

    public String getLocatorLabel() {
        return this.locatorLabel;
    }

    public void setLocatorLabel(String locatorLabel) {
        this.locatorLabel = locatorLabel;
    }

    public List<CodeValue> getLocatorList() {
        return this.locatorList;
    }

    public void setLocatorList(List<CodeValue> locatorList) {
        this.locatorList = locatorList;
    }

    public String getLocatorSelected() {
        return this.locatorSelected;
    }

    public void setLocatorSelected(String locatorSelected) {
        this.locatorSelected = locatorSelected;
    }
}

