/*
 * Decompiled with CFR 0.152.
 */
package com.jware.apps.scheduler.web.struts.schedule;

import com.jware.apps.scheduler.model.JobParameterValue;
import com.jware.apps.scheduler.util.JobSchedulerUtils;
import com.jware.apps.scheduler.web.struts.schedule.JobListenerForm;
import com.jware.apps.scheduler.web.struts.schedule.JobScheduleViewForm;
import com.jware.apps.scheduler.web.struts.schedule.JobTriggerForm;
import com.jware.base.web.struts.jWareBaseAction;
import java.util.LinkedList;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;

public final class JobScheduleView
extends jWareBaseAction {
    private Log log = LogFactory.getLog((String)this.getClass().getName());

    public ActionForward doExecute(ActionMapping mapping, ActionForm form2, HttpServletRequest request, HttpServletResponse response, ActionErrors errors, boolean mochaFlag) throws Exception {
        HttpSession session = request.getSession();
        Locale locale = this.getLocale(request);
        JobScheduleViewForm info = (JobScheduleViewForm)form2;
        MessageResources messages = this.getResources(request);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"JobScheduleView:  Processing actions");
        }
        if (info == null) {
            info = new JobScheduleViewForm();
        }
        JobDetail jobDetail = null;
        String jobName = request.getParameter("jobName");
        if (jobName == null) {
            jobName = (String)session.getAttribute("jobName");
        }
        session.setAttribute("jobName", (Object)jobName);
        String groupName = request.getParameter("groupName");
        if (groupName == null) {
            groupName = (String)session.getAttribute("groupName");
        }
        if (jobName != null && groupName != null) {
            Scheduler scheduler = JobSchedulerUtils.getCurrentScheduler(session);
            jobDetail = scheduler.getJobDetail(jobName, groupName);
            if (jobDetail != null) {
                info.setName(jobName);
                info.setGroupName(groupName);
                info.setDescription(jobDetail.getDescription());
                info.setDescription(jobDetail.getDescription());
                info.setJobClass(jobDetail.getJobClass().getName());
                info.setVolatility(jobDetail.isVolatile());
                info.setDurable(jobDetail.isDurable());
                info.getParamMap().put("jobName", jobName);
                info.getParamMap().put("groupName", groupName);
                JobDataMap jobDataMap = jobDetail.getJobDataMap();
                LinkedList<JobParameterValue> parameters = new LinkedList<JobParameterValue>();
                String[] parameterNames = jobDataMap.getKeys();
                for (int i2 = 0; i2 < parameterNames.length; ++i2) {
                    String parameterName = parameterNames[i2];
                    if (jobDataMap.get((Object)parameterName) == null) continue;
                    JobParameterValue jobParameterValue = new JobParameterValue();
                    jobParameterValue.setParameterName(parameterName);
                    jobParameterValue.setParameterValue(jobDataMap.get((Object)parameterName).toString());
                    parameters.add(jobParameterValue);
                }
                info.setJobParameters(parameters);
                this.populateForm(jobDetail, info, scheduler);
            }
            request.setAttribute("jobViewForm", (Object)info);
            session.setAttribute("jobName", (Object)jobName);
            session.setAttribute("groupName", (Object)groupName);
            return mapping.findForward("success");
        }
        return mapping.findForward("failure");
    }

    private void populateForm(JobDetail jobDetail, JobScheduleViewForm viewForm, Scheduler scheduler) {
        Trigger[] triggers = JobSchedulerUtils.getTriggersFromJob(scheduler, jobDetail.getName(), jobDetail.getGroup());
        for (int i2 = 0; i2 < triggers.length; ++i2) {
            Trigger trigger = triggers[i2];
            JobTriggerForm tForm = new JobTriggerForm();
            tForm.setDescription(trigger.getDescription());
            tForm.setJobGroup(trigger.getJobGroup());
            tForm.setJobName(trigger.getJobName());
            tForm.setMisFireInstruction(trigger.getMisfireInstruction());
            tForm.setStartTime(JobSchedulerUtils.getDateAsString(trigger.getStartTime()));
            tForm.setStopTime(JobSchedulerUtils.getDateAsString(trigger.getEndTime()));
            tForm.setTriggerGroup(trigger.getGroup());
            tForm.setTriggerName(trigger.getName());
            tForm.setNextFireTime(JobSchedulerUtils.getDateAsString(trigger.getNextFireTime()));
            tForm.setPreviousFireTime(JobSchedulerUtils.getDateAsString(trigger.getPreviousFireTime()));
            tForm.setType(JobSchedulerUtils.getTriggerType(trigger));
            tForm.getParamMap().put("triggerName", trigger.getName());
            tForm.getParamMap().put("groupName", trigger.getGroup());
            tForm.getJobParamMap().put("jobName", trigger.getJobName());
            tForm.getJobParamMap().put("groupName", trigger.getJobGroup());
            viewForm.getJobTriggers().add(tForm);
        }
        try {
            String[] jobListenerNames = jobDetail.getJobListenerNames();
            for (String name : scheduler.getJobListenerNames()) {
                JobListener jobListener = scheduler.getJobListener(name);
                for (int i3 = 0; i3 < jobListenerNames.length; ++i3) {
                    if (!jobListener.getName().equals(jobListenerNames[i3])) continue;
                    JobListenerForm listenerForm = new JobListenerForm();
                    listenerForm.setListenerName(jobListener.getName());
                    listenerForm.setListenerClass(jobListener.getClass().getName());
                    viewForm.getJobListeners().add(listenerForm);
                }
            }
        }
        catch (SchedulerException e) {
            // empty catch block
        }
    }
}

