/*
 * Decompiled with CFR 0.152.
 */
package com.jware.base.boot;

import java.io.IOException;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EncodingFilter
implements Filter {
    private Log log = LogFactory.getLog((String)this.getClass().getName());
    private String encoding = null;
    private String[] exceptions = new String[0];

    public void init(FilterConfig config) throws ServletException {
        String tmp;
        this.encoding = config.getInitParameter("encoding");
        if (this.encoding.equalsIgnoreCase("shift-jis") || this.encoding.equalsIgnoreCase("sjis")) {
            this.encoding = "MS932";
        }
        if ((tmp = config.getInitParameter("exceptions")) != null) {
            this.exceptions = tmp.split(",");
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        String querystring = req.getRequestURI();
        String contextstring = req.getContextPath();
        if (contextstring != null && querystring != null) {
            querystring = querystring.substring(contextstring.length());
        }
        for (int i2 = 0; i2 < this.exceptions.length; ++i2) {
            String ptn = this.exceptions[i2];
            ptn = ptn.replaceAll("[.]", "[.]");
            Pattern urlPattern = Pattern.compile(ptn = ptn.replaceAll("[*]", ".*"));
            Matcher urlMatcher = urlPattern.matcher(querystring);
            if (!urlMatcher.matches()) continue;
            chain.doFilter(request, response);
            return;
        }
        String request_encoding = req.getCharacterEncoding();
        if (request_encoding == null || "".equals(request_encoding.trim())) {
            req.setCharacterEncoding(this.encoding);
        }
        String osname = System.getProperty("os.name");
        if ("GET".equalsIgnoreCase(req.getMethod())) {
            try {
                Enumeration values = req.getParameterNames();
                while (values.hasMoreElements()) {
                    String name = (String)values.nextElement();
                    String value = req.getParameterValues(name)[0];
                    req.getParameterValues((String)name)[0] = new String(value.getBytes("ISO-8859-1"), this.encoding);
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)("0. value=" + value));
                    this.log.debug((Object)("1. value=" + new String(value.getBytes("ISO-8859-1"), this.encoding)));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        chain.doFilter((ServletRequest)req, response);
    }

    public void destroy() {
        this.encoding = null;
    }
}

