/*
 * Decompiled with CFR 0.152.
 */
package com.jware.util.dbutils;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class DataModule {
    private static DataModule myDM;
    private String dbDriver = "oracle.jdbc.driver.OracleDriver";
    private String dbUrl = "jdbc:oracle:thin:@jrwin2000:1521:orcl";
    private String dbUsr = "mms";
    private String dbPas = "mms";
    private String dbCharset = "UFT8";

    public DataModule() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.loadDriver();
    }

    public static DataModule getDataModule() {
        if (myDM == null) {
            myDM = new DataModule();
        }
        return myDM;
    }

    private void loadDriver() {
        try {
            Class.forName(this.dbDriver);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public Connection getConnection() throws Exception {
        Connection conn = null;
        this.loadDriver();
        conn = DriverManager.getConnection(this.dbUrl, this.dbUsr, this.dbPas);
        return conn;
    }

    public Connection getConnection(String url, String user, String pass) throws Exception {
        Connection conn = null;
        this.loadDriver();
        conn = DriverManager.getConnection(url, user, pass);
        return conn;
    }

    public Connection getConnection(boolean autocommit, int level) throws Exception {
        Connection conn = null;
        this.loadDriver();
        try {
            conn = DriverManager.getConnection(this.dbUrl, this.dbUsr, this.dbPas);
            conn.setAutoCommit(autocommit);
            conn.setTransactionIsolation(level);
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
            throw e;
        }
        return conn;
    }

    public Connection getConnection(String url, String user, String pass, boolean autocommit, int level) throws Exception {
        Connection conn = null;
        this.loadDriver();
        try {
            conn = DriverManager.getConnection(url, user, pass);
            conn.setAutoCommit(autocommit);
            conn.setTransactionIsolation(level);
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
            throw e;
        }
        return conn;
    }

    public void closeConnection(Connection conn) throws Exception {
        conn.close();
    }

    public static DataModule getMyDM() {
        return myDM;
    }

    public static void setMyDM(DataModule myDM) {
        DataModule.myDM = myDM;
    }

    public String getDbCharset() {
        return this.dbCharset;
    }

    public void setDbCharset(String dbCharset) {
        this.dbCharset = dbCharset;
    }

    public String getDbDriver() {
        return this.dbDriver;
    }

    public void setDbDriver(String dbDriver) {
        this.dbDriver = dbDriver;
    }

    public String getDbPas() {
        return this.dbPas;
    }

    public void setDbPas(String dbPas) {
        this.dbPas = dbPas;
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public void setDbUrl(String dbUrl) {
        this.dbUrl = dbUrl;
    }

    public String getDbUsr() {
        return this.dbUsr;
    }

    public void setDbUsr(String dbUsr) {
        this.dbUsr = dbUsr;
    }
}

