/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.tags;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.LongRange;
import org.apache.commons.lang.math.Range;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.decorator.DecoratorFactory;
import org.displaytag.decorator.TableDecorator;
import org.displaytag.exception.DecoratorException;
import org.displaytag.exception.ExportException;
import org.displaytag.exception.FactoryInstantiationException;
import org.displaytag.exception.InvalidTagAttributeValueException;
import org.displaytag.exception.ObjectLookupException;
import org.displaytag.exception.WrappedRuntimeException;
import org.displaytag.export.BinaryExportView;
import org.displaytag.export.ExportView;
import org.displaytag.export.ExportViewFactory;
import org.displaytag.export.TextExportView;
import org.displaytag.model.Cell;
import org.displaytag.model.Column;
import org.displaytag.model.ColumnIterator;
import org.displaytag.model.HeaderCell;
import org.displaytag.model.Row;
import org.displaytag.model.RowIterator;
import org.displaytag.model.TableModel;
import org.displaytag.pagination.SmartListHelper;
import org.displaytag.properties.MediaTypeEnum;
import org.displaytag.properties.SortOrderEnum;
import org.displaytag.properties.TableProperties;
import org.displaytag.tags.HtmlTableTag;
import org.displaytag.util.Anchor;
import org.displaytag.util.CollectionUtil;
import org.displaytag.util.DependencyChecker;
import org.displaytag.util.Href;
import org.displaytag.util.ParamEncoder;
import org.displaytag.util.RequestHelper;
import org.displaytag.util.RequestHelperFactory;

public class TableTag
extends HtmlTableTag {
    public static final String PAGE_ATTRIBUTE_MEDIA = "mediaType";
    public static final String FILTER_CONTENT_OVERRIDE_BODY = "org.displaytag.filter.ResponseOverrideFilter.CONTENT_OVERRIDE_BODY";
    private static final long serialVersionUID = 899149338534L;
    private static Log log = LogFactory.getLog(TableTag.class);
    private static RequestHelperFactory rhf;
    protected Object list;
    protected Object listAttribute;
    private int rowNumber = 1;
    private String name;
    private String property;
    private String scope;
    private int length;
    private String decoratorName;
    private int pagesize;
    private boolean export;
    private int offset;
    private Boolean sortFullTable;
    private String requestUri;
    private boolean dontAppendContext;
    private int defaultSortedColumn = -1;
    private SortOrderEnum defaultSortOrder;
    private String excludedParams;
    private String uid;
    private Map previousRow;
    private TableModel tableModel;
    private Row currentRow;
    private Map nextRow;
    private SmartListHelper listHelper;
    private Href baseHref;
    private TableProperties properties;
    private int pageNumber = 1;
    private Iterator tableIterator;
    private MediaTypeEnum currentMediaType;
    private boolean doAfterBodyExecuted;
    private ParamEncoder paramEncoder;
    private String footer;
    private String caption;
    private Object filteredRows;

    public void setExcludedParams(String value) {
        this.excludedParams = value;
    }

    public void setFooter(String string) {
        this.footer = string;
    }

    public void setCaption(String string) {
        this.caption = string;
    }

    protected boolean isEmpty() {
        return this.currentRow == null;
    }

    public void setSort(String value) throws InvalidTagAttributeValueException {
        if ("page".equals(value)) {
            this.sortFullTable = Boolean.FALSE;
        } else if ("list".equals(value)) {
            this.sortFullTable = Boolean.TRUE;
        } else {
            throw new InvalidTagAttributeValueException(((Object)((Object)this)).getClass(), "sort", value);
        }
    }

    public void setRequestURI(String value) {
        this.requestUri = value;
    }

    public void setRequestURIcontext(boolean value) {
        this.dontAppendContext = !value;
    }

    public void setList(Object value) {
        this.listAttribute = value;
    }

    public void setName(Object value) {
        if (value instanceof String) {
            this.name = (String)value;
        } else {
            this.list = value;
        }
    }

    public void setNameString(String value) {
        this.name = value;
    }

    public void setProperty(String value) {
        this.property = value;
    }

    public void setDefaultorder(String value) throws InvalidTagAttributeValueException {
        this.defaultSortOrder = SortOrderEnum.fromName(value);
        if (this.defaultSortOrder == null) {
            throw new InvalidTagAttributeValueException(((Object)((Object)this)).getClass(), "defaultorder", value);
        }
    }

    public void setScope(String value) {
        this.scope = value;
    }

    public void setDecorator(String decorator) {
        this.decoratorName = decorator;
    }

    public void setExport(boolean value) {
        this.export = value;
    }

    public void setLength(int value) {
        this.length = value;
    }

    public void setDefaultsort(int value) {
        this.defaultSortedColumn = value - 1;
    }

    public void setPagesize(int value) {
        this.pagesize = value;
    }

    public void setOffset(int value) {
        this.offset = value < 1 ? 0 : value - 1;
    }

    public void setUid(String value) {
        if (this.getHtmlId() == null) {
            this.setHtmlId(value);
        }
        this.uid = value;
    }

    public String getUid() {
        return this.uid;
    }

    public PageContext getPageContext() {
        return this.pageContext;
    }

    protected TableProperties getProperties() {
        return this.properties;
    }

    protected Href getBaseHref() {
        return this.baseHref;
    }

    public void addColumn(HeaderCell column) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getUid() + "] addColumn " + column));
        }
        this.tableModel.addColumnHeader(column);
    }

    public void addCell(Cell cell) {
        if (this.currentRow != null) {
            this.currentRow.addCell(cell);
        }
    }

    protected boolean isFirstIteration() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getUid() + "] first iteration=" + (this.rowNumber == 1) + " (row number=" + this.rowNumber + ")"));
        }
        return this.rowNumber == 1;
    }

    public int doStartTag() throws JspException {
        DependencyChecker.check();
        ExportViewFactory.getInstance();
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getUid() + "] doStartTag called"));
        }
        this.properties = TableProperties.getInstance((HttpServletRequest)this.pageContext.getRequest());
        this.tableModel = new TableModel(this.properties, this.pageContext.getResponse().getCharacterEncoding());
        this.tableModel.setId(this.getUid());
        this.initParameters();
        Object previousMediaType = this.pageContext.getAttribute(PAGE_ATTRIBUTE_MEDIA);
        if (this.currentMediaType != null && (previousMediaType == null || MediaTypeEnum.HTML.equals(previousMediaType))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("[" + this.getUid() + "] setting media [" + this.currentMediaType + "] in this.pageContext"));
            }
            this.pageContext.setAttribute(PAGE_ATTRIBUTE_MEDIA, (Object)this.currentMediaType);
        }
        this.doIteration();
        return 2;
    }

    public int doAfterBody() {
        this.doAfterBodyExecuted = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getUid() + "] doAfterBody called - iterating on row " + this.rowNumber));
        }
        ++this.rowNumber;
        return this.doIteration();
    }

    protected int doIteration() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getUid() + "] doIteration called"));
        }
        if (this.currentRow != null) {
            this.tableModel.addRow(this.currentRow);
            this.currentRow = null;
        }
        if (this.tableIterator.hasNext()) {
            Object iteratedObject = this.tableIterator.next();
            if (this.getUid() != null) {
                if (iteratedObject != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("[" + this.getUid() + "] setting attribute \"" + this.getUid() + "\" in pageContext"));
                    }
                    this.pageContext.setAttribute(this.getUid(), iteratedObject);
                } else {
                    this.pageContext.removeAttribute(this.getUid());
                }
                this.pageContext.setAttribute(this.getUid() + "_rowNum", (Object)new Integer(this.rowNumber));
            }
            this.currentRow = new Row(iteratedObject, this.rowNumber);
            return 2;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getUid() + "] doIteration() - iterator ended after " + (this.rowNumber - 1) + " rows"));
        }
        return 0;
    }

    private void initParameters() throws ObjectLookupException, FactoryInstantiationException {
        boolean wishOptimizedIteration;
        String fullName;
        if (rhf == null) {
            rhf = this.properties.getRequestHelperFactoryInstance();
        }
        RequestHelper requestHelper = rhf.getRequestHelperInstance(this.pageContext);
        this.initHref(requestHelper);
        Integer pageNumberParameter = requestHelper.getIntParameter(this.encodeParameter("p"));
        this.pageNumber = pageNumberParameter == null ? 1 : pageNumberParameter;
        Integer sortColumnParameter = requestHelper.getIntParameter(this.encodeParameter("s"));
        int sortColumn = sortColumnParameter == null ? this.defaultSortedColumn : sortColumnParameter;
        this.tableModel.setSortedColumnNumber(sortColumn);
        boolean finalSortFull = this.properties.getSortFullList();
        if (this.sortFullTable != null) {
            finalSortFull = this.sortFullTable;
        }
        this.tableModel.setSortFullTable(finalSortFull);
        SortOrderEnum paramOrder = SortOrderEnum.fromCode(requestHelper.getIntParameter(this.encodeParameter("o")));
        if (paramOrder == null) {
            paramOrder = this.defaultSortOrder;
        }
        boolean order = SortOrderEnum.DESCENDING != paramOrder;
        this.tableModel.setSortOrderAscending(order);
        Integer exportTypeParameter = requestHelper.getIntParameter(this.encodeParameter("e"));
        this.currentMediaType = MediaTypeEnum.fromCode(exportTypeParameter);
        if (this.currentMediaType == null) {
            this.currentMediaType = MediaTypeEnum.HTML;
        }
        if ((fullName = this.getFullObjectName()) != null) {
            this.list = this.evaluateExpression(fullName);
        } else if (this.list == null) {
            this.list = this.listAttribute;
        }
        boolean bl = wishOptimizedIteration = this.pagesize > 0 || this.offset > 0 || this.length > 0;
        if (!(!wishOptimizedIteration || !(this.list instanceof Collection) || sortColumn != -1 && finalSortFull || this.currentMediaType != MediaTypeEnum.HTML && this.properties.getExportFullList())) {
            int start = 0;
            int end = 0;
            if (this.offset > 0) {
                start = this.offset;
            }
            if (this.length > 0) {
                end = start + this.length;
            }
            if (this.pagesize > 0) {
                start = (this.pageNumber - 1) * this.pagesize;
                int fullSize = ((Collection)this.list).size();
                if (start > fullSize) {
                    start = 0;
                }
                end = start + this.pagesize;
            }
            this.filteredRows = new LongRange(start + 1, end);
        } else {
            this.filteredRows = new LongRange(1L, Long.MAX_VALUE);
        }
        this.tableIterator = IteratorUtils.getIterator((Object)this.list);
    }

    protected boolean isIncludedRow() {
        return ((Range)this.filteredRows).containsLong(this.rowNumber);
    }

    private String getFullObjectName() {
        if (this.name == null) {
            return null;
        }
        StringBuffer fullName = new StringBuffer(30);
        if (StringUtils.isNotBlank(this.scope)) {
            fullName.append(this.scope).append("Scope.");
        }
        fullName.append(this.name);
        if (StringUtils.isNotBlank(this.property)) {
            fullName.append('.').append(this.property);
        }
        return fullName.toString();
    }

    protected void initHref(RequestHelper requestHelper) {
        Href normalHref = requestHelper.getHref();
        if (this.excludedParams != null) {
            String[] splittedExcludedParams = StringUtils.split(this.excludedParams);
            if (splittedExcludedParams.length == 1 && "*".equals(splittedExcludedParams[0])) {
                if (this.paramEncoder == null) {
                    this.paramEncoder = new ParamEncoder(this.getUid());
                }
                for (String key : normalHref.getParameterMap().keySet()) {
                    if (this.paramEncoder.isParameterEncoded(key)) continue;
                    normalHref.removeParameter(key);
                }
            } else {
                for (int j = 0; j < splittedExcludedParams.length; ++j) {
                    normalHref.removeParameter(splittedExcludedParams[j]);
                }
            }
        }
        if (this.requestUri != null) {
            String contextPath;
            String fullURI = this.requestUri;
            if (!this.dontAppendContext && !StringUtils.isEmpty(contextPath = ((HttpServletRequest)this.pageContext.getRequest()).getContextPath()) && this.requestUri != null && this.requestUri.startsWith("/") && !this.requestUri.startsWith(contextPath)) {
                fullURI = contextPath + this.requestUri;
            }
            fullURI = ((HttpServletResponse)this.pageContext.getResponse()).encodeURL(fullURI);
            this.baseHref = new Href(fullURI);
            Map parameterMap = normalHref.getParameterMap();
            this.baseHref.addParameterMap(parameterMap);
        } else {
            this.baseHref = normalHref;
        }
    }

    public int doEndTag() throws JspException {
        TableDecorator tableDecorator;
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getUid() + "] doEndTag called"));
        }
        if (!this.doAfterBodyExecuted) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("[" + this.getUid() + "] tag body is empty."));
            }
            if (this.currentRow != null) {
                this.tableModel.addRow(this.currentRow);
            }
            while (this.tableIterator.hasNext()) {
                Object iteratedObject = this.tableIterator.next();
                ++this.rowNumber;
                this.currentRow = new Row(iteratedObject, this.rowNumber);
                this.tableModel.addRow(this.currentRow);
            }
        }
        if (this.tableModel.isEmpty()) {
            this.describeEmptyTable();
        }
        if ((tableDecorator = DecoratorFactory.loadTableDecorator(this.decoratorName)) != null) {
            tableDecorator.init(this.pageContext, this.list);
            this.tableModel.setTableDecorator(tableDecorator);
        }
        this.setupViewableData();
        if (!this.tableModel.isSortFullTable()) {
            this.tableModel.sortPageList();
        }
        int returnValue = 6;
        Object previousMediaType = this.pageContext.getAttribute(PAGE_ATTRIBUTE_MEDIA);
        if (MediaTypeEnum.HTML.equals(this.currentMediaType) && (previousMediaType == null || MediaTypeEnum.HTML.equals(previousMediaType))) {
            this.writeHTMLData();
        } else if (!MediaTypeEnum.HTML.equals(this.currentMediaType)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("[" + this.getUid() + "] doEndTag - exporting"));
            }
            returnValue = this.doExport();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getUid() + "] doEndTag - end"));
        }
        this.cleanUp();
        return returnValue;
    }

    private void cleanUp() {
        this.currentMediaType = null;
        this.baseHref = null;
        this.caption = null;
        this.currentRow = null;
        this.doAfterBodyExecuted = false;
        this.footer = null;
        this.listHelper = null;
        this.nextRow = null;
        this.pageNumber = 0;
        this.paramEncoder = null;
        this.previousRow = null;
        this.properties = null;
        this.rowNumber = 1;
        this.tableIterator = null;
        this.tableModel = null;
        this.list = null;
    }

    private void describeEmptyTable() {
        this.tableIterator = IteratorUtils.getIterator((Object)this.list);
        if (this.tableIterator.hasNext()) {
            Object iteratedObject = this.tableIterator.next();
            Map objectProperties = new HashMap();
            if (iteratedObject instanceof String) {
                return;
            }
            if (iteratedObject instanceof Map) {
                objectProperties = (Map)iteratedObject;
            } else {
                try {
                    objectProperties = BeanUtils.describe(iteratedObject);
                }
                catch (Exception e) {
                    log.warn((Object)("Unable to automatically add columns: " + e.getMessage()), (Throwable)e);
                }
            }
            for (String propertyName : objectProperties.keySet()) {
                if ("class".equals(propertyName)) continue;
                HeaderCell headerCell = new HeaderCell();
                headerCell.setBeanPropertyName(propertyName);
                headerCell.setTitle(this.properties.geResourceProvider().getResource(null, propertyName, (Tag)this, this.pageContext));
                this.tableModel.addColumnHeader(headerCell);
            }
        }
    }

    protected int doExport() throws JspException {
        boolean exportFullList = this.properties.getExportFullList();
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getUid() + "] currentMediaType=" + this.currentMediaType));
        }
        boolean exportHeader = this.properties.getExportHeader(this.currentMediaType);
        boolean exportDecorated = this.properties.getExportDecorated();
        ExportView exportView = ExportViewFactory.getInstance().getView(this.currentMediaType, this.tableModel, exportFullList, exportHeader, exportDecorated);
        try {
            this.writeExport(exportView);
        }
        catch (IOException e) {
            throw new WrappedRuntimeException(((Object)((Object)this)).getClass(), (Throwable)e);
        }
        return 5;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void writeExport(ExportView exportView) throws IOException, JspException {
        String characterEncoding;
        String mimeType;
        boolean usingFilter;
        HttpServletResponse response;
        String filename;
        block11: {
            filename = this.properties.getExportFileName(this.currentMediaType);
            response = (HttpServletResponse)this.pageContext.getResponse();
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            Map bean = (Map)request.getAttribute(FILTER_CONTENT_OVERRIDE_BODY);
            usingFilter = bean != null;
            mimeType = exportView.getMimeType();
            characterEncoding = response.getCharacterEncoding();
            if (usingFilter) {
                if (!bean.containsKey("buffer")) {
                    log.debug((Object)"Exportfilter enabled in unbuffered mode, setting headers");
                    response.addHeader("6578706f7274", "");
                    break block11;
                } else {
                    bean.put("contenttype", mimeType);
                    bean.put("filename", filename);
                    if (exportView instanceof TextExportView) {
                        StringWriter writer = new StringWriter();
                        ((TextExportView)exportView).doExport(writer);
                        bean.put("body", writer.toString());
                        return;
                    }
                    if (!(exportView instanceof BinaryExportView)) throw new JspTagException("Export view " + exportView.getClass().getName() + " must implement TextExportView or BinaryExportView");
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    ((BinaryExportView)exportView).doExport(stream);
                    bean.put("body", stream.toByteArray());
                    return;
                }
            }
            log.debug((Object)"Exportfilter NOT enabled");
            if (response.isCommitted()) {
                throw new ExportException(((Object)((Object)this)).getClass());
            }
            try {
                response.reset();
                this.pageContext.getOut().clearBuffer();
            }
            catch (Exception e) {
                throw new ExportException(((Object)((Object)this)).getClass());
            }
        }
        if (!usingFilter && characterEncoding != null && mimeType.indexOf("charset") == -1) {
            mimeType = mimeType + "; charset=" + characterEncoding;
        }
        response.setContentType(mimeType);
        if (StringUtils.isNotEmpty(filename)) {
            response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
        }
        if (exportView instanceof TextExportView) {
            PrintWriter writer = usingFilter ? response.getWriter() : this.pageContext.getOut();
            ((TextExportView)exportView).doExport(writer);
        } else {
            if (!(exportView instanceof BinaryExportView)) throw new JspTagException("Export view " + exportView.getClass().getName() + " must implement TextExportView or BinaryExportView");
            ((BinaryExportView)exportView).doExport((OutputStream)response.getOutputStream());
        }
        log.debug((Object)"Export completed");
    }

    protected void setupViewableData() {
        if (this.tableModel.isSortFullTable()) {
            this.tableModel.sortFullList();
        }
        List originalData = this.tableModel.getRowListFull();
        List fullList = CollectionUtil.getListFromObject(originalData, this.offset, this.length);
        int pageOffset = this.offset;
        if (this.pagesize > 0) {
            this.listHelper = new SmartListHelper(fullList, fullList.size(), this.pagesize, this.properties);
            this.listHelper.setCurrentPage(this.pageNumber);
            pageOffset = this.listHelper.getFirstIndexForCurrentPage();
            fullList = this.listHelper.getListForCurrentPage();
        }
        this.tableModel.setRowListPage(fullList);
        this.tableModel.setPageOffset(pageOffset);
    }

    private void writeHTMLData() throws JspException {
        String css;
        boolean noItems;
        JspWriter out = this.pageContext.getOut();
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getUid() + "] getHTMLData called for table [" + this.getUid() + "]"));
        }
        boolean bl = noItems = this.tableModel.getRowListPage().size() == 0;
        if (noItems && !this.properties.getEmptyListShowTable()) {
            this.write(this.properties.getEmptyListMessage(), out);
            return;
        }
        this.previousRow = new Hashtable(10);
        this.nextRow = new Hashtable(10);
        if (this.properties.getAddPagingBannerTop()) {
            this.writeSearchResultAndNavigation();
        }
        if (StringUtils.isNotBlank(css = this.properties.getCssTable())) {
            this.addClass(css);
        }
        this.write(this.getOpenTag(), out);
        if (this.caption != null) {
            this.write(this.caption, out);
        }
        if (this.properties.getShowHeader()) {
            this.writeTableHeader();
        }
        if (this.footer != null) {
            this.write("\n<tfoot>", out);
            this.write(this.footer, out);
            this.write("</tfoot>", out);
            this.footer = null;
        }
        this.write("\n<tbody>", out);
        this.writeTableBody();
        this.write("</tbody>", out);
        this.write(this.getCloseTag(), out);
        this.writeTableFooter();
        if (this.tableModel.getTableDecorator() != null) {
            this.tableModel.getTableDecorator().finish();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getUid() + "] getHTMLData end"));
        }
    }

    private void writeTableHeader() {
        JspWriter out = this.pageContext.getOut();
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getUid() + "] getTableHeader called"));
        }
        this.write("\n<thead>", out);
        this.write("\n<tr>", out);
        if (this.tableModel.isEmpty()) {
            this.write("\n<th>", out);
            this.write("</th>", out);
        }
        for (HeaderCell headerCell : this.tableModel.getHeaderCellList()) {
            if (headerCell.getSortable()) {
                String cssSortable = this.properties.getCssSortable();
                headerCell.addHeaderClass(cssSortable);
            }
            if (headerCell.isAlreadySorted()) {
                headerCell.addHeaderClass(this.properties.getCssSorted());
                headerCell.addHeaderClass(this.properties.getCssOrder(this.tableModel.isSortOrderAscending()));
            }
            this.write(headerCell.getHeaderOpenTag(), out);
            String header = headerCell.getTitle();
            if (headerCell.getSortable()) {
                Anchor anchor = new Anchor(this.getSortingHref(headerCell), header);
                header = anchor.toString();
            }
            this.write(header, out);
            this.write(headerCell.getHeaderCloseTag(), out);
        }
        this.write("</tr>", out);
        this.write("</thead>", out);
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getUid() + "] getTableHeader end"));
        }
    }

    private Href getSortingHref(HeaderCell headerCell) {
        Href href = new Href(this.baseHref);
        href.addParameter(this.encodeParameter("s"), headerCell.getColumnNumber());
        boolean nowOrderAscending = !headerCell.isAlreadySorted() || !this.tableModel.isSortOrderAscending();
        int sortOrderParam = nowOrderAscending ? SortOrderEnum.ASCENDING.getCode() : SortOrderEnum.DESCENDING.getCode();
        href.addParameter(this.encodeParameter("o"), sortOrderParam);
        if (this.tableModel.isSortFullTable()) {
            href.addParameter(this.encodeParameter("p"), 1);
        }
        return href;
    }

    private String groupColumns(String value, int group) {
        if (group == 1 && this.nextRow.size() > 0) {
            this.previousRow.clear();
            this.previousRow.putAll(this.nextRow);
            this.nextRow.clear();
        }
        if (!this.nextRow.containsKey(new Integer(group))) {
            this.nextRow.put(new Integer(group), value);
        }
        if (this.previousRow.containsKey(new Integer(group))) {
            for (int j = 1; j <= group; ++j) {
                if (((String)this.previousRow.get(new Integer(j))).equals(this.nextRow.get(new Integer(j)))) continue;
                return value;
            }
        }
        if (this.previousRow.size() == 0) {
            return value;
        }
        return "";
    }

    private void writeTableBody() throws ObjectLookupException, DecoratorException {
        JspWriter out = this.pageContext.getOut();
        RowIterator rowIterator = this.tableModel.getRowIterator(false);
        while (rowIterator.hasNext()) {
            String endRow;
            String stringStartRow;
            Row row = rowIterator.next();
            if (log.isDebugEnabled()) {
                log.debug((Object)("[" + this.getUid() + "] rowIterator.next()=" + row));
            }
            if (this.tableModel.getTableDecorator() != null && (stringStartRow = this.tableModel.getTableDecorator().startRow()) != null) {
                this.write(stringStartRow, out);
            }
            this.write(row.getOpenTag(), out);
            if (log.isDebugEnabled()) {
                log.debug((Object)("[" + this.getUid() + "] creating ColumnIterator on " + this.tableModel.getHeaderCellList()));
            }
            ColumnIterator columnIterator = row.getColumnIterator(this.tableModel.getHeaderCellList());
            while (columnIterator.hasNext()) {
                Column column = columnIterator.nextColumn();
                this.write(column.getOpenTag(), out);
                String value = column.getChoppedAndLinkedValue();
                if (column.getGroup() != -1) {
                    value = this.groupColumns(value, column.getGroup());
                }
                this.write(value, out);
                this.write(column.getCloseTag(), out);
            }
            if (this.tableModel.isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("[" + this.getUid() + "] table has no columns"));
                }
                this.write("\n<td>", out);
                this.write(row.getObject().toString(), out);
                this.write("</td>", out);
            }
            this.write(row.getCloseTag(), out);
            if (this.tableModel.getTableDecorator() == null || (endRow = this.tableModel.getTableDecorator().finishRow()) == null) continue;
            this.write(endRow, out);
        }
        if (this.tableModel.getRowListPage().size() == 0) {
            this.write(MessageFormat.format(this.properties.getEmptyListRowMessage(), new Integer(this.tableModel.getNumberOfColumns())), out);
        }
    }

    private void writeTableFooter() {
        if (this.properties.getAddPagingBannerBottom()) {
            this.writeSearchResultAndNavigation();
        }
        if (this.export && this.tableModel.getRowListPage().size() != 0) {
            this.writeExportLinks();
        }
    }

    private void writeSearchResultAndNavigation() {
        if (this.pagesize != 0 && this.listHelper != null) {
            Href navigationHref = new Href(this.baseHref);
            this.write(this.listHelper.getSearchResultsSummary());
            this.write(this.listHelper.getPageNavigationBar(navigationHref, this.encodeParameter("p")));
        }
    }

    private void writeExportLinks() {
        Href exportHref = new Href(this.baseHref);
        StringBuffer buffer = new StringBuffer(200);
        Iterator iterator = MediaTypeEnum.iterator();
        while (iterator.hasNext()) {
            MediaTypeEnum currentExportType = (MediaTypeEnum)iterator.next();
            if (!this.properties.getAddExport(currentExportType)) continue;
            if (buffer.length() > 0) {
                buffer.append(this.properties.getExportBannerSeparator());
            }
            exportHref.addParameter(this.encodeParameter("e"), currentExportType.getCode());
            exportHref.addParameter("6578706f7274", "1");
            Anchor anchor = new Anchor(exportHref, this.properties.getExportLabel(currentExportType));
            buffer.append(anchor.toString());
        }
        Object[] exportOptions = new String[]{buffer.toString()};
        this.write(MessageFormat.format(this.properties.getExportBanner(), exportOptions));
    }

    public void setProperty(String propertyName, String propertyValue) {
        this.properties.setProperty(propertyName, propertyValue);
    }

    public void release() {
        super.release();
        this.decoratorName = null;
        this.defaultSortedColumn = -1;
        this.defaultSortOrder = null;
        this.export = false;
        this.length = 0;
        this.listAttribute = null;
        this.name = null;
        this.offset = 0;
        this.pagesize = 0;
        this.property = null;
        this.requestUri = null;
        this.dontAppendContext = false;
        this.scope = null;
        this.sortFullTable = null;
        this.excludedParams = null;
        this.filteredRows = null;
        this.uid = null;
    }

    public String getName() {
        return this.name;
    }

    private String encodeParameter(String parameterName) {
        if (this.paramEncoder == null) {
            this.paramEncoder = new ParamEncoder(this.getUid());
        }
        return this.paramEncoder.encodeParameterName(parameterName);
    }
}

