/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DataTypeFilteringDTVImpl;
import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.microsoft.sqlserver.jdbc.SQLServerStatement;
import java.sql.ParameterMetaData;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.Format;
import java.text.MessageFormat;
import java.util.StringTokenizer;

public final class SQLServerParameterMetaData
implements ParameterMetaData {
    private SQLServerStatement stmtParent;
    private SQLServerConnection con;
    private Statement stmtRegular;
    private ResultSetMetaData md;
    private Statement stmtCall;
    private SQLServerResultSet rsProcedureMeta;
    private String sMetaTable;
    private String sMetaFields;

    void parseColumns(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " =?<>!", true);
        int n = 0;
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string4;
            String string5 = stringTokenizer.nextToken();
            if (string5.equalsIgnoreCase(string2)) {
                n = 1;
                continue;
            }
            if (n == 0) continue;
            if (string5.charAt(0) == '=' || string5.equalsIgnoreCase("is") || string5.charAt(0) == '<' || string5.charAt(0) == '>' || string5.equalsIgnoreCase("like") || string5.equalsIgnoreCase("not") || string5.equalsIgnoreCase("in") || string5.charAt(0) == '!') {
                n = 2;
                continue;
            }
            if (string5.charAt(0) == '?' && string3 != null) {
                this.sMetaFields = this.sMetaFields == null ? "" : this.sMetaFields + ", ";
                this.sMetaFields = this.sMetaFields + string3;
                n = 1;
                string3 = null;
                continue;
            }
            if (n != 1 || string5.equals(" ") || (string4 = this.escapeParse(stringTokenizer, string5)).length() <= 0) continue;
            string3 = string4;
        }
    }

    String getTableName() {
        return this.sMetaTable;
    }

    void parseInsertColumns(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " (),", true);
        int n = 0;
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.equalsIgnoreCase(string2)) {
                n = 1;
                continue;
            }
            if (n == 0) continue;
            if (string4.charAt(0) == '=') {
                n = 2;
                continue;
            }
            if ((string4.charAt(0) == ',' || string4.charAt(0) == ')' || string4.charAt(0) == ' ') && string3 != null) {
                this.sMetaFields = this.sMetaFields == null ? "" : this.sMetaFields + ", ";
                this.sMetaFields = this.sMetaFields + string3;
                n = 1;
                string3 = null;
            }
            if (string4.charAt(0) == ')') {
                n = 0;
                break;
            }
            if (n != 1 || string4.trim().length() <= 0 || string4.charAt(0) == ',') continue;
            string3 = this.escapeParse(stringTokenizer, string4);
        }
    }

    private String escapeParse(StringTokenizer stringTokenizer, String string) {
        String string2 = string;
        while (string2.equals(" ") && stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        String string3 = string2;
        if (string2.charAt(0) == '[' && string2.charAt(string2.length() - 1) != ']') {
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                string3 = string3.concat(string2);
                if (string2.charAt(string2.length() - 1) != ']') continue;
            }
        }
        string3 = string3.trim();
        return string3;
    }

    private void parseStatement(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            if (!string3.equalsIgnoreCase(string2) || !stringTokenizer.hasMoreTokens()) continue;
            this.sMetaTable = this.escapeParse(stringTokenizer, stringTokenizer.nextToken());
            break;
        }
        if (this.sMetaTable == null) {
            return;
        }
        if (string2.equalsIgnoreCase("UPDATE")) {
            this.parseColumns(string, "SET");
        } else if (string2.equalsIgnoreCase("INTO")) {
            this.parseInsertColumns(string, "(");
        } else {
            this.parseColumns(string, "WHERE");
        }
    }

    private void parseStatement(String string) throws SQLServerException {
        this.sMetaFields = null;
        this.sMetaTable = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (!stringTokenizer.hasMoreTokens()) {
            return;
        }
        String string2 = stringTokenizer.nextToken().trim();
        if (string2.equalsIgnoreCase("INSERT")) {
            this.parseStatement(string, "INTO");
        }
        if (string2.equalsIgnoreCase("UPDATE")) {
            this.parseStatement(string, "UPDATE");
        }
        if (string2.equalsIgnoreCase("SELECT")) {
            this.parseStatement(string, "FROM");
        }
        if (string2.equalsIgnoreCase("DELETE")) {
            this.parseStatement(string, "FROM");
        }
    }

    String parseThreePartNames(String string) throws SQLServerException {
        CharSequence charSequence;
        int n = 0;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
        block10: while (stringTokenizer.hasMoreTokens()) {
            charSequence = stringTokenizer.nextToken();
            String string5 = this.escapeParse(stringTokenizer, (String)charSequence);
            if (string5.equals(".")) continue;
            switch (n) {
                case 2: {
                    string4 = string3;
                }
                case 1: {
                    string3 = string2;
                }
                case 0: {
                    string2 = string5;
                    ++n;
                    continue block10;
                }
            }
            ++n;
        }
        charSequence = new StringBuffer(100);
        if (n > 3 && 1 < n) {
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, SQLServerException.getErrString("R_noMetadata"), null, false);
        }
        switch (n) {
            case 3: {
                ((StringBuffer)charSequence).append("@procedure_qualifier =");
                ((StringBuffer)charSequence).append(string4);
                ((StringBuffer)charSequence).append(", ");
            }
            case 2: {
                ((StringBuffer)charSequence).append("@procedure_owner =");
                ((StringBuffer)charSequence).append(string3);
                ((StringBuffer)charSequence).append(", ");
            }
            case 1: {
                ((StringBuffer)charSequence).append("@procedure_name =");
                ((StringBuffer)charSequence).append(string2);
                ((StringBuffer)charSequence).append(", ");
            }
        }
        return ((StringBuffer)charSequence).toString();
    }

    SQLServerParameterMetaData(SQLServerStatement sQLServerStatement, String string) throws SQLServerException {
        this.stmtParent = sQLServerStatement;
        this.con = (SQLServerConnection)sQLServerStatement.getConnection();
        try {
            if (null != sQLServerStatement.procedureName) {
                SQLServerStatement sQLServerStatement2 = this.con.createInternalStatement();
                String string2 = this.parseThreePartNames(sQLServerStatement.procedureName);
                this.rsProcedureMeta = (SQLServerResultSet)sQLServerStatement2.executeQuery("exec sp_sproc_columns " + string2 + " @ODBCVer=3");
                this.rsProcedureMeta.getColumn(6).setFilter(new DataTypeFilteringDTVImpl());
            } else {
                Object object;
                Object object2;
                this.parseStatement(string);
                if (this.sMetaTable == null) {
                    object2 = new MessageFormat(SQLServerException.getErrString("R_cantIdentifyTableMetadata"));
                    object = new Object[]{new String(string)};
                    SQLServerException.makeFromDriverError(this.con, this.stmtParent, ((Format)object2).format(object), null, false);
                }
                if (this.sMetaFields == null) {
                    return;
                }
                this.stmtRegular = this.con.createInternalStatement();
                object2 = "SET FMTONLY ON SELECT " + this.sMetaFields + " FROM " + this.sMetaTable + " SET FMTONLY OFF";
                object = this.stmtRegular.executeQuery((String)object2);
                this.md = object.getMetaData();
            }
        }
        catch (SQLException sQLException) {
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, sQLException.toString(), null, false);
        }
    }

    private void verifyParameterPosition(int n) throws SQLServerException {
        Object[] objectArray;
        boolean bl = false;
        try {
            bl = this.rsProcedureMeta.absolute(n + 1);
        }
        catch (SQLException sQLException) {
            objectArray = new MessageFormat(SQLServerException.getErrString("R_metaDataErrorForParameter"));
            Object[] objectArray2 = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, objectArray.format(objectArray2) + " " + sQLException.toString(), null, false);
        }
        if (!bl) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidParameterNumber"));
            objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, messageFormat.format(objectArray), null, false);
        }
    }

    private void checkParam(int n) throws SQLServerException {
        if (this.md == null) {
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, SQLServerException.getErrString("R_noMetadata"), null, false);
        }
    }

    public String getParameterClassName(int n) throws SQLServerException {
        try {
            if (this.rsProcedureMeta == null) {
                this.checkParam(n);
                return this.md.getColumnClassName(n);
            }
            this.verifyParameterPosition(n);
            short s = this.rsProcedureMeta.getShort("DATA_TYPE");
            return DataTypes.classNameFromJDBCType(s);
        }
        catch (SQLException sQLException) {
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, sQLException.toString(), null, false);
            return null;
        }
    }

    public int getParameterCount() throws SQLServerException {
        try {
            if (this.rsProcedureMeta == null) {
                if (this.md == null) {
                    return 0;
                }
                return this.md.getColumnCount();
            }
            this.rsProcedureMeta.last();
            int n = this.rsProcedureMeta.getRow() - 1;
            if (n < 0) {
                n = 0;
            }
            return n;
        }
        catch (SQLException sQLException) {
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, sQLException.toString(), null, false);
            return 0;
        }
    }

    public int getParameterMode(int n) throws SQLServerException {
        try {
            if (this.rsProcedureMeta == null) {
                this.checkParam(n);
                return 1;
            }
            this.verifyParameterPosition(n);
            int n2 = this.rsProcedureMeta.getInt("COLUMN_TYPE");
            switch (n2) {
                case 1: {
                    return 1;
                }
                case 2: {
                    return 4;
                }
            }
            return 0;
        }
        catch (SQLException sQLException) {
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, sQLException.toString(), null, false);
            return 0;
        }
    }

    public int getParameterType(int n) throws SQLServerException {
        try {
            if (this.rsProcedureMeta == null) {
                this.checkParam(n);
                return this.md.getColumnType(n);
            }
            this.verifyParameterPosition(n);
            short s = this.rsProcedureMeta.getShort("DATA_TYPE");
            return s;
        }
        catch (SQLException sQLException) {
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, sQLException.toString(), null, false);
            return 0;
        }
    }

    public String getParameterTypeName(int n) throws SQLServerException {
        try {
            if (this.rsProcedureMeta == null) {
                this.checkParam(n);
                return this.md.getColumnTypeName(n);
            }
            this.verifyParameterPosition(n);
            return this.rsProcedureMeta.getString("TYPE_NAME");
        }
        catch (SQLException sQLException) {
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, sQLException.toString(), null, false);
            return null;
        }
    }

    public int getPrecision(int n) throws SQLServerException {
        try {
            if (this.rsProcedureMeta == null) {
                this.checkParam(n);
                return this.md.getPrecision(n);
            }
            this.verifyParameterPosition(n);
            int n2 = this.rsProcedureMeta.getInt("PRECISION");
            return n2;
        }
        catch (SQLException sQLException) {
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, sQLException.toString(), null, false);
            return 0;
        }
    }

    public int getScale(int n) throws SQLServerException {
        try {
            if (this.rsProcedureMeta == null) {
                this.checkParam(n);
                return this.md.getScale(n);
            }
            this.verifyParameterPosition(n);
            int n2 = this.rsProcedureMeta.getInt("SCALE");
            return n2;
        }
        catch (SQLException sQLException) {
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, sQLException.toString(), null, false);
            return 0;
        }
    }

    public int isNullable(int n) throws SQLServerException {
        try {
            if (this.rsProcedureMeta == null) {
                this.checkParam(n);
                return this.md.isNullable(n);
            }
            this.verifyParameterPosition(n);
            int n2 = this.rsProcedureMeta.getInt("NULLABLE");
            if (n2 == 1) {
                return 1;
            }
            if (n2 == 0) {
                return 0;
            }
            return 2;
        }
        catch (SQLException sQLException) {
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, sQLException.toString(), null, false);
            return 0;
        }
    }

    public boolean isSigned(int n) throws SQLServerException {
        try {
            if (this.rsProcedureMeta == null) {
                this.checkParam(n);
                return this.md.isSigned(n);
            }
            this.verifyParameterPosition(n);
            short s = this.rsProcedureMeta.getShort("DATA_TYPE");
            int n2 = DataTypes.dataTypeFromJDBCType(s);
            return DataTypes.isSigned(n2);
        }
        catch (SQLException sQLException) {
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, sQLException.toString(), null, false);
            return false;
        }
    }
}

