/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.fmt;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;
import org.apache.taglibs.standard.resources.Resources;
import org.apache.taglibs.standard.tag.common.core.Util;
import org.apache.taglibs.standard.tag.common.fmt.SetLocaleSupport;

public abstract class ParseNumberSupport
extends BodyTagSupport {
    private static final String NUMBER = "number";
    private static final String CURRENCY = "currency";
    private static final String PERCENT = "percent";
    protected String value;
    protected boolean valueSpecified;
    protected String type;
    protected String pattern;
    protected Locale parseLocale;
    protected boolean isIntegerOnly;
    protected boolean integerOnlySpecified;
    private String var;
    private int scope;

    public ParseNumberSupport() {
        this.init();
    }

    private void init() {
        this.var = null;
        this.pattern = null;
        this.type = null;
        this.value = null;
        this.valueSpecified = false;
        this.parseLocale = null;
        this.integerOnlySpecified = false;
        this.scope = 1;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setScope(String scope) {
        this.scope = Util.getScope(scope);
    }

    public int doEndTag() throws JspException {
        String input = null;
        if (this.valueSpecified) {
            input = this.value;
        } else if (this.bodyContent != null && this.bodyContent.getString() != null) {
            input = this.bodyContent.getString().trim();
        }
        if (input == null || input.equals("")) {
            if (this.var != null) {
                this.pageContext.removeAttribute(this.var, this.scope);
            }
            return 6;
        }
        Locale loc = this.parseLocale;
        if (loc == null) {
            loc = SetLocaleSupport.getFormattingLocale(this.pageContext, (Tag)this, false, NumberFormat.getAvailableLocales());
        }
        if (loc == null) {
            throw new JspException(Resources.getMessage("PARSE_NUMBER_NO_PARSE_LOCALE"));
        }
        NumberFormat parser = null;
        if (this.pattern != null && !this.pattern.equals("")) {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(loc);
            parser = new DecimalFormat(this.pattern, symbols);
        } else {
            parser = this.createParser(loc);
        }
        if (this.integerOnlySpecified) {
            parser.setParseIntegerOnly(this.isIntegerOnly);
        }
        Number parsed = null;
        try {
            parsed = parser.parse(input);
        }
        catch (ParseException pe) {
            throw new JspException(Resources.getMessage("PARSE_NUMBER_PARSE_ERROR", input), (Throwable)pe);
        }
        if (this.var != null) {
            this.pageContext.setAttribute(this.var, (Object)parsed, this.scope);
        } else {
            try {
                this.pageContext.getOut().print((Object)parsed);
            }
            catch (IOException ioe) {
                throw new JspTagException(ioe.getMessage());
            }
        }
        return 6;
    }

    public void release() {
        this.init();
    }

    private NumberFormat createParser(Locale loc) throws JspException {
        NumberFormat parser = null;
        if (this.type == null || NUMBER.equalsIgnoreCase(this.type)) {
            parser = NumberFormat.getNumberInstance(loc);
        } else if (CURRENCY.equalsIgnoreCase(this.type)) {
            parser = NumberFormat.getCurrencyInstance(loc);
        } else if (PERCENT.equalsIgnoreCase(this.type)) {
            parser = NumberFormat.getPercentInstance(loc);
        } else {
            throw new JspException(Resources.getMessage("PARSE_NUMBER_INVALID_TYPE", this.type));
        }
        return parser;
    }
}

