/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.resources.file.web;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.ServletContext;
import org.apache.commons.resources.ResourcesException;
import org.apache.commons.resources.file.FileResources;
import org.apache.commons.resources.web.WebappResources;

public class WebappFileResources
extends FileResources
implements WebappResources {
    protected ServletContext servletContext;

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    protected InputStream toStream(String streamPath) throws ResourcesException {
        return this.servletContext.getResourceAsStream(streamPath);
    }

    protected String findValidPath(String key, Locale locale, TimeZone timeZone) {
        int eIndex;
        String language = null;
        String countryCode = null;
        String zoneID = null;
        String extension = null;
        if (locale != null) {
            language = locale.getLanguage();
            countryCode = locale.getCountry();
        }
        if (timeZone != null) {
            zoneID = timeZone.getID();
        }
        if ((eIndex = key.lastIndexOf(".")) != -1) {
            extension = key.substring(eIndex + 1, key.length());
            key = key.substring(0, eIndex);
        }
        String[] paths = this.getFileNames(key, language, countryCode, zoneID, extension, '/');
        try {
            int i = 0;
            while (i < paths.length) {
                URL resource = this.servletContext.getResource(paths[i]);
                if (resource != null) {
                    return paths[i];
                }
                ++i;
            }
        }
        catch (MalformedURLException mue) {
            // empty catch block
        }
        return null;
    }

    protected long getFileSize(String filePath) {
        File file;
        String realPath = this.servletContext.getRealPath(filePath);
        if (realPath != null && (file = new File(realPath)).exists()) {
            return file.length();
        }
        return -1L;
    }
}

