/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.resources.web;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import javax.servlet.ServletContext;
import org.apache.commons.resources.Resources;
import org.apache.commons.resources.ResourcesException;
import org.apache.commons.resources.ResourcesManager;
import org.apache.commons.resources.web.WebappResources;

public class WebappResourcesManager
extends ResourcesManager {
    protected ServletContext context;

    public WebappResourcesManager(URL config, ServletContext context) throws ResourcesException, IOException {
        super(config, false);
        this.context = context;
        this.initResources();
    }

    public WebappResourcesManager(String webappResource, ServletContext context) throws ResourcesException, IOException {
        super(context.getResourceAsStream(webappResource), false);
        this.context = context;
        this.initResources();
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    protected void initResources() throws ResourcesException {
        Collection resourceCollection = this.resources.values();
        Iterator iterator = resourceCollection.iterator();
        while (iterator.hasNext()) {
            Resources resource = (Resources)iterator.next();
            if (resource instanceof WebappResources) {
                ((WebappResources)resource).setServletContext(this.context);
            }
            resource.init();
        }
    }
}

