/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpConstants;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpParser;

public class ChunkedInputStream
extends InputStream {
    private InputStream in;
    private int chunkSize;
    private int pos;
    private boolean bof = true;
    private boolean eof = false;
    private boolean closed = false;
    private HttpMethod method;

    public ChunkedInputStream(InputStream in, HttpMethod method) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("InputStream parameter may not be null");
        }
        if (method == null) {
            throw new IllegalArgumentException("HttpMethod parameter may not be null");
        }
        this.in = in;
        this.method = method;
        this.pos = 0;
    }

    public void close() throws IOException {
        if (!this.closed) {
            block3: {
                try {
                    if (this.eof) break block3;
                    ChunkedInputStream.exhaustInputStream(this);
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this.eof = true;
                    this.closed = true;
                    throw throwable;
                }
            }
            Object var2_1 = null;
            this.eof = true;
            this.closed = true;
        }
    }

    static void exhaustInputStream(InputStream inStream) throws IOException {
        byte[] buffer = new byte[1024];
        while (inStream.read(buffer) >= 0) {
        }
    }

    private static int getChunkSizeFromInputStream(InputStream in) throws IOException {
        int result;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int state = 0;
        while (state != -1) {
            int b = in.read();
            if (b == -1) {
                throw new IOException("chunked stream ended unexpectedly");
            }
            block1 : switch (state) {
                case 0: {
                    switch (b) {
                        case 13: {
                            state = 1;
                            break block1;
                        }
                        case 34: {
                            state = 2;
                        }
                    }
                    baos.write(b);
                    break;
                }
                case 1: {
                    if (b == 10) {
                        state = -1;
                        break;
                    }
                    throw new IOException("Protocol violation: Unexpected single newline character in chunk size");
                }
                case 2: {
                    switch (b) {
                        case 92: {
                            b = in.read();
                            baos.write(b);
                            break block1;
                        }
                        case 34: {
                            state = 0;
                        }
                    }
                    baos.write(b);
                    break;
                }
                default: {
                    throw new RuntimeException("assertion failed");
                }
            }
        }
        String dataString = HttpConstants.getString(baos.toByteArray());
        int separator = dataString.indexOf(59);
        dataString = separator > 0 ? dataString.substring(0, separator).trim() : dataString.trim();
        try {
            result = Integer.parseInt(dataString.trim(), 16);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Bad chunk size: " + dataString);
        }
        return result;
    }

    private void nextChunk() throws IOException {
        if (!this.bof) {
            this.readCRLF();
        }
        this.chunkSize = ChunkedInputStream.getChunkSizeFromInputStream(this.in);
        this.bof = false;
        this.pos = 0;
        if (this.chunkSize == 0) {
            this.eof = true;
            this.parseTrailerHeaders();
        }
    }

    private void parseTrailerHeaders() throws IOException {
        Header[] footers = HttpParser.parseHeaders(this.in);
        int i = 0;
        while (i < footers.length) {
            this.method.addResponseFooter(footers[i]);
            ++i;
        }
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.eof) {
            return -1;
        }
        if (this.pos >= this.chunkSize) {
            this.nextChunk();
            if (this.eof) {
                return -1;
            }
        }
        ++this.pos;
        return this.in.read();
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.eof) {
            return -1;
        }
        if (this.pos >= this.chunkSize) {
            this.nextChunk();
            if (this.eof) {
                return -1;
            }
        }
        len = Math.min(len, this.chunkSize - this.pos);
        int count = this.in.read(b, off, len);
        this.pos += count;
        return count;
    }

    private void readCRLF() throws IOException {
        int cr = this.in.read();
        int lf = this.in.read();
        if (cr != 13 || lf != 10) {
            throw new IOException("CRLF expected at end of chunk: " + cr + "/" + lf);
        }
    }
}

