/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.util.HashMap;
import java.util.Vector;
import javax.print.attribute.Attribute;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;

public class CMediaSize
extends MediaSize
implements Attribute {
    private static final long serialVersionUID = -1967958664615414771L;
    private MediaSizeName mediaName;
    private static HashMap mediaMap = new HashMap(100, 10.0f);
    private static Vector sizeVector = new Vector(100, 10);
    private boolean reversed = false;

    public CMediaSize(float x, float y, int units) {
        super(x, y, units);
        sizeVector.add(this);
    }

    public CMediaSize(float x, float y, int units, boolean reverse) {
        super(y, x, units);
        this.reversed = true;
        sizeVector.add(this);
    }

    public CMediaSize(int x, int y, int units) {
        super(x, y, units);
        sizeVector.add(this);
    }

    public CMediaSize(int x, int y, int units, boolean reverse) {
        super(y, x, units);
        this.reversed = true;
        sizeVector.add(this);
    }

    public CMediaSize(float x, float y, int units, MediaSizeName media) {
        super(x, y, units);
        this.mediaName = media;
        mediaMap.put(this.mediaName, this);
        sizeVector.add(this);
    }

    public CMediaSize(float x, float y, int units, MediaSizeName media, boolean reverse) {
        super(y, x, units);
        this.reversed = true;
        this.mediaName = media;
        mediaMap.put(this.mediaName, this);
        sizeVector.add(this);
    }

    public CMediaSize(int x, int y, int units, MediaSizeName media) {
        super(x, y, units);
        this.mediaName = media;
        mediaMap.put(this.mediaName, this);
        sizeVector.add(this);
    }

    public CMediaSize(int x, int y, int units, MediaSizeName media, boolean reverse) {
        super(y, x, units);
        this.reversed = true;
        this.mediaName = media;
        mediaMap.put(this.mediaName, this);
        sizeVector.add(this);
    }

    public MediaSizeName getMediaSizeName() {
        return this.mediaName;
    }

    public static MediaSize getMediaSizeForName(MediaSizeName media) {
        return (MediaSize)mediaMap.get(media);
    }

    public static MediaSizeName findMedia(float x, float y, int units) {
        MediaSize match = MediaSize.ISO.A4;
        if (x <= 0.0f || y <= 0.0f || units < 1) {
            throw new IllegalArgumentException("args must be +ve values");
        }
        double ls = x * x + y * y;
        float diffx = x;
        float diffy = y;
        for (int i = 0; i < sizeVector.size(); ++i) {
            MediaSize mediaSize = (MediaSize)sizeVector.elementAt(i);
            float[] dim = mediaSize.getSize(units);
            if (x == dim[0] && y == dim[1]) {
                match = mediaSize;
                break;
            }
            diffx = x - dim[0];
            diffy = y - dim[1];
            double tmp_ls = diffx * diffx + diffy * diffy;
            if (!(tmp_ls < ls)) continue;
            ls = tmp_ls;
            match = mediaSize;
        }
        return match.getMediaSizeName();
    }

    public boolean equals(Object object) {
        return super.equals(object) && object instanceof MediaSize;
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public float getX(int units) {
        if (this.reversed) {
            return super.getY(units);
        }
        return super.getX(units);
    }

    public float getY(int units) {
        if (this.reversed) {
            return super.getX(units);
        }
        return super.getY(units);
    }

    static {
        MediaSize ISOA4 = MediaSize.ISO.A4;
        MediaSize JISB5 = MediaSize.JIS.B5;
        MediaSize NALETTER = MediaSize.NA.LETTER;
        MediaSize EngineeringC = MediaSize.Engineering.C;
        MediaSize OtherEXECUTIVE = MediaSize.Other.EXECUTIVE;
    }
}

