/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import org.compiere.print.PrintDataFunction;

public class PrintDataGroup {
    public static final String DELIMITER = "~";
    public static final String TOTAL = "=TOTAL=";
    private static final Object NULL = new String();
    private ArrayList<String> m_groups = new ArrayList();
    private HashMap<String, Object> m_groupMap = new HashMap();
    private ArrayList<String> m_functions = new ArrayList();
    private HashMap<String, PrintDataFunction> m_groupFunction = new HashMap();

    public void addGroupColumn(String groupColumnName) {
        this.m_groups.add(groupColumnName);
    }

    public int getGroupColumnCount() {
        return this.m_groups.size();
    }

    public boolean isGroupColumn(String columnName) {
        if (columnName == null || this.m_groups.size() == 0) {
            return false;
        }
        for (int i = 0; i < this.m_groups.size(); ++i) {
            if (!columnName.equals(this.m_groups.get(i))) continue;
            return true;
        }
        return false;
    }

    public Object groupChange(String groupColumnName, Object value) {
        if (!this.isGroupColumn(groupColumnName)) {
            return null;
        }
        Object newValue = value;
        if (newValue == null) {
            newValue = NULL;
        }
        if (this.m_groupMap.containsKey(groupColumnName)) {
            Object oldValue = this.m_groupMap.get(groupColumnName);
            if (newValue.equals(oldValue)) {
                return null;
            }
            this.m_groupMap.put(groupColumnName, newValue);
            return oldValue;
        }
        this.m_groupMap.put(groupColumnName, newValue);
        return null;
    }

    public void addFunction(String functionColumnName, char function) {
        this.m_functions.add(functionColumnName + DELIMITER + function);
        if (!this.m_groups.contains(TOTAL)) {
            this.m_groups.add(TOTAL);
        }
    }

    public boolean isFunctionColumn(String columnName) {
        if (columnName == null || this.m_functions.size() == 0) {
            return false;
        }
        for (int i = 0; i < this.m_functions.size(); ++i) {
            String f = this.m_functions.get(i);
            if (!f.startsWith(columnName)) continue;
            return true;
        }
        return false;
    }

    public char[] getFunctions(String columnName) {
        int i;
        ArrayList<String> list = new ArrayList<String>();
        for (String group_function : this.m_groupFunction.keySet()) {
            if (!group_function.startsWith(columnName)) continue;
            group_function = group_function.substring(group_function.lastIndexOf(DELIMITER) + 1);
            for (i = 0; i < this.m_functions.size(); ++i) {
                String function;
                String col_function = this.m_functions.get(i);
                if (!col_function.startsWith(group_function) || list.contains(function = col_function.substring(col_function.lastIndexOf(DELIMITER) + 1))) continue;
                list.add(function);
            }
        }
        char[] retValue = new char[list.size()];
        for (i = 0; i < retValue.length; ++i) {
            retValue[i] = ((String)list.get(i)).charAt(0);
        }
        return retValue;
    }

    public boolean isFunctionColumn(String columnName, char function) {
        if (columnName == null || this.m_functions.size() == 0) {
            return false;
        }
        String key = columnName + DELIMITER + function;
        for (int i = 0; i < this.m_functions.size(); ++i) {
            String f = this.m_functions.get(i);
            if (!f.equals(key)) continue;
            return true;
        }
        return false;
    }

    public void addValue(String functionColumnName, BigDecimal functionValue) {
        if (!this.isFunctionColumn(functionColumnName)) {
            return;
        }
        for (int i = 0; i < this.m_groups.size(); ++i) {
            String groupColumnName = this.m_groups.get(i);
            String key = groupColumnName + DELIMITER + functionColumnName;
            PrintDataFunction pdf = this.m_groupFunction.get(key);
            if (pdf == null) {
                pdf = new PrintDataFunction();
            }
            pdf.addValue(functionValue);
            this.m_groupFunction.put(key, pdf);
        }
    }

    public BigDecimal getValue(String groupColumnName, String functionColumnName, char function) {
        String key = groupColumnName + DELIMITER + functionColumnName;
        PrintDataFunction pdf = this.m_groupFunction.get(key);
        if (pdf == null) {
            return null;
        }
        return pdf.getValue(function);
    }

    public void reset(String groupColumnName, String functionColumnName) {
        String key = groupColumnName + DELIMITER + functionColumnName;
        PrintDataFunction pdf = this.m_groupFunction.get(key);
        if (pdf != null) {
            pdf.reset();
        }
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean withData) {
        Object value;
        int i;
        StringBuffer sb = new StringBuffer("PrintDataGroup[");
        sb.append("Groups=");
        for (i = 0; i < this.m_groups.size(); ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(this.m_groups.get(i));
        }
        if (withData) {
            for (String key : this.m_groupMap.keySet()) {
                value = this.m_groupMap.get(key);
                sb.append(":").append((Object)key).append("=").append(value);
            }
        }
        sb.append(";Functions=");
        for (i = 0; i < this.m_functions.size(); ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(this.m_functions.get(i));
        }
        if (withData) {
            for (String key : this.m_groupFunction.keySet()) {
                value = this.m_groupFunction.get(key);
                sb.append(":").append((Object)key).append("=").append(value);
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

