/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print.layout;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import org.compiere.framework.Query;
import org.compiere.print.layout.PrintElement;
import org.compiere.util.Ctx;
import org.compiere.util.Msg;

public class Page {
    public static final String CONTEXT_PAGE = "*Page";
    public static final String CONTEXT_PAGECOUNT = "*PageCount";
    public static final String CONTEXT_MULTIPAGE = "*MultiPageInfo";
    public static final String CONTEXT_COPY = "*CopyInfo";
    public static final String CONTEXT_REPORTNAME = "*ReportName";
    public static final String CONTEXT_HEADER = "*Header";
    public static final String CONTEXT_DATE = "*CurrentDate";
    public static final String CONTEXT_TIME = "*CurrentDateTime";
    private int m_pageNo;
    private int m_pageCount = 1;
    private String m_pageInfo;
    private Ctx m_ctx;
    private ArrayList<PrintElement> m_elements = new ArrayList();

    public Page(Ctx ctx, int pageNo) {
        this.m_ctx = ctx;
        this.m_pageNo = pageNo;
        if (this.m_pageInfo == null || this.m_pageInfo.length() == 0) {
            this.m_pageInfo = String.valueOf(this.m_pageNo);
        }
    }

    public int getPageNo() {
        return this.m_pageNo;
    }

    public String getPageInfo() {
        return this.m_pageInfo;
    }

    public void setPageInfo(String pageInfo) {
        if (this.m_pageInfo == null || this.m_pageInfo.length() == 0) {
            this.m_pageInfo = String.valueOf(this.m_pageNo);
        }
        this.m_pageInfo = pageInfo;
    }

    public void setPageCount(int pageCount) {
        this.m_pageCount = pageCount;
    }

    public void addElement(PrintElement element) {
        if (element != null) {
            this.m_elements.add(element);
        }
    }

    public void paint(Graphics2D g2D, Rectangle bounds, boolean isView, boolean isCopy) {
        this.m_ctx.put((Object)CONTEXT_PAGE, (Object)this.m_pageInfo);
        StringBuffer sb = new StringBuffer();
        if (this.m_pageCount != 1) {
            sb.append(Msg.getMsg((Ctx)this.m_ctx, (String)"Page")).append(" ").append(this.m_pageNo).append(" ").append(Msg.getMsg((Ctx)this.m_ctx, (String)"of")).append(" ").append(this.m_pageCount);
        }
        sb.append(" ");
        this.m_ctx.put((Object)CONTEXT_MULTIPAGE, (Object)sb.toString());
        sb = new StringBuffer();
        if (isCopy) {
            sb.append("(").append(Msg.getMsg((Ctx)this.m_ctx, (String)"DocumentCopy")).append(")");
        }
        sb.append(" ");
        this.m_ctx.put((Object)CONTEXT_COPY, (Object)sb.toString());
        g2D.setColor(Color.white);
        g2D.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        Point pageStart = new Point(bounds.getLocation());
        for (int i = 0; i < this.m_elements.size(); ++i) {
            PrintElement e = this.m_elements.get(i);
            e.paint(g2D, this.m_pageNo, pageStart, this.m_ctx, isView);
        }
    }

    public Query getDrillDown(Point relativePoint) {
        Query retValue = null;
        for (int i = 0; i < this.m_elements.size() && retValue == null; ++i) {
            PrintElement element = this.m_elements.get(i);
            retValue = element.getDrillDown(relativePoint, this.m_pageNo);
        }
        return retValue;
    }

    public Query getDrillAcross(Point relativePoint) {
        Query retValue = null;
        for (int i = 0; i < this.m_elements.size() && retValue == null; ++i) {
            PrintElement element = this.m_elements.get(i);
            retValue = element.getDrillAcross(relativePoint, this.m_pageNo);
        }
        return retValue;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Page[");
        sb.append(this.m_pageNo).append(",Elements=").append(this.m_elements.size());
        sb.append("]");
        return sb.toString();
    }
}

