/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.util.ObjectUtils;

public class StandardEntityCollection
implements EntityCollection,
Cloneable,
Serializable {
    private Collection entities = new ArrayList();

    public void clear() {
        this.entities.clear();
    }

    public void addEntity(ChartEntity entity) {
        this.entities.add(entity);
    }

    public void addEntities(EntityCollection collection) {
        this.entities.addAll(collection.getEntities());
    }

    public ChartEntity getEntity(double x, double y) {
        ChartEntity result = null;
        Iterator iterator = this.entities.iterator();
        while (iterator.hasNext()) {
            ChartEntity entity = (ChartEntity)iterator.next();
            if (!entity.getArea().contains(x, y)) continue;
            result = entity;
        }
        return result;
    }

    public Collection getEntities() {
        return Collections.unmodifiableCollection(this.entities);
    }

    public Iterator iterator() {
        return this.entities.iterator();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof StandardEntityCollection) {
            StandardEntityCollection c = (StandardEntityCollection)obj;
            return ObjectUtils.equal(this.entities, c.entities);
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

