/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractXYItemRenderer;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.chart.renderer.XYItemRendererState;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class XYStepRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    public XYStepRenderer() {
    }

    public XYStepRenderer(XYToolTipGenerator toolTipGenerator, XYURLGenerator urlGenerator) {
        this.setToolTipGenerator(toolTipGenerator);
        this.setURLGenerator(urlGenerator);
    }

    public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        EntityCollection entities;
        PlotOrientation orientation = plot.getOrientation();
        Paint seriesPaint = this.getItemPaint(series, item);
        Stroke seriesStroke = this.getItemStroke(series, item);
        g2.setPaint(seriesPaint);
        g2.setStroke(seriesStroke);
        Number x1 = dataset.getXValue(series, item);
        Number y1 = dataset.getYValue(series, item);
        if (y1 == null) {
            return;
        }
        RectangleEdge xAxisLocation = plot.getDomainAxisEdge();
        RectangleEdge yAxisLocation = plot.getRangeAxisEdge();
        double transX1 = domainAxis.valueToJava2D(x1.doubleValue(), dataArea, xAxisLocation);
        double transY1 = rangeAxis.valueToJava2D(y1.doubleValue(), dataArea, yAxisLocation);
        if (item > 0) {
            Number x0 = dataset.getXValue(series, item - 1);
            Number y0 = dataset.getYValue(series, item - 1);
            if (y0 != null) {
                double transX0 = domainAxis.valueToJava2D(x0.doubleValue(), dataArea, xAxisLocation);
                double transY0 = rangeAxis.valueToJava2D(y0.doubleValue(), dataArea, yAxisLocation);
                Line2D line = state.workingLine;
                if (orientation == PlotOrientation.HORIZONTAL) {
                    if (transY0 == transY1) {
                        line.setLine(transY0, transX0, transY1, transX1);
                        g2.draw(line);
                    } else {
                        line.setLine(transY0, transX0, transY1, transX0);
                        g2.draw(line);
                        line.setLine(transY1, transX0, transY1, transX1);
                        g2.draw(line);
                    }
                } else if (orientation == PlotOrientation.VERTICAL) {
                    if (transY0 == transY1) {
                        line.setLine(transX0, transY0, transX1, transY1);
                        g2.draw(line);
                    } else {
                        line.setLine(transX0, transY0, transX1, transY0);
                        g2.draw(line);
                        line.setLine(transX1, transY0, transX1, transY1);
                        g2.draw(line);
                    }
                }
            }
        }
        this.updateCrosshairValues(crosshairState, x1.doubleValue(), y1.doubleValue(), transX1, transY1, orientation);
        if (state.getInfo() != null && (entities = state.getInfo().getOwner().getEntityCollection()) != null) {
            Rectangle2D.Double shape;
            Rectangle2D.Double double_ = shape = orientation == PlotOrientation.VERTICAL ? new Rectangle2D.Double(transX1 - 2.0, transY1 - 2.0, 4.0, 4.0) : new Rectangle2D.Double(transY1 - 2.0, transX1 - 2.0, 4.0, 4.0);
            if (shape != null) {
                String tip = null;
                XYToolTipGenerator generator = this.getToolTipGenerator(series, item);
                if (generator != null) {
                    tip = generator.generateToolTip(dataset, series, item);
                }
                String url = null;
                if (this.getURLGenerator() != null) {
                    url = this.getURLGenerator().generateURL(dataset, series, item);
                }
                XYItemEntity entity = new XYItemEntity(shape, dataset, series, item, tip, url);
                entities.addEntity(entity);
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

