/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Widget;

public abstract class CellPanel
extends ComplexPanel {
    private int spacing;
    private Element table = DOM.createTable();
    private Element body = DOM.createTBody();

    public CellPanel() {
        DOM.appendChild(this.table, this.body);
        this.setElement(this.table);
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setBorderWidth(int width) {
        DOM.setElementProperty(this.table, "border", "" + width);
    }

    public void setCellHeight(Widget w, String height) {
        Element td = DOM.getParent(w.getElement());
        DOM.setElementProperty(td, "height", height);
    }

    public void setCellHorizontalAlignment(Widget w, HasHorizontalAlignment.HorizontalAlignmentConstant align) {
        Element td = this.getWidgetTd(w);
        if (td != null) {
            this.setCellHorizontalAlignment(td, align);
        }
    }

    public void setCellVerticalAlignment(Widget w, HasVerticalAlignment.VerticalAlignmentConstant align) {
        Element td = this.getWidgetTd(w);
        if (td != null) {
            this.setCellVerticalAlignment(td, align);
        }
    }

    public void setCellWidth(Widget w, String width) {
        Element td = DOM.getParent(w.getElement());
        DOM.setElementProperty(td, "width", width);
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
        DOM.setElementPropertyInt(this.table, "cellSpacing", spacing);
    }

    protected Element getBody() {
        return this.body;
    }

    protected Element getTable() {
        return this.table;
    }

    protected void setCellHorizontalAlignment(Element td, HasHorizontalAlignment.HorizontalAlignmentConstant align) {
        DOM.setElementProperty(td, "align", align.getTextAlignString());
    }

    protected void setCellVerticalAlignment(Element td, HasVerticalAlignment.VerticalAlignmentConstant align) {
        DOM.setStyleAttribute(td, "verticalAlign", align.getVerticalAlignString());
    }

    private Element getWidgetTd(Widget w) {
        if (w.getParent() != this) {
            return null;
        }
        return DOM.getParent(w.getElement());
    }
}

