/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DisclosureEvent;
import com.google.gwt.user.client.ui.DisclosureHandler;
import com.google.gwt.user.client.ui.DisclosurePanelImages;
import com.google.gwt.user.client.ui.FiresDisclosureEvents;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.ui.WidgetIterators;
import java.util.ArrayList;
import java.util.Iterator;

public final class DisclosurePanel
extends Composite
implements FiresDisclosureEvents,
HasWidgets {
    private static final String STYLENAME_DEFAULT = "gwt-DisclosurePanel";
    private static final String STYLENAME_SUFFIX_OPEN = "open";
    private static final String STYLENAME_SUFFIX_CLOSED = "closed";
    private static final String STYLENAME_HEADER = "header";
    private static final String STYLENAME_CONTENT = "content";
    private final VerticalPanel mainPanel = new VerticalPanel();
    private final ClickableHeader header = new ClickableHeader();
    private Widget content;
    private boolean isOpen = false;
    private ArrayList handlers;

    private static DisclosurePanelImages createDefaultImages() {
        return (DisclosurePanelImages)GWT.create(DisclosurePanelImages.class);
    }

    public DisclosurePanel() {
        this.init(false);
    }

    public DisclosurePanel(DisclosurePanelImages images, String headerText, boolean isOpen) {
        this.init(isOpen);
        this.setHeader(new DefaultHeader(images, headerText));
    }

    public DisclosurePanel(String headerText) {
        this(DisclosurePanel.createDefaultImages(), headerText, false);
    }

    public DisclosurePanel(String headerText, boolean isOpen) {
        this(DisclosurePanel.createDefaultImages(), headerText, isOpen);
    }

    public DisclosurePanel(Widget header) {
        this(header, false);
    }

    public DisclosurePanel(Widget header, boolean isOpen) {
        this.init(isOpen);
        this.setHeader(header);
    }

    public void add(Widget w) {
        if (this.getContent() != null) {
            throw new IllegalStateException("A DisclosurePanel can only contain two Widgets.");
        }
        this.setContent(w);
    }

    public final void addEventHandler(DisclosureHandler handler) {
        if (this.handlers == null) {
            this.handlers = new ArrayList();
        }
        this.handlers.add(handler);
    }

    public void clear() {
        this.setContent(null);
    }

    public final Widget getContent() {
        return this.content;
    }

    public final Widget getHeader() {
        return this.header.getWidget();
    }

    public final HasText getHeaderTextAccessor() {
        Widget widget = this.header.getWidget();
        return widget instanceof HasText ? (HasText)((Object)widget) : null;
    }

    public final boolean isOpen() {
        return this.isOpen;
    }

    public Iterator iterator() {
        return WidgetIterators.createWidgetIterator(this, new Widget[]{this.getContent()});
    }

    public boolean remove(Widget w) {
        if (w == this.getContent()) {
            this.setContent(null);
            return true;
        }
        return false;
    }

    public final void removeEventHandler(DisclosureHandler handler) {
        if (this.handlers == null) {
            return;
        }
        this.handlers.remove(handler);
    }

    public final void setContent(Widget content) {
        Widget currentContent = this.content;
        if (currentContent != null) {
            this.mainPanel.remove(currentContent);
            currentContent.removeStyleName(STYLENAME_CONTENT);
        }
        this.content = content;
        if (content != null) {
            this.mainPanel.add(content);
            content.addStyleName(STYLENAME_CONTENT);
            this.setContentDisplay();
        }
    }

    public final void setHeader(Widget headerWidget) {
        this.header.setWidget(headerWidget);
    }

    public final void setOpen(boolean isOpen) {
        if (this.isOpen != isOpen) {
            this.isOpen = isOpen;
            this.setContentDisplay();
            this.fireEvent();
        }
    }

    private void fireEvent() {
        if (this.handlers == null) {
            return;
        }
        DisclosureEvent event = new DisclosureEvent(this);
        Iterator it = this.handlers.iterator();
        while (it.hasNext()) {
            DisclosureHandler handler = (DisclosureHandler)it.next();
            if (this.isOpen) {
                handler.onOpen(event);
                continue;
            }
            handler.onClose(event);
        }
    }

    private void init(boolean isOpen) {
        this.initWidget(this.mainPanel);
        this.mainPanel.add(this.header);
        this.isOpen = isOpen;
        this.setStyleName(STYLENAME_DEFAULT);
        this.setContentDisplay();
    }

    private void setContentDisplay() {
        if (this.isOpen) {
            this.removeStyleDependentName(STYLENAME_SUFFIX_CLOSED);
            this.addStyleDependentName(STYLENAME_SUFFIX_OPEN);
        } else {
            this.removeStyleDependentName(STYLENAME_SUFFIX_OPEN);
            this.addStyleDependentName(STYLENAME_SUFFIX_CLOSED);
        }
        if (this.content != null) {
            this.content.setVisible(this.isOpen);
        }
    }

    private class DefaultHeader
    extends Widget
    implements HasText,
    DisclosureHandler {
        private final Element labelTD;
        private final Image iconImage;
        private final DisclosurePanelImages images;

        private DefaultHeader(DisclosurePanelImages images, String text) {
            this.images = images;
            this.iconImage = DisclosurePanel.this.isOpen ? images.disclosurePanelOpen().createImage() : images.disclosurePanelClosed().createImage();
            Element root = DOM.createTable();
            Element tbody = DOM.createTBody();
            Element tr = DOM.createTR();
            Element imageTD = DOM.createTD();
            this.labelTD = DOM.createTD();
            this.setElement(root);
            DOM.appendChild(root, tbody);
            DOM.appendChild(tbody, tr);
            DOM.appendChild(tr, imageTD);
            DOM.appendChild(tr, this.labelTD);
            DOM.setElementProperty(imageTD, "align", "center");
            DOM.setElementProperty(imageTD, "valign", "middle");
            DOM.setStyleAttribute(imageTD, "width", this.iconImage.getWidth() + "px");
            DOM.appendChild(imageTD, this.iconImage.getElement());
            this.setText(text);
            DisclosurePanel.this.addEventHandler(this);
            this.setStyle();
        }

        public final String getText() {
            return DOM.getInnerText(this.labelTD);
        }

        public final void onClose(DisclosureEvent event) {
            this.setStyle();
        }

        public final void onOpen(DisclosureEvent event) {
            this.setStyle();
        }

        public final void setText(String text) {
            DOM.setInnerText(this.labelTD, text);
        }

        private void setStyle() {
            if (DisclosurePanel.this.isOpen) {
                this.images.disclosurePanelOpen().applyTo(this.iconImage);
            } else {
                this.images.disclosurePanelClosed().applyTo(this.iconImage);
            }
        }
    }

    private final class ClickableHeader
    extends SimplePanel {
        private ClickableHeader() {
            super(DOM.createAnchor());
            Element elem = this.getElement();
            DOM.setElementProperty(elem, "href", "javascript:void(0);");
            DOM.setStyleAttribute(elem, "display", "block");
            this.sinkEvents(1);
            this.setStyleName(DisclosurePanel.STYLENAME_HEADER);
        }

        public final void onBrowserEvent(Event event) {
            switch (DOM.eventGetType(event)) {
                case 1: {
                    DOM.eventPreventDefault(event);
                    DisclosurePanel.this.setOpen(!DisclosurePanel.this.isOpen);
                }
            }
        }
    }
}

