/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.ClickListenerCollection;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.HasWordWrap;
import com.google.gwt.user.client.ui.MouseListener;
import com.google.gwt.user.client.ui.MouseListenerCollection;
import com.google.gwt.user.client.ui.MouseWheelListener;
import com.google.gwt.user.client.ui.MouseWheelListenerCollection;
import com.google.gwt.user.client.ui.SourcesClickEvents;
import com.google.gwt.user.client.ui.SourcesMouseEvents;
import com.google.gwt.user.client.ui.SourcesMouseWheelEvents;
import com.google.gwt.user.client.ui.Widget;

public class Label
extends Widget
implements SourcesClickEvents,
SourcesMouseEvents,
SourcesMouseWheelEvents,
HasHorizontalAlignment,
HasText,
HasWordWrap {
    private ClickListenerCollection clickListeners;
    private HasHorizontalAlignment.HorizontalAlignmentConstant horzAlign;
    private MouseListenerCollection mouseListeners;
    private MouseWheelListenerCollection mouseWheelListeners;

    public Label() {
        this.setElement(DOM.createDiv());
        this.sinkEvents(131197);
        this.setStyleName("gwt-Label");
    }

    public Label(String text) {
        this();
        this.setText(text);
    }

    public Label(String text, boolean wordWrap) {
        this(text);
        this.setWordWrap(wordWrap);
    }

    public void addClickListener(ClickListener listener) {
        if (this.clickListeners == null) {
            this.clickListeners = new ClickListenerCollection();
        }
        this.clickListeners.add(listener);
    }

    public void addMouseListener(MouseListener listener) {
        if (this.mouseListeners == null) {
            this.mouseListeners = new MouseListenerCollection();
        }
        this.mouseListeners.add(listener);
    }

    public void addMouseWheelListener(MouseWheelListener listener) {
        if (this.mouseWheelListeners == null) {
            this.mouseWheelListeners = new MouseWheelListenerCollection();
        }
        this.mouseWheelListeners.add(listener);
    }

    public HasHorizontalAlignment.HorizontalAlignmentConstant getHorizontalAlignment() {
        return this.horzAlign;
    }

    public String getText() {
        return DOM.getInnerText(this.getElement());
    }

    public boolean getWordWrap() {
        return !DOM.getStyleAttribute(this.getElement(), "whiteSpace").equals("nowrap");
    }

    public void onBrowserEvent(Event event) {
        switch (DOM.eventGetType(event)) {
            case 1: {
                if (this.clickListeners == null) break;
                this.clickListeners.fireClick(this);
                break;
            }
            case 4: 
            case 8: 
            case 16: 
            case 32: 
            case 64: {
                if (this.mouseListeners == null) break;
                this.mouseListeners.fireMouseEvent(this, event);
                break;
            }
            case 131072: {
                if (this.mouseWheelListeners == null) break;
                this.mouseWheelListeners.fireMouseWheelEvent(this, event);
            }
        }
    }

    public void removeClickListener(ClickListener listener) {
        if (this.clickListeners != null) {
            this.clickListeners.remove(listener);
        }
    }

    public void removeMouseListener(MouseListener listener) {
        if (this.mouseListeners != null) {
            this.mouseListeners.remove(listener);
        }
    }

    public void removeMouseWheelListener(MouseWheelListener listener) {
        if (this.mouseWheelListeners != null) {
            this.mouseWheelListeners.remove(listener);
        }
    }

    public void setHorizontalAlignment(HasHorizontalAlignment.HorizontalAlignmentConstant align) {
        this.horzAlign = align;
        DOM.setStyleAttribute(this.getElement(), "textAlign", align.getTextAlignString());
    }

    public void setText(String text) {
        DOM.setInnerText(this.getElement(), text);
    }

    public void setWordWrap(boolean wrap) {
        DOM.setStyleAttribute(this.getElement(), "whiteSpace", wrap ? "normal" : "nowrap");
    }
}

